/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.util;

import com.xylink.util.RestMessage;
import com.xylink.util.Result;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class HttpUtil {
    private static String proxyHost;
    private static int proxyPort;

    public static Result getResponse(String surl, String method, String jsonEntity, Class<?> clazz) throws IOException {
        HttpURLConnection conn = HttpUtil.getHttpURLConnection(jsonEntity, surl, method);
        InputStream is = null;
        int status = conn.getResponseCode();
        is = status == 200 || status == 204 ? conn.getInputStream() : conn.getErrorStream();
        String respData = HttpUtil.getResponseData(is);
        conn.disconnect();
        return HttpUtil.getResult(status, respData, clazz);
    }

    public static Result getByteStreamResponse(String surl, String method, String jsonEntity) throws IOException {
        HttpURLConnection conn = HttpUtil.getHttpURLConnection(jsonEntity, surl, method);
        InputStream is = null;
        int status = conn.getResponseCode();
        is = status == 200 || status == 204 ? conn.getInputStream() : conn.getErrorStream();
        byte[] bytes = HttpUtil.getStreamResponse(is);
        conn.disconnect();
        return HttpUtil.getByteResult(status, bytes);
    }

    public static void convertByteArrayToImageOrVideo(byte[] bytes, String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            System.out.println("File Path not found!");
        }
        catch (IOException e) {
            System.out.println("Convert byte array to image,IO Errot!");
        }
    }

    private static HttpURLConnection getHttpURLConnection(String jsonEntity, String surl, String method) throws IOException {
        URL url = new URL(surl);
        HttpURLConnection conn = null;
        if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
            System.out.println("use proxy");
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            conn = (HttpURLConnection)url.openConnection(proxy);
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.addRequestProperty("Accept", "application/json");
        conn.addRequestProperty("Accept-Charset", "UTF-8");
        conn.addRequestProperty("Content-Type", "application/json;charset=utf-8");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        if (jsonEntity != null && !"".equals(jsonEntity.trim())) {
            conn.getOutputStream().write(jsonEntity.getBytes("utf-8"));
        }
        conn.connect();
        return conn;
    }

    private static String getResponseData(InputStream is) throws IOException {
        if (is != null) {
            int n;
            InputStreamReader reader = new InputStreamReader(is, "UTF-8");
            StringBuilder response = new StringBuilder();
            char[] buff = new char[2048];
            while ((n = reader.read(buff)) != -1) {
                response.append(buff, 0, n);
            }
            return response.toString();
        }
        return "";
    }

    private static Result getResult(int status, String respData, Class<?> clazz) {
        ObjectMapper objectMapper = new ObjectMapper();
        int responseCode = 200;
        RestMessage restMessage = null;
        Result<Object> result = new Result<Object>();
        if (status == 200 || status == 204) {
            try {
                result.setSuccess(true);
                if (clazz != null) {
                    if (!clazz.getName().equals(String.class.getName())) {
                        if (respData != null && !"".equals(respData.trim())) {
                            result.setData(objectMapper.readValue(respData, clazz));
                        }
                    } else {
                        result.setData(respData);
                    }
                }
                result.setErrorStatus(responseCode);
            }
            catch (Exception e) {
                System.out.println("JSon String convert to Object error!");
                e.printStackTrace();
            }
        } else {
            result.setErrorStatus(status);
            result.setSuccess(false);
            try {
                restMessage = (RestMessage)objectMapper.readValue(respData, RestMessage.class);
                responseCode = restMessage.getErrorCode();
                result.setData(restMessage);
                result.setErrorStatus(responseCode);
                result.setErrorMsg(restMessage.getUserMessage());
            }
            catch (Exception e) {
                System.out.println("JSon String convert to RestMessage error!");
            }
        }
        return result;
    }

    private static byte[] getStreamResponse(InputStream is) throws IOException {
        if (is != null) {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int rc = 0;
            while ((rc = is.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] bytes = swapStream.toByteArray();
            return bytes;
        }
        return null;
    }

    private static Result getByteResult(int status, byte[] bytes) {
        ObjectMapper objectMapper = new ObjectMapper();
        int responseCode = 200;
        RestMessage restMessage = null;
        Result<Object> result = new Result<Object>();
        if (status == 200 || status == 204) {
            result.setSuccess(true);
            result.setData(bytes);
            result.setErrorStatus(200);
        } else {
            try {
                String respData = new String(bytes);
                restMessage = (RestMessage)objectMapper.readValue(respData, RestMessage.class);
                responseCode = restMessage.getErrorCode();
                result.setSuccess(false);
                result.setData(restMessage);
                result.setErrorStatus(responseCode);
            }
            catch (Exception e) {
                System.out.println("JSon String convert to RestMessage error!");
            }
        }
        return result;
    }

    public static void setProxy(String host, int port) {
        proxyHost = host;
        proxyPort = port;
    }
}

