/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.model;

import com.xylink.model.DepModel;
import com.xylink.model.LiveViewerInvited;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveVideo {
    public static final int TITLE_WIDTH = 32;
    public static final int DETAIL_WIDTH = 128;
    public static final int LOCATION_WIDTH = 64;
    private String enterpriseId;
    private String nemoNumber;
    private String confNo;
    private String title;
    private long startTime;
    private long endTime;
    private String detail;
    private boolean autoRecording;
    private boolean autoPublishRecording;
    private String location;
    private String thirdpartyPushURL;
    private LiveViewerInvited liveViewerInvited;
    private String thirdpeoplePushURL;
    private String thirdcontentPushURL;
    private List<DepModel> deptInvited;

    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getNemoNumber() {
        return this.nemoNumber;
    }

    public void setNemoNumber(String nemoNumber) {
        this.nemoNumber = nemoNumber;
    }

    public String getConfNo() {
        return this.confNo;
    }

    public void setConfNo(String confNo) {
        this.confNo = confNo;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isAutoRecording() {
        return this.autoRecording;
    }

    public void setAutoRecording(boolean autoRecording) {
        this.autoRecording = autoRecording;
    }

    public boolean isAutoPublishRecording() {
        return this.autoPublishRecording;
    }

    public void setAutoPublishRecording(boolean autoPublishRecording) {
        this.autoPublishRecording = autoPublishRecording;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getThirdpartyPushURL() {
        return this.thirdpartyPushURL;
    }

    public void setThirdpartyPushURL(String thirdpartyPushURL) {
        this.thirdpartyPushURL = thirdpartyPushURL;
    }

    public boolean valid() {
        long now = System.currentTimeMillis();
        if (now >= this.startTime) {
            return false;
        }
        if (this.startTime >= this.endTime) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.title)) {
            return false;
        }
        if (this.title.length() > 32) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)this.detail) && this.detail.length() > 128) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)this.location) || this.location.length() <= 64;
    }

    public LiveViewerInvited getLiveViewerInvited() {
        return this.liveViewerInvited;
    }

    public void setLiveViewerInvited(LiveViewerInvited liveViewerInvited) {
        this.liveViewerInvited = liveViewerInvited;
    }

    public String getThirdpeoplePushURL() {
        return this.thirdpeoplePushURL;
    }

    public void setThirdpeoplePushURL(String thirdpeoplePushURL) {
        this.thirdpeoplePushURL = thirdpeoplePushURL;
    }

    public String getThirdcontentPushURL() {
        return this.thirdcontentPushURL;
    }

    public void setThirdcontentPushURL(String thirdcontentPushURL) {
        this.thirdcontentPushURL = thirdcontentPushURL;
    }

    public boolean invalid() {
        return !this.valid();
    }

    public List<DepModel> getDeptInvited() {
        return this.deptInvited;
    }

    public void setDeptInvited(List<DepModel> deptInvited) {
        this.deptInvited = deptInvited;
    }

    public String toString() {
        return "{\"LiveVideo\":{\"enterpriseId\":\"" + this.enterpriseId + '\"' + ",\"nemoNumber\":\"" + this.nemoNumber + '\"' + ",\"confNo\":\"" + this.confNo + '\"' + ",\"title\":\"" + this.title + '\"' + ",\"startTime\":" + this.startTime + ",\"endTime\":" + this.endTime + ",\"detail\":\"" + this.detail + '\"' + ",\"autoRecording\":" + this.autoRecording + ",\"autoPublishRecording\":" + this.autoPublishRecording + ",\"location\":\"" + this.location + '\"' + ",\"thirdpartyPushURL\":\"" + this.thirdpartyPushURL + '\"' + ",\"liveViewerInvited\":" + this.liveViewerInvited + ",\"thirdpeoplePushURL\":\"" + this.thirdpeoplePushURL + '\"' + ",\"thirdcontentPushURL\":\"" + this.thirdcontentPushURL + '\"' + ",\"deptInvited\":" + this.deptInvited + "}}";
    }
}

