/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.conferenceControl;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.ConferenceMeetingRoom;
import com.xylink.model.Pager;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class CloudMeetingRoomApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrlMeetingInfo = "/api/rest/external/v1/conference/";

    public Result<Pager<ConferenceMeetingRoom>> getCloudMeetingRooms(String enterpriseId, String token, String type, int page, int size) throws IOException {
        String surl = this.getMeetingInfoPrefixUrl() + "cloudConference?enterpriseId=" + enterpriseId + "&type=" + type + "&page=" + page + "&size=" + size;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<ConferenceMeetingRoom>> result = new Result<Pager<ConferenceMeetingRoom>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (result.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<ConferenceMeetingRoom>>(){});
            result.setData(pager);
        }
        return result;
    }

    private String getMeetingInfoPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrlMeetingInfo;
    }
}

