/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.conferenceControl;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.CallInviteRequest;
import com.xylink.model.CurrentMeeting;
import com.xylink.model.Device;
import com.xylink.model.DeviceMultiImageRequest;
import com.xylink.model.DeviceNotification;
import com.xylink.model.LiveLayoutRequest;
import com.xylink.model.MeetingControlSubtitleRequest;
import com.xylink.model.MeetingRoom;
import com.xylink.model.MeetingStatus;
import com.xylink.model.MeetingSubtitleRequest;
import com.xylink.model.Pager;
import com.xylink.model.ShareAuthTarget;
import com.xylink.model.statis.CurrentMeetingDetail;
import com.xylink.model.statis.MeetingParticipant;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ConferenceControlApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/conferenceControl/";
    private static final String prefixUrlMeetingInfo = "/api/rest/external/v1/meetingInfo/";

    public Result<MeetingStatus> getMeetingStatus(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meetingStatus?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, MeetingStatus.class);
    }

    public Result inviteNemoCall(String enterpriseId, String token, String nemoNumber, MeetingRoom meetingRoom) throws IOException {
        String surl = this.getPrefixUrl() + "nemo/" + nemoNumber + "/invitation?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)meetingRoom);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result inviteCall(String enterpriseId, String token, CallInviteRequest callInviteRequest) throws IOException {
        String surl = this.getPrefixUrl() + "invitation?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)callInviteRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result disconnect(String enterpriseId, String token, String callNumber, Device[] devices) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/disconnect?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)devices);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result disconnect(String enterpriseId, String token, String callNumber, String jsonEntity) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/disconnect?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    @Deprecated
    public Result changeMode(String enterpriseId, String token, String meetingRoomNumber, int mode, Device device) throws IOException {
        String surl = this.getPrefixUrl() + meetingRoomNumber + "/changeMode?enterpriseId=" + enterpriseId + "&mode=" + mode;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)device);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result setMainImage(String enterpriseId, String token, String meetingRoomNumber, Device device) throws IOException {
        String surl = this.getPrefixUrl() + meetingRoomNumber + "/mainImage?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)device);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    @Deprecated
    public Result<CurrentMeeting[]> getEnterpriseCurrentMeeting(String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "currentMeeting?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, CurrentMeeting[].class);
    }

    public Result<Pager<CurrentMeeting>> getEnterpriseCurrentMeeting(String enterpriseId, String token, int page, int size) throws IOException {
        String surl = this.getPrefixUrl() + "currentMeeting/page?enterpriseId=" + enterpriseId + "&pageIndex=" + page + "&pageSize=" + size;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<CurrentMeeting>> result = new Result<Pager<CurrentMeeting>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (resp.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<CurrentMeeting>>(){});
            result.setData(pager);
        }
        return result;
    }

    public Result<Pager<MeetingParticipant>> getCurrentMeetingParticipant(String enterpriseId, String token, int page, int size, String meetingId) throws IOException {
        String surl = this.getPrefixUrl() + "currentMeeting/participant/" + meetingId + "/page?enterpriseId=" + enterpriseId + "&pageIndex=" + page + "&pageSize=" + size;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<MeetingParticipant>> result = new Result<Pager<MeetingParticipant>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (resp.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<MeetingParticipant>>(){});
            result.setData(pager);
        }
        return result;
    }

    public Result<CurrentMeeting> getEnterpriseCurrentMeeting(String enterpriseId, String token, String conferenceNumber) throws IOException {
        String surl = this.getPrefixUrl() + "conference/currentMeeting?conferenceNumber=" + conferenceNumber + "&enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, CurrentMeeting.class);
    }

    public Result mute(String enterpriseId, String token, String callNumber, Device[] devices) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/mute?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)devices);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result clearAll(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/hands/clearAll?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result muteall(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/muteall?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result unmute(String enterpriseId, String token, String callNumber, Device[] devices) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/unmute?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)devices);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result end(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/end?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result endAndReleaseNumber(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/endandrelease?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result authShare(String enterpriseId, String token, String callNumber, ShareAuthTarget target) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/content/authShare?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)target);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result meetingLock(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/lock?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result meetingUnlock(String enterpriseId, String token, String callNumber) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/unlock?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", null, null);
    }

    public Result sendMessage(String enterpriseId, String token, String callNumber, MeetingSubtitleRequest meetSubtitleReq) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/sendMsg?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)meetSubtitleReq);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result notifyDevice(String enterpriseId, String token, DeviceNotification deviceNotification) throws IOException {
        String surl = this.getPrefixUrl() + "notify?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)deviceNotification);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result<CurrentMeetingDetail[]> getEnterpriseCurrentMeetingDetail(String enterpriseId, String token, boolean needQuality) throws IOException {
        String surl = this.getPrefixUrl() + "currentMeeting/detail?enterpriseId=" + enterpriseId + "&needQuality=" + needQuality;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", CurrentMeetingDetail[].class);
    }

    public Result<CurrentMeetingDetail> getEnterpriseCurrentSpecificMeetingDetail(String enterpriseId, String token, String conferenceNumber, boolean needQuality) throws IOException {
        String surl = this.getPrefixUrl() + "currentMeeting/" + conferenceNumber + "/detail?enterpriseId=" + enterpriseId + "&needQuality=" + needQuality;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", CurrentMeetingDetail.class);
    }

    public Result hangUp(String enterpriseId, String token, String nemoNumber) throws IOException {
        String surl = this.getPrefixUrl() + "nemo/" + nemoNumber + "/hangup?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", "", null);
    }

    public Result startDeviceMultiImage(String enterpriseId, String token, String callNumber, DeviceMultiImageRequest deviceMultiImageRequest) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/startDeviceMultiImage?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)deviceMultiImageRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result stopDeviceMultiImage(String enterpriseId, String token, String callNumber, DeviceMultiImageRequest deviceMultiImageRequest) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/stopDeviceMultiImage?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)deviceMultiImageRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result subtitle(String enterpriseId, String token, String callNumber, MeetingControlSubtitleRequest meetingControlSubtitleRequest) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/subtitle?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)meetingControlSubtitleRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result liveContentLayout(String enterpriseId, String token, String callNumber, LiveLayoutRequest liveLayoutRequest) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/liveContentLayout?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveLayoutRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result livePeopleLayout(String enterpriseId, String token, String callNumber, LiveLayoutRequest liveLayoutRequest) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/meeting/livePeopleLayout?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveLayoutRequest);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, null);
    }

    public Result onhold(String enterpriseId, String token, String callNumber, String action, Device[] devices) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/hold?enterpriseId=" + enterpriseId + "&action=" + action;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)devices);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result confStatus(String enterpriseId, String token, List<String> callNumberList) throws IOException {
        String surl = this.getPrefixUrl() + "meetings/status?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString(callNumberList);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result speaker(String enterpriseId, String token, String callNumber, String action, Device device) throws IOException {
        String surl = this.getPrefixUrl() + callNumber + "/speaker?enterpriseId=" + enterpriseId + "&action=" + action;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)device);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }

    private String getMeetingInfoPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrlMeetingInfo;
    }
}

