/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.dating;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.ReminderMeeting;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;

public class WechatApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/";

    public Result remindMeeting(String enterpriseId, String token, ReminderMeeting reminderMeeting, int maxParticipantCount, long meetingOwnerId) throws IOException {
        String surl = this.getPrefixUrl() + "wechat/meetingreminders?enterpriseId=" + enterpriseId + "&maxParticipant=" + maxParticipantCount + "&meetingOwnerId=" + meetingOwnerId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)reminderMeeting);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, Map.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

