/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.device;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.DeviceInfo;
import com.xylink.model.DeviceInfoDetail;
import com.xylink.model.Pager;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class DeviceStatusApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/deviceInfo";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Result<DeviceInfo> getDeviceInfo(String enterpriseId, String token, String number) throws IOException {
        String surl = this.getPrefixUrl() + "/" + number + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, DeviceInfo.class);
    }

    public Result<DeviceInfoDetail> getDeviceInfoDetail(String enterpriseId, String token, String number) throws IOException {
        String surl = this.getPrefixUrl() + "/" + number + "/detail?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, DeviceInfoDetail.class);
    }

    @Deprecated
    public Result<DeviceInfo[]> getDeviceInfo(String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, DeviceInfo[].class);
    }

    public Result<Pager<DeviceInfo>> getDeviceInfo(String enterpriseId, String token, int page, int size) throws IOException {
        String surl = this.getPrefixUrl() + "/page?enterpriseId=" + enterpriseId + "&pageIndex=" + page + "&pageSize=" + size;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        Result resp = HttpUtil.getResponse(surl, "GET", null, String.class);
        Result<Pager<DeviceInfo>> result = new Result<Pager<DeviceInfo>>();
        result.setSuccess(resp.isSuccess());
        result.setErrorStatus(resp.getErrorStatus());
        result.setErrorMsg(resp.getErrorMsg());
        if (resp.isSuccess() && StringUtils.isNotBlank((CharSequence)((CharSequence)resp.getData()))) {
            ObjectMapper objectMapper = new ObjectMapper();
            Pager pager = (Pager)objectMapper.readValue((String)resp.getData(), (TypeReference)new TypeReference<Pager<DeviceInfo>>(){});
            result.setData(pager);
        }
        return result;
    }

    public Result<DeviceInfo[]> getDeviceInfo(String enterpriseId, String token, List<String> snList) throws IOException {
        if (snList == null || snList.size() <= 0) {
            return null;
        }
        String surl = this.getPrefixUrl() + "?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString(snList);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, DeviceInfo[].class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

