/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.distributor;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.BuffetAddEnterpriseReq;
import com.xylink.model.EnterpriseUserReq;
import com.xylink.model.UserAdminReq;
import com.xylink.model.UserDeviceDto;
import com.xylink.model.UserReq;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class DistributorApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/";

    public Result addEnterprise(String distributorId, String token, BuffetAddEnterpriseReq buffetAddEnterpriseReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)buffetAddEnterpriseReq);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result modifyEnterprise(String distributorId, String enterpriseId, String token, BuffetAddEnterpriseReq buffetAddEnterpriseReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)buffetAddEnterpriseReq);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result getEnterprises(String distributorId, String token, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise?distributorId=" + distributorId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result batchEnterpriseUsers(String distributorId, String token, List<EnterpriseUserReq> enterpriseUserReqs) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/batch/enterprise?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString(enterpriseUserReqs);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result modifyUser(String distributorId, String token, UserReq userReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)userReq);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result deleteUserByUserId(String distributorId, String token, String userProfileId) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user?distributorId=" + distributorId + "&userProfileId=" + userProfileId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", "", String.class);
    }

    public Result getUserByUserId(String distributorId, String token, String userProfileId) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user?distributorId=" + distributorId + "&userProfileId=" + userProfileId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getUsers(String distributorId, String token, String enterpriseId, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/users?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getNemosPage(String distributorId, String token, String enterpriseId, boolean needDept, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/nemos/page?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&needDept=" + needDept + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getDevicesInfoPage(String distributorId, String token, String enterpriseId, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/devicesInfo/page?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result editDevice(String distributorId, String token, String enterpriseId, String nemoNumber, String displayName) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/editDevice?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&nemoNumber=" + nemoNumber + "&displayName=" + URLEncoder.encode(displayName, "utf-8");
        String signature = signatureSample.computeSignature("", "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", "", null);
    }

    public Result addDevice(String distributorId, String token, String enterpriseId, List<UserDeviceDto> userDeviceDtos) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/addDevice?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString(userDeviceDtos);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result removeDevice(String distributorId, String token, String enterpriseId, String nemoNumber) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/removeDevice?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&nemoNumber=" + nemoNumber;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", "", String.class);
    }

    public Result getNemoMeetingPage(String distributorId, String token, String enterpriseId, String nemoNumber, Long timeBegin, Long timeEnd, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/meeting/nemo/page?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&nemoNumber=" + nemoNumber + "&timeBegin=" + timeBegin + "&timeEnd=" + timeEnd + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getConferenceCurrentMeetingPage(String distributorId, String token, String enterpriseId, String conferenceNumber, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/currentMeeting/conference/page?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&conferenceNumber=" + conferenceNumber + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getEnterpriseCurrentMeetingPage(String distributorId, String token, String enterpriseId, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/currentMeeting/enterprise/page?distributorId=" + distributorId + "&enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result addUserAdmin(String distributorId, String token, UserAdminReq userAdminReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user/admin?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)userAdminReq);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result updateUserAdmin(String distributorId, String token, UserAdminReq userAdminReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user/admin?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)userAdminReq);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result deleteUserAdmin(String distributorId, String token, UserAdminReq userAdminReq) throws IOException {
        String surl = this.getPrefixUrl() + "distributor/operator/enterprise/user/admin?distributorId=" + distributorId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)userAdminReq);
        String signature = signatureSample.computeSignature(jsonEntity, "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", jsonEntity, String.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

