/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.face;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.CreateFaceUserInfoReq;
import com.xylink.model.FaceUploadReq;
import com.xylink.model.FaceUserInfo;
import com.xylink.model.UserFaceReq;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class AiFaceApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/face";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Result createUser(String enterpriseId, String token, CreateFaceUserInfoReq createFaceUserInfoReq) throws IOException {
        String surl = this.getPrefixUrl() + "/createUser?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString((Object)createFaceUserInfoReq);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result getUserInfoByUserId(String enterpriseId, String token, long faceUserId) throws IOException {
        String surl = this.getPrefixUrl() + "/userInfo?enterpriseId=" + enterpriseId + "&faceUserId=" + faceUserId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result getUserInfoByUserIdBatch(String enterpriseId, String token, List faceUserIds) throws IOException {
        String surl = this.getPrefixUrl() + "/batch/userInfo?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString((Object)faceUserIds);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result getUserIdsByuserIdentifyId(String enterpriseId, String token, String userIdentifyId) throws IOException {
        String surl = this.getPrefixUrl() + "/identify/faceUserInfo?enterpriseId=" + enterpriseId + "&userIdentifyId=" + userIdentifyId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    public Result deleteUser(String enterpriseId, String token, long faceUserId) throws IOException {
        String surl = this.getPrefixUrl() + "/deleteUser?enterpriseId=" + enterpriseId + "&faceUserId=" + faceUserId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", "", String.class);
    }

    public Result updateUser(String enterpriseId, String token, List<FaceUserInfo> userInfos) throws IOException {
        String surl = this.getPrefixUrl() + "/update?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString(userInfos);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result uploadFace(String enterpriseId, String token, FaceUploadReq faceUploadReq) throws IOException {
        String surl = this.getPrefixUrl() + "/uploadFace?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString((Object)faceUploadReq);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, String.class);
    }

    public Result deleteUserFace(String enterpriseId, String token, UserFaceReq userFaceReq) throws IOException {
        String surl = this.getPrefixUrl() + "/deleteUserFace?enterpriseId=" + enterpriseId;
        String jsonEntity = objectMapper.writeValueAsString((Object)userFaceReq);
        String signature = signatureSample.computeSignature(jsonEntity, "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", jsonEntity, String.class);
    }

    public Result allUsersInfo(String enterpriseId, String token, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "/allUsersInfo?enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", "", String.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

