/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.liveVideo.v2;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xylink.config.SDKConfigMgr;
import com.xylink.model.LV;
import com.xylink.model.LiveVideo;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveVideoApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/liveVideo2/enterprise/";

    public Result<LV> newLiveVideo(String enterpriseId, String token, String nemoNumber, LiveVideo liveVideo) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/xiaoyunumber/" + nemoNumber + "/live?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveVideo);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, LV.class);
    }

    public Result updateLiveVideo(String enterpriseId, String token, String nemoNumber, String liveId, LiveVideo liveVideo) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/xiaoyunumber/" + nemoNumber + "/live/" + liveId + "?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveVideo);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result deleteLiveVideo(String enterpriseId, String token, String nemoNumber, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/xiaoyunumber/" + nemoNumber + "/live/" + liveId + "?enterpriseId=" + enterpriseId;
        System.out.println(surl);
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        System.out.println(surl);
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    public Result<LV> getLiveVideo(String enterpriseId, String token, String nemoNumber, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/xiaoyunumber/" + nemoNumber + "/live/" + liveId + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        System.out.println(surl);
        return HttpUtil.getResponse(surl, "GET", null, LV.class);
    }

    public Result<String[]> getVideos(String enterpriseId, String token, String nemoNumber, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/xiaoyunumber/" + nemoNumber + "/live/" + liveId + "/videos?enterpriseId=" + enterpriseId;
        System.out.println(surl);
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        System.out.println(surl);
        return HttpUtil.getResponse(surl, "GET", null, String[].class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

