/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.liveVideo.v3;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.LV;
import com.xylink.model.LiveVideo;
import com.xylink.model.LiveVideoForConference;
import com.xylink.model.Status;
import com.xylink.model.Video;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;

public class LiveVideoApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/liveVideo3/enterprise/";

    public Result<LV> newLiveVideo(String enterpriseId, String token, String confNo, LiveVideo liveVideo) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveVideo);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, LV.class);
    }

    public Result<LiveVideoForConference> scheduleLive(String enterpriseId, String token, String confNo, String confPwd, LiveVideo liveVideo) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveVideo);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, LiveVideoForConference.class);
    }

    public Result updateLive(String enterpriseId, String token, String confNo, String confPwd, String liveId, LiveVideo liveVideo) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live/" + liveId + "?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)liveVideo);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result deleteLive(String enterpriseId, String token, String confNo, String confPwd, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live/" + liveId + "?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    public Result getLive(String enterpriseId, String token, String confNo, String confPwd, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live/" + liveId + "?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, String.class);
    }

    public Result<Video[]> getLiveVideoList(String enterpriseId, String token, String confNo, String confPwd, String liveId) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live/" + liveId + "/videoswithduration?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        System.out.println(surl);
        return HttpUtil.getResponse(surl, "GET", null, Video[].class);
    }

    public Result controlLive(String enterpriseId, String token, String confNo, String confPwd, String liveId, Status status) throws IOException {
        String surl = this.getPrefixUrl() + enterpriseId + "/conf/" + confNo + "/live/" + liveId + "/status?enterpriseId=" + enterpriseId + "&confPwd=" + confPwd;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)status);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

