/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.recordingControl;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.RecordingResponse;
import com.xylink.model.RecordingStopResponse;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;

public class RecordingControlApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/meeting/recording/";

    public Result startRecording(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getPrefixUrl() + meetingRoomNumber + "/start?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, null);
    }

    public Result<RecordingResponse> stopRecording(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getPrefixUrl() + meetingRoomNumber + "/stop?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, RecordingResponse.class);
    }

    public Result<RecordingStopResponse> stopRecordingWithSessionId(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getPrefixUrl() + meetingRoomNumber + "/stopWithSessionId?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, RecordingStopResponse.class);
    }

    public Result downLoadRecord(String enterpriseId, String token, String downLoadRestApi) throws IOException {
        String surl = downLoadRestApi + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getByteStreamResponse(surl, "GET", null);
    }

    public void convertByteArrayToImageOrVideo(byte[] bytes, String path) {
        HttpUtil.convertByteArrayToImageOrVideo(bytes, path);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

