/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.vod;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.VodInfo;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class VodApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/";

    public Result getVods(String enterpriseId, String token, long startTime, long endTime) throws IOException {
        String surl = this.getPrefixUrl() + "vods?enterpriseId=" + enterpriseId + "&startTime=" + startTime + "&endTime=" + endTime;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, String.class);
    }

    public Result<VodInfo[]> getNemoVods(String enterpriseId, String token, String nemoNumber, long startTime, long endTime) throws IOException {
        String surl = this.getPrefixUrl() + "nemo/" + nemoNumber + "/vods?enterpriseId=" + enterpriseId + "&startTime=" + startTime + "&endTime=" + endTime;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, VodInfo[].class);
    }

    public Result<VodInfo[]> getMeetingRoomVods(String enterpriseId, String token, String meetingRoomNumber, Long startTime, Long endTime) throws IOException {
        String surl = this.getPrefixUrl() + "meetingroom/" + meetingRoomNumber + "/vods?enterpriseId=" + enterpriseId;
        if (startTime != null) {
            surl = surl + "&startTime=" + startTime;
        }
        if (endTime != null) {
            surl = surl + "&endTime=" + endTime;
        }
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, VodInfo[].class);
    }

    public Result getVodThumbnail(String enterpriseId, String token, String vodId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/" + vodId + "/thumbnail?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getByteStreamResponse(surl, "GET", null);
    }

    public void convertByteArrayToImageOrVideo(byte[] bytes, String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(bytes);
        }
        catch (FileNotFoundException e) {
            System.out.println("File Path not found!");
        }
        catch (IOException e) {
            System.out.println("Convert byte array to image,IO Errot!");
        }
    }

    public Result videoDownload(String enterpriseId, String token, String vodId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/" + vodId + "/download?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getByteStreamResponse(surl, "GET", null);
    }

    public Result deleteVideo(String enterpriseId, String token, String vodId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/" + vodId + "?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    public Result deleteMeetingRoomVods(String enterpriseId, String token, String meetingRoomNumber) throws IOException {
        String surl = this.getPrefixUrl() + "meetingroom/" + meetingRoomNumber + "/vods?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    public Result getDownloadurl(String enterpriseId, String token, String vodId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/" + vodId + "/getdownloadurl?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Map.class);
    }

    public Result getDownloadurlBySessionId(String enterpriseId, String token, String sessionId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/session/" + sessionId + "/downloadurl?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Map.class);
    }

    public Result getMeetingRoomVodsPage(String enterpriseId, String token, String meetingRoomNumber, long startTime, long endTime, int pageIndex, int pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "/meetingroom/" + meetingRoomNumber + "/vods/page&startTime=" + startTime + "&endTime" + endTime + "&pageIndex" + pageIndex + "&pageSize" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Map.class);
    }

    public Result getVodSharedInfo(String vodId, String token, String enterpriseId) throws IOException {
        String surl = this.getPrefixUrl() + "vods/" + vodId + "/sharedInfo?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Map.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

