/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.sdk.wechat;

import com.xylink.config.SDKConfigMgr;
import com.xylink.model.SdkMiniProgramLoginRequest;
import com.xylink.model.SdkMiniProgramTokenRequestModel;
import com.xylink.model.SdkMiniProgramUserDto;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;

public class MiniProgramApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/";

    public Result<List<SdkMiniProgramUserDto>> batchUser(String enterpriseId, String token, String appId) throws IOException {
        String surl = this.getPrefixUrl() + "miniprogram/batch/users?enterpriseId=" + enterpriseId + "&appId=" + appId;
        String signature = signatureSample.computeSignature("", "POST", token, surl);
        surl = surl + "&signature=" + signature;
        Result SdkMiniProgramUserDtos = HttpUtil.getResponse(surl, "POST", null, List.class);
        if (SdkMiniProgramUserDtos.isSuccess()) {
            return SdkMiniProgramUserDtos;
        }
        throw new RuntimeException(SdkMiniProgramUserDtos.getErrorStatus() + "");
    }

    public Result getToken(String enterpriseId, String token, SdkMiniProgramTokenRequestModel sdkMiniProgramTokenRequestModel) throws IOException {
        String surl = this.getPrefixUrl() + "miniprogram/token?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)sdkMiniProgramTokenRequestModel);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result tokenLogin(String enterpriseId, String token, SdkMiniProgramLoginRequest sdkMiniProgramLoginRequest) throws IOException {
        String surl = this.getPrefixUrl() + "en/miniprogram/login?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)sdkMiniProgramLoginRequest);
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, String.class);
    }

    public Result getUsers(String enterpriseId, String token, String appId) throws IOException {
        String surl = this.getPrefixUrl() + "miniprogram/users?enterpriseId=" + enterpriseId + "&appId=" + appId;
        String jsonEntity = "";
        String signature = signatureSample.computeSignature(jsonEntity, "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", jsonEntity, String.class);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

