/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.user;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xylink.config.SDKConfigMgr;
import com.xylink.model.BuffetUserDto;
import com.xylink.model.Pager;
import com.xylink.util.HttpUtil;
import com.xylink.util.Result;
import com.xylink.util.SignatureSample;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuffetUserApi {
    private static SignatureSample signatureSample = new SignatureSample();
    private static final String prefixUrl = "/api/rest/external/v1/buffet/";

    public Result<Set> batchAdd(List<BuffetUserDto> buffetUserDtos, String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "batch/users?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString(buffetUserDtos);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, Set.class);
    }

    public Result<Map> add(BuffetUserDto buffetUserDtos, String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "user?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)buffetUserDtos);
        String signature = signatureSample.computeSignature(jsonEntity, "POST", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "POST", jsonEntity, Map.class);
    }

    public Result<List> get(String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "user?enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, List.class);
    }

    public Result<Pager> getUserInfoByPage(String enterpriseId, String token, Integer pageIndex, Integer pageSize) throws IOException {
        String surl = this.getPrefixUrl() + "/page?enterpriseId=" + enterpriseId + "&pageIndex=" + pageIndex + "&pageSize=" + pageSize;
        String signature = signatureSample.computeSignature("", "GET", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "GET", null, Pager.class);
    }

    public Result update(BuffetUserDto buffetUserDtos, String enterpriseId, String token) throws IOException {
        String surl = this.getPrefixUrl() + "user?enterpriseId=" + enterpriseId;
        String jsonEntity = new ObjectMapper().writeValueAsString((Object)buffetUserDtos);
        String signature = signatureSample.computeSignature(jsonEntity, "PUT", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "PUT", jsonEntity, null);
    }

    public Result delete(String enterpriseId, String countryCode, String phone, String token) throws IOException {
        String surl = this.getPrefixUrl() + "user?countryCode=" + countryCode + "&phone=" + phone + "&enterpriseId=" + enterpriseId;
        String signature = signatureSample.computeSignature("", "DELETE", token, surl);
        surl = surl + "&signature=" + signature;
        return HttpUtil.getResponse(surl, "DELETE", null, null);
    }

    private String getPrefixUrl() {
        return SDKConfigMgr.getServerHost() + prefixUrl;
    }
}

