/*
 * Decompiled with CFR 0.152.
 */
package com.xylink.util;

import com.xylink.config.SDKConfigMgr;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class SignatureSample {
    private String requestUriPrefix = "/api/rest/external/v1/";
    private String wssPrefix = "wss://sdk.xylink.com/external/";

    protected String computeStringToSign(String requestPath, Map<String, String> reqParams, String reqJsonEntity, String reqMethod) throws Exception {
        String prefix = this.getPrefix(requestPath);
        StringBuffer strToSign = new StringBuffer(reqMethod);
        strToSign.append("\n");
        strToSign.append(requestPath.substring(prefix.length()));
        strToSign.append("\n");
        ArrayList<String> params = new ArrayList<String>(reqParams.keySet());
        Collections.sort(params);
        for (String param : params) {
            strToSign.append(param);
            strToSign.append("=");
            strToSign.append(reqParams.get(param));
            strToSign.append("&");
        }
        strToSign.deleteCharAt(strToSign.length() - 1);
        strToSign.append("\n");
        byte[] reqEntity = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)reqJsonEntity)) {
            reqEntity = reqJsonEntity.getBytes("utf-8");
        }
        if (reqEntity.length == 0) {
            byte[] entity = DigestUtils.sha256((String)"");
            strToSign.append(Base64.encodeBase64String((byte[])entity));
        } else {
            byte[] data = null;
            data = reqEntity.length <= 100 ? reqEntity : Arrays.copyOf(reqEntity, 100);
            byte[] entity = DigestUtils.sha256((byte[])data);
            strToSign.append(Base64.encodeBase64String((byte[])entity));
        }
        String ret = strToSign.toString();
        System.out.println(ret);
        System.out.println("------------------");
        return ret;
    }

    private String getPrefix(String reqPath) {
        String prefix = SDKConfigMgr.getServerHost() + this.requestUriPrefix;
        if (reqPath.startsWith("wss://")) {
            prefix = this.wssPrefix;
        }
        return prefix;
    }

    private void printArray(byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (byte d : data) {
            sb.append(d);
            sb.append(",");
        }
        System.out.println(sb.toString());
    }

    private String calculateHMAC(String data, String key) throws SignatureException {
        try {
            SecretKeySpec e = new SecretKeySpec(key.getBytes("UTF8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(e);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF8"));
            String result = Base64.encodeBase64String((byte[])rawHmac);
            return result;
        }
        catch (Exception var6) {
            throw new SignatureException("Failed to generate HMAC : " + var6.getMessage());
        }
    }

    public String computeSignature(String jsonEntity, String method, String token, String reqPath) {
        try {
            String[] params;
            HashMap<String, String> reqParams = new HashMap<String, String>();
            int idx = reqPath.indexOf("?");
            for (String param : params = reqPath.substring(idx + 1).split("&")) {
                String[] pair = param.split("=");
                if (pair.length == 1) {
                    reqParams.put(pair[0], "");
                    continue;
                }
                reqParams.put(pair[0], pair[1]);
            }
            reqPath = reqPath.substring(0, idx);
            String strToSign = this.computeStringToSign(reqPath, reqParams, jsonEntity, method);
            String mySignature = this.calculateHMAC(strToSign, token);
            mySignature = mySignature.replace(" ", "+");
            return URLEncoder.encode(mySignature, "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }
}

