/*
 * Decompiled with CFR 0.152.
 */
package ai.dify.javaclient;

import ai.dify.javaclient.DifyClient;
import ai.dify.javaclient.DifyClientException;
import com.alibaba.fastjson2.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class ChatClient
extends DifyClient {
    public ChatClient(String apiKey) {
        super(apiKey);
    }

    public ChatClient(String apiKey, String baseUrl) {
        super(apiKey, baseUrl);
    }

    private String generateQueryParams(Map<String, String> params) {
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            keyValuePairs.add(entry.getKey() + "=" + entry.getValue());
        }
        return String.join((CharSequence)"&", keyValuePairs);
    }

    public Response createBlockingModeChatMessage(JSONObject inputs, String query, String user, String conversation_id) throws DifyClientException {
        JSONObject json = new JSONObject();
        json.put((Object)"inputs", (Object)inputs);
        json.put((Object)"query", (Object)query);
        json.put((Object)"user", (Object)user);
        json.put((Object)"response_mode", (Object)"blocking");
        if (conversation_id != null && !conversation_id.isEmpty()) {
            json.put((Object)"conversation_id", (Object)conversation_id);
        }
        return this.sendRequest(CREATE_CHAT_MESSAGE, null, this.createJsonPayload(json));
    }

    public Response stopChatMessage(String user, String task_id) throws DifyClientException {
        JSONObject json = new JSONObject();
        json.put((Object)"user", (Object)user);
        return this.sendRequest(STOP_CHAT_MESSAGE, new String[]{task_id}, this.createJsonPayload(json));
    }

    public Response getConversationMessages(String user, String conversation_id, String first_id, int limit) throws DifyClientException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("user", user);
        if (conversation_id != null) {
            queryParams.put("conversation_id", conversation_id);
        }
        if (first_id != null) {
            queryParams.put("first_id", first_id);
        }
        if (limit > 0) {
            queryParams.put("limit", String.valueOf(limit));
        }
        String formattedQueryParams = this.generateQueryParams(queryParams);
        return this.sendRequest(GET_CONVERSATION_MESSAGES, new String[]{formattedQueryParams}, null);
    }

    public Response getSuggestedMessages(String user, String messageId) throws DifyClientException {
        return this.sendRequest(GET_SUGGESTED_MESSAGES, new String[]{messageId, user}, null);
    }

    public Response getConversations(String user, String last_id, int limit, Boolean pinned) throws DifyClientException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("user", user);
        if (last_id != null && !last_id.isEmpty()) {
            queryParams.put("last_id", last_id);
        }
        if (limit > 0) {
            queryParams.put("limit", String.valueOf(limit));
        }
        if (pinned != null) {
            queryParams.put("pinned", String.valueOf(pinned));
        }
        String formattedQueryParams = this.generateQueryParams(queryParams);
        return this.sendRequest(GET_CONVERSATIONS, new String[]{formattedQueryParams}, null);
    }

    public Response renameConversation(String conversation_id, String name, String user) throws DifyClientException {
        JSONObject json = new JSONObject();
        json.put((Object)"name", (Object)name);
        json.put((Object)"user", (Object)user);
        return this.sendRequest(RENAME_CONVERSATION, new String[]{conversation_id}, this.createJsonPayload(json));
    }

    public Response deleteConversation(String conversation_id, String user) throws DifyClientException {
        JSONObject json = new JSONObject();
        json.put((Object)"user", (Object)user);
        return this.sendRequest(DELETE_CONVERSATION, new String[]{conversation_id}, this.createJsonPayload(json));
    }
}

