/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.MessageHandler;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class ADLDOMParser
extends DOMParser
implements ErrorHandler {
    protected Document document;
    protected Node rootNode;
    protected MessageHandler messageHandler;
    protected boolean system;
    protected boolean wellFormed;
    protected boolean valid;
    protected boolean extensionFound;
    protected String baseDir;
    private boolean validation;
    private String messageLocation = "ADLDOMParser::";
    private String tsPath;
    private String tsParent;
    private static String MDNamespace = "http://www.imsglobal.org/xsd/imsmd_rootv1p2p1";
    private static String CPNamespace = "http://www.imsproject.org/xsd/imscp_rootv1p1p2";
    private static String ADLNamespace = "http://www.adlnet.org/xsd/adlcp_rootv1p2";
    private static String XMLNamespace = "http://www.w3.org/XML/1998/namespace";
    private static String nsNamespace = "http://www.w3.org/2000/xmlns/";
    private static String xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance";
    private static String MDSchema = "imsmd_rootv1p2p1.xsd";
    private static String CPSchema = "imscp_rootv1p1p2.xsd";
    private static String ADLSchema = "adlcp_rootv1p2.xsd";
    private static String XMLSchema = "ims_xml.xsd";

    public ADLDOMParser() {
        int i = MessageClassification.SYSTEM;
        int j = MessageType.FAILED;
        String str1 = "";
        String str2 = this.messageLocation + "ADLDOMParser()";
        String str3 = "";
        this.validation = false;
        this.messageHandler = new MessageHandler();
        this.baseDir = new String("");
        this.system = true;
        this.wellFormed = true;
        this.valid = true;
        this.extensionFound = false;
        this.tsPath = "";
        this.tsParent = "";
        if (DebugIndicator.ON) {
            System.out.println("\n\n*****  In ADLDOMParser()  ******\n");
        }
        try {
            this.setFeature("http://xml.org/sax/features/validation", false);
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            this.setErrorHandler(this);
        }
        catch (SAXException localSAXException) {
            str1 = "Error in setting parser feature.  Parser not created.";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
        try {
            this.setIncludeIgnorableWhitespace(false);
        }
        catch (SAXNotRecognizedException localSAXNotRecognizedException) {
            str1 = "Error in setting ignoring whitespace. SAX Not Recognized!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
        catch (SAXNotSupportedException localSAXNotSupportedException) {
            str1 = "Error in setting ignoring whitespace. SAX Not Supported!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
    }

    public ADLDOMParser(boolean paramBoolean) {
        int i = MessageClassification.SYSTEM;
        int j = MessageType.FAILED;
        String str1 = "";
        String str2 = this.messageLocation + "ADLDOMParser(boolean)";
        String str3 = "";
        this.validation = paramBoolean;
        this.messageHandler = new MessageHandler();
        this.baseDir = new String("");
        this.system = true;
        this.wellFormed = true;
        this.valid = true;
        this.extensionFound = false;
        this.tsPath = "";
        this.tsParent = "";
        if (DebugIndicator.ON) {
            System.out.println("\n\n*****  In ADLDOMParser()  ******\n");
        }
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            if (this.validation) {
                this.setValidationOn();
            } else {
                this.setFeature("http://xml.org/sax/features/validation", false);
                this.setErrorHandler(this);
            }
        }
        catch (SAXException localSAXException) {
            str1 = "Error in setting parser feature.  Parser not created.";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
        try {
            this.setIncludeIgnorableWhitespace(false);
        }
        catch (SAXNotRecognizedException localSAXNotRecognizedException) {
            str1 = "Error in setting ignoring whitespace. SAX Not Recognized!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
        catch (SAXNotSupportedException localSAXNotSupportedException) {
            str1 = "Error in setting ignoring whitespace. SAX Not Supported!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
    }

    public void setIncludeIgnorableWhitespace(boolean paramBoolean) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fIncludeIgnorableWhitespace = paramBoolean;
    }

    public void setTSPath(String paramString) {
        this.tsPath = paramString;
        StringTokenizer localStringTokenizer = new StringTokenizer(this.tsPath, "\\", false);
        int i = localStringTokenizer.countTokens();
        for (int j = 0; j < i - 1; ++j) {
            this.tsParent = this.tsParent + localStringTokenizer.nextToken() + "\\";
        }
    }

    public void setValidationOn() {
        int i = MessageClassification.SYSTEM;
        int j = MessageType.FAILED;
        String str1 = "";
        String str2 = this.messageLocation + "setValidationON()";
        String str3 = "";
        try {
            this.setFeature("http://xml.org/sax/features/validation", true);
            this.setFeature("http://xml.org/sax/features/namespaces", true);
            this.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.setErrorHandler(this);
        }
        catch (SAXException localSAXException) {
            str1 = "Error in setting parser feature.  Parser not created.";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
        }
        this.validation = true;
    }

    public boolean parseFile(String paramString) {
        int i = 0;
        if (DebugIndicator.ON) {
            System.out.println("getting InputSource...");
        }
        InputSource localInputSource = this.getFileSource(paramString);
        String str2 = this.messageLocation + "parseFile(String)";
        String str3 = "";
        try {
            if (DebugIndicator.ON) {
                System.out.println("calling parse...");
            }
            super.parse(localInputSource);
            if (DebugIndicator.ON) {
                System.out.println("done with parse parse...");
            }
        }
        catch (SAXException localSAXException) {
            int k = MessageType.FAILED;
            String str1 = "Error in parsing new input source.  SAX Exception!";
            if (this.validation) {
                int j = MessageClassification.VALID;
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.valid = false;
            } else {
                int j = MessageClassification.WELLFORMED;
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.wellFormed = false;
                this.valid = false;
            }
        }
        catch (IOException localIOException) {
            int k = MessageType.FAILED;
            String str1 = "Error in parsing new input source.  IO Exception!";
            if (this.validation) {
                int j = MessageClassification.VALID;
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.valid = false;
            } else {
                int j = MessageClassification.WELLFORMED;
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.wellFormed = false;
                this.valid = false;
            }
        }
        catch (NullPointerException localNullPointerException1) {
            if (DebugIndicator.ON) {
                System.out.println("caught NullPointerException");
            }
            this.wellFormed = false;
            this.valid = false;
        }
        try {
            this.document = this.getDocument();
            this.rootNode = this.document.getDocumentElement();
            if (this.document.hasChildNodes()) {
                i = 1;
            }
        }
        catch (NullPointerException localNullPointerException2) {
            if (DebugIndicator.ON) {
                System.out.println("caught NullPointerException");
            }
            this.wellFormed = false;
            this.valid = false;
        }
        return i > 0;
    }

    public boolean parseDocumentNode(Document paramDocument) {
        int k;
        String str1;
        int m;
        InputSource localInputSource;
        int i = 0;
        boolean j = true;
        String str2 = this.messageLocation + "parseDocumentNode(Document)";
        String str3 = "";
        try {
            ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat localOutputFormat = new OutputFormat(this.document);
            localOutputFormat.setIndenting(false);
            XMLSerializer localXMLSerializer = new XMLSerializer((OutputStream)localByteArrayOutputStream, localOutputFormat);
            localXMLSerializer.asDOMSerializer();
            localXMLSerializer.serialize(this.document.getDocumentElement());
            ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(localByteArrayOutputStream.toByteArray());
            localInputSource = new InputSource(localByteArrayInputStream);
        }
        catch (FileNotFoundException localFileNotFoundException) {
            localInputSource = new InputSource();
            j = false;
            m = MessageType.FAILED;
            str1 = "Error in creating new input source  File Not Found Exception!";
            if (this.validation) {
                k = MessageClassification.VALID;
                this.messageHandler.addMessage(k, m, str1, str2, str3);
                this.valid = false;
            } else {
                k = MessageClassification.WELLFORMED;
                this.messageHandler.addMessage(k, m, str1, str2, str3);
                this.wellFormed = false;
            }
        }
        catch (IOException localIOException1) {
            localInputSource = new InputSource();
            j = false;
            m = MessageType.FAILED;
            str1 = "Error in creating new input source IO Exception!";
            if (this.validation) {
                k = MessageClassification.VALID;
                this.messageHandler.addMessage(k, m, str1, str2, str3);
                this.valid = false;
            }
            k = MessageClassification.WELLFORMED;
            this.messageHandler.addMessage(k, m, str1, str2, str3);
            this.wellFormed = false;
        }
        if (j) {
            try {
                super.parse(localInputSource);
            }
            catch (SAXException localSAXException) {
                m = MessageType.FAILED;
                str1 = "Error in parsing new input source.  SAX Exception!";
                if (this.validation) {
                    k = MessageClassification.VALID;
                    this.messageHandler.addMessage(k, m, str1, str2, str3);
                    this.valid = false;
                } else {
                    k = MessageClassification.WELLFORMED;
                    this.messageHandler.addMessage(k, m, str1, str2, str3);
                    this.wellFormed = false;
                }
            }
            catch (IOException localIOException2) {
                m = MessageType.FAILED;
                str1 = "Error in parsing new input source.  IO Exception!";
                str3 = "";
                if (this.validation) {
                    k = MessageClassification.VALID;
                    this.messageHandler.addMessage(k, m, str1, str2, str3);
                    this.valid = false;
                }
                k = MessageClassification.WELLFORMED;
                this.messageHandler.addMessage(k, m, str1, str2, str3);
                this.wellFormed = false;
            }
            this.document = super.getDocument();
            this.rootNode = this.document.getDocumentElement();
            if (this.document.hasChildNodes()) {
                i = 1;
            }
        }
        return i > 0;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private InputSource getFileSource(String paramString) {
        int i = MessageClassification.SYSTEM;
        int j = MessageType.FAILED;
        String str2 = this.messageLocation + "getFileSource(String)";
        String str3 = "";
        try {
            File localFile = new File(paramString);
            if (localFile.isFile()) {
                String str4 = localFile.getAbsolutePath();
                if (DebugIndicator.ON) {
                    System.out.println("XML File: " + str4);
                }
                StringTokenizer localStringTokenizer = new StringTokenizer(str4, new String("\\"), true);
                int k = localStringTokenizer.countTokens();
                --k;
                for (int m = 0; m < k; ++m) {
                    str4 = localStringTokenizer.nextToken();
                    this.baseDir = this.baseDir + str4;
                }
                this.baseDir = this.baseDir.replace('\\', '/');
                if (this.baseDir.charAt(this.baseDir.length() - 1) != '/') {
                    this.baseDir = this.baseDir + '/';
                }
                if (DebugIndicator.ON) {
                    System.out.println("baseDir = " + this.baseDir);
                }
                FileReader localFileReader = new FileReader(localFile);
                InputSource localInputSource = new InputSource(localFileReader);
                return localInputSource;
            }
        }
        catch (NullPointerException localNullPointerException) {
            String str1 = "Error in accessing the given file.  Null Pointer Exception!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.system = false;
        }
        catch (SecurityException localSecurityException) {
            String str1 = "Error in accessing the given file.  Security Exception!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.system = false;
        }
        catch (FileNotFoundException localFileNotFoundException) {
            String str11 = "Error in accessing the given file.  File Not Found Exception!";
            this.messageHandler.addMessage(i, j, str11, str2, str3);
            this.system = false;
        }
        return new InputSource();
    }

    protected void pruneTree(Node paramNode) {
        boolean i = false;
        if (paramNode == null) {
            return;
        }
        short j = paramNode.getNodeType();
        block0 : switch (j) {
            case 7: {
                if (!i) break;
                this.printNodeInfo("PROCESSING_INSTRUCTION_NODE", ((Document)paramNode).getDocumentElement());
                break;
            }
            case 9: {
                if (i) {
                    this.printNodeInfo("DOCUMENT_NODE", ((Document)paramNode).getDocumentElement());
                }
                this.pruneTree(((Document)paramNode).getDocumentElement());
                break;
            }
            case 1: {
                int i1;
                if (i) {
                    this.printNodeInfo("ELEMENT_NODE", paramNode);
                }
                Object localObject = paramNode.getNodeName();
                NamedNodeMap localNamedNodeMap = paramNode.getAttributes();
                int m = localNamedNodeMap.getLength();
                for (int n = 0; n < m; ++n) {
                    Attr localAttr = (Attr)localNamedNodeMap.item(n);
                    if (!i) continue;
                    this.printNodeInfo("ATTRIBUTE_NODE", localAttr);
                }
                NodeList localNodeList = paramNode.getChildNodes();
                if (localNodeList == null) break;
                for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                    if (localNodeList.item(i1) instanceof TextImpl) {
                        String str = new String(localNodeList.item(i1).getNodeValue().trim());
                        if (((TextImpl)localNodeList.item(i1)).isIgnorableWhitespace()) {
                            paramNode.removeChild(localNodeList.item(i1));
                            --i1;
                            continue;
                        }
                        if (str.length() != 0) continue;
                        paramNode.removeChild(localNodeList.item(i1));
                        --i1;
                        continue;
                    }
                    if (localNodeList.item(i1).getNodeType() != 8) continue;
                    paramNode.removeChild(localNodeList.item(i1));
                    --i1;
                }
                i1 = localNodeList.getLength();
                block7: for (int i2 = 0; i2 < i1; ++i2) {
                    this.pruneTree(localNodeList.item(i2));
                    if (i) {
                        this.printNodeInfo("ENTITY_REFERENCE_NODE", paramNode);
                    }
                    if ((localObject = paramNode.getChildNodes()) == null) break block0;
                    int k = ((NodeList)localObject).getLength();
                    for (m = 0; m < k; ++m) {
                        this.pruneTree(((NodeList)localObject).item(m));
                        if (!i) continue block7;
                        this.printNodeInfo("COMMENT_NODE", paramNode);
                        if (!i) continue block7;
                        this.printNodeInfo("CDATA_SECTION_NODE", paramNode);
                        if (paramNode instanceof TextImpl) {
                            if (((TextImpl)paramNode).isIgnorableWhitespace()) {
                                if (!i) continue block7;
                                this.printNodeInfo("TEXT_NODE (TextImpl:Ignorable Whitespace)", paramNode);
                                continue;
                            }
                            if (!i) continue block7;
                            this.printNodeInfo("TEXT_NODE (TextImpl:Element Data)", paramNode);
                            continue;
                        }
                        if (!i) continue block7;
                        this.printNodeInfo("TEXT_NODE", paramNode);
                    }
                }
                break;
            }
        }
    }

    protected void pruneTree(Node paramNode, boolean paramBoolean) {
        boolean i = false;
        boolean bool = paramBoolean;
        if (paramNode == null) {
            return;
        }
        short j = paramNode.getNodeType();
        block0 : switch (j) {
            case 7: {
                if (!i) break;
                this.printNodeInfo("PROCESSING_INSTRUCTION_NODE", ((Document)paramNode).getDocumentElement());
                break;
            }
            case 9: {
                if (i) {
                    this.printNodeInfo("DOCUMENT_NODE", ((Document)paramNode).getDocumentElement());
                }
                this.pruneTree(((Document)paramNode).getDocumentElement(), bool);
                break;
            }
            case 1: {
                int i1;
                String str3;
                if (i) {
                    this.printNodeInfo("ELEMENT_NODE", paramNode);
                }
                Object localObject = paramNode.getLocalName();
                NamedNodeMap localNamedNodeMap = paramNode.getAttributes();
                int m = localNamedNodeMap.getLength();
                for (int n = 0; n < m; ++n) {
                    Attr localAttr = (Attr)localNamedNodeMap.item(n);
                    if (i) {
                        this.printNodeInfo("ATTRIBUTE_NODE", localAttr);
                    }
                    String str2 = localAttr.getNamespaceURI();
                    str3 = localAttr.getNodeName();
                    if (str2 == null || str2.equals(CPNamespace) || str2.equals(MDNamespace) || str2.equals(XMLNamespace) || str2.equals(ADLNamespace) || str2.equals(nsNamespace) || str2.equals(xsiNamespace) || !bool) continue;
                    if (DebugIndicator.ON) {
                        System.out.println("Just tossed an extension attribute");
                        System.out.println("Name: " + localAttr.getNodeName());
                        System.out.println("attr ns: " + str2);
                    }
                    this.extensionFound = true;
                    localNamedNodeMap.removeNamedItem(localAttr.getNodeName());
                    --m;
                }
                NodeList localNodeList = paramNode.getChildNodes();
                if (localNodeList == null) break;
                for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                    str3 = localNodeList.item(i1).getNamespaceURI();
                    if (!(str3 == null || str3.equals(CPNamespace) || str3.equals(MDNamespace) || str3.equals(XMLNamespace) || str3.equals(ADLNamespace) || str3.equals(nsNamespace) || str3.equals(xsiNamespace) || !bool)) {
                        if (DebugIndicator.ON) {
                            System.out.println("Just tossed a child element");
                            System.out.println("Name: " + localNodeList.item(i1).getNodeName());
                            System.out.println("child ns: " + str3);
                        }
                        this.extensionFound = true;
                        paramNode.removeChild(localNodeList.item(i1));
                        continue;
                    }
                    if (localNodeList.item(i1) instanceof TextImpl) {
                        String str1 = new String(localNodeList.item(i1).getNodeValue().trim());
                        if (((TextImpl)localNodeList.item(i1)).isIgnorableWhitespace()) {
                            paramNode.removeChild(localNodeList.item(i1));
                            --i1;
                            continue;
                        }
                        if (str1.length() != 0) continue;
                        paramNode.removeChild(localNodeList.item(i1));
                        --i1;
                        continue;
                    }
                    if (localNodeList.item(i1).getNodeType() != 8) continue;
                    paramNode.removeChild(localNodeList.item(i1));
                    --i1;
                }
                if (((String)localObject).equals("lom")) {
                    if (DebugIndicator.ON) {
                        System.out.println("found lom element");
                    }
                    bool = false;
                }
                i1 = localNodeList.getLength();
                block7: for (int i2 = 0; i2 < i1; ++i2) {
                    this.pruneTree(localNodeList.item(i2), bool);
                    if (i) {
                        this.printNodeInfo("ENTITY_REFERENCE_NODE", paramNode);
                    }
                    if ((localObject = paramNode.getChildNodes()) == null) break block0;
                    int k = ((NodeList)localObject).getLength();
                    for (m = 0; m < k; ++m) {
                        this.pruneTree(((NodeList)localObject).item(m), bool);
                        if (!i) continue block7;
                        this.printNodeInfo("COMMENT_NODE", paramNode);
                        if (!i) continue block7;
                        this.printNodeInfo("CDATA_SECTION_NODE", paramNode);
                        if (paramNode instanceof TextImpl) {
                            if (((TextImpl)paramNode).isIgnorableWhitespace()) {
                                if (!i) continue block7;
                                this.printNodeInfo("TEXT_NODE (TextImpl:Ignorable Whitespace)", paramNode);
                                continue;
                            }
                            if (!i) continue block7;
                            this.printNodeInfo("TEXT_NODE (TextImpl:Element Data)", paramNode);
                            continue;
                        }
                        if (!i) continue block7;
                        this.printNodeInfo("TEXT_NODE", paramNode);
                    }
                }
                break;
            }
        }
    }

    protected void printNodeInfo(String paramString, Node paramNode) {
        StringBuffer localStringBuffer1 = new StringBuffer("(null)");
        StringBuffer localStringBuffer2 = new StringBuffer("(null)");
        StringBuffer localStringBuffer3 = new StringBuffer("(null)");
        StringBuffer localStringBuffer4 = new StringBuffer("(null)");
        String str = new String(" -- ");
        if (paramNode != null) {
            if (paramString != null) {
                localStringBuffer1 = new StringBuffer(paramString);
            }
            localStringBuffer2 = new StringBuffer(new Integer(paramNode.getNodeType()).toString());
            if (paramNode.getNodeName() != null) {
                localStringBuffer3 = new StringBuffer(paramNode.getNodeName());
            }
            if (paramNode.getNodeValue() != null) {
                localStringBuffer4 = new StringBuffer(paramNode.getNodeValue());
            }
        }
        while (localStringBuffer1.length() < 42) {
            localStringBuffer1.append(" ");
        }
        while (localStringBuffer3.length() < 15) {
            localStringBuffer3.append(" ");
        }
        while (localStringBuffer4.length() < 10) {
            localStringBuffer4.append(" ");
        }
        if (DebugIndicator.ON) {
            System.out.println(localStringBuffer1 + str + localStringBuffer2 + str + localStringBuffer3 + str + localStringBuffer4);
        }
    }

    public Vector getMessage(int paramInt) {
        return this.messageHandler.getMessage(paramInt);
    }

    public boolean isValidationON() {
        return this.validation;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isWellFormed() {
        return this.wellFormed;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void clearSystem() {
        this.messageHandler.clearMessage(MessageClassification.SYSTEM);
        this.system = true;
    }

    @Override
    public void warning(SAXParseException paramSAXParseException) {
        int j = MessageType.FAILED;
        String str1 = paramSAXParseException.getMessage();
        String str2 = this.messageLocation + "warning(SAXParseException)";
        String str3 = paramSAXParseException.getSystemId() + " on line" + paramSAXParseException.getLineNumber();
        if (this.validation) {
            int i = MessageClassification.VALID;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.valid = false;
        } else {
            int i = MessageClassification.WELLFORMED;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.wellFormed = false;
        }
    }

    @Override
    public void error(SAXParseException paramSAXParseException) {
        int j = MessageType.FAILED;
        String str1 = paramSAXParseException.getMessage();
        String str2 = this.messageLocation + "error(SAXParseException)";
        String str3 = "line = " + paramSAXParseException.getLineNumber();
        if (this.validation) {
            int i = MessageClassification.VALID;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.valid = false;
        } else {
            int i = MessageClassification.WELLFORMED;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.wellFormed = false;
        }
    }

    @Override
    public void fatalError(SAXParseException paramSAXParseException) {
        int j = MessageType.FAILED;
        String str1 = paramSAXParseException.getMessage();
        String str2 = this.messageLocation + "fatalError(SAXParseException)";
        String str3 = "line = " + paramSAXParseException.getLineNumber();
        if (this.validation) {
            int i = MessageClassification.VALID;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.valid = false;
        } else {
            int i = MessageClassification.WELLFORMED;
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.wellFormed = false;
        }
    }
}

