/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.util.Vector;
import org.adl.parsers.util.MessageHandler;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLElement {
    protected MessageHandler messageHandler;
    protected String elemName;
    protected int multiplicity;
    protected int min;
    protected int max;
    protected int spm;

    public ADLElement() {
    }

    public ADLElement(String paramString) {
        this.messageHandler = new MessageHandler();
        this.elemName = paramString;
        this.multiplicity = -1;
        this.min = -1;
        this.max = -1;
        this.spm = -1;
    }

    protected String getAttribute(Node paramNode, String paramString) {
        String str = new String();
        Attr[] arrayOfAttr = this.sortAttributes(paramNode.getAttributes());
        for (int i = 0; i < arrayOfAttr.length; ++i) {
            Attr localAttr = arrayOfAttr[i];
            if (!localAttr.getLocalName().equals(paramString)) continue;
            str = localAttr.getValue();
            break;
        }
        return str;
    }

    protected Attr[] sortAttributes(NamedNodeMap paramNamedNodeMap) {
        int j;
        int i = paramNamedNodeMap != null ? paramNamedNodeMap.getLength() : 0;
        Attr[] arrayOfAttr = new Attr[i];
        for (j = 0; j < i; ++j) {
            arrayOfAttr[j] = (Attr)paramNamedNodeMap.item(j);
        }
        for (j = 0; j < i - 1; ++j) {
            String localObject = arrayOfAttr[j].getLocalName();
            int k = j;
            for (int m = j + 1; m < i; ++m) {
                String str = arrayOfAttr[m].getLocalName();
                if (str.compareTo(localObject) >= 0) continue;
                localObject = str;
                k = m;
            }
            if (k == j) continue;
            Attr localAttr = arrayOfAttr[j];
            arrayOfAttr[j] = arrayOfAttr[k];
            arrayOfAttr[k] = localAttr;
        }
        return arrayOfAttr;
    }

    public String getSubElement(Node paramNode, String paramString) {
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                if (localNodeList.item(i).getNodeType() != 1 || !localNodeList.item(i).getLocalName().equalsIgnoreCase(paramString)) continue;
                str = this.getText(localNodeList.item(i));
                return str;
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("node has no kids");
        }
        return str;
    }

    public String getTypeAttribute(Node paramNode, String paramString) {
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                if (localNodeList.item(i).getNodeType() != 1 || !localNodeList.item(i).getLocalName().equalsIgnoreCase(paramString)) continue;
                str = this.getAttribute(localNodeList.item(i), "type");
                return str;
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("node has no kids");
        }
        return str;
    }

    public String getIdentifierrefAttribute(Node paramNode, String paramString) {
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                if (localNodeList.item(i).getNodeType() != 1 || !localNodeList.item(i).getLocalName().equalsIgnoreCase(paramString)) continue;
                str = this.getAttribute(localNodeList.item(i), "identifierref");
                return str;
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("node has no kids");
        }
        return str;
    }

    public String getText(Node paramNode) {
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                if (localNodeList.item(i).getNodeType() != 3 && localNodeList.item(i).getNodeType() != 4) continue;
                str = str + localNodeList.item(i).getNodeValue().trim();
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("node has no kids");
        }
        return str;
    }

    public int getMultiplicityUsed(Node paramNode, String paramString) {
        NodeList localNodeList = paramNode.getChildNodes();
        int i = 0;
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            String str;
            if (localNodeList.item(j).getNodeType() != 1 || !(str = localNodeList.item(j).getLocalName()).equalsIgnoreCase(paramString)) continue;
            ++i;
        }
        return i;
    }

    public boolean checkMultiplicity(int paramInt, String paramString) {
        int i = 0;
        int j = -1;
        String str1 = "";
        String str2 = "";
        if (this.multiplicity >= this.min || this.multiplicity <= this.max) {
            j = MessageType.PASSED;
            str1 = "Element <" + this.elemName + "> passed the multiplicity test";
            i = 1;
        } else if (this.min == this.max) {
            j = MessageType.FAILED;
            str1 = "The multiplicity for element <" + this.elemName + "> is " + this.min + " and only " + this.max + " and " + this.multiplicity + " were found.";
        } else if (this.spm > 0) {
            j = MessageType.WARNING;
            str1 = "The smallest permitted maximum for element <" + this.elemName + "> is " + this.spm + " and " + this.multiplicity + " were found.";
            i = 1;
        } else {
            j = MessageType.FAILED;
            str1 = "The multiplicity for element <" + this.elemName + "> is " + this.min + " or " + this.max + " and " + this.multiplicity + " were found.";
        }
        this.messageHandler.addMessage(paramInt, j, str1, paramString, str2);
        return i > 0;
    }

    public boolean checkMultiplicity(int paramInt1, String paramString1, String paramString2, int paramInt2, int paramInt3, int paramInt4) {
        int i = 0;
        int j = -1;
        String str1 = "";
        String str2 = "";
        if (paramInt4 >= paramInt2 && paramInt4 <= paramInt3) {
            j = MessageType.PASSED;
            str1 = "Element <" + paramString2 + "> passed the multiplicity test";
            i = 1;
        } else if (paramInt2 == paramInt3) {
            j = MessageType.FAILED;
            str1 = "The multiplicity for element <" + paramString2 + "> is " + paramInt2 + " and only " + paramInt3 + " and " + paramInt4 + " were found.";
        } else {
            j = MessageType.FAILED;
            str1 = "The multiplicity for element <" + paramString2 + "> is " + paramInt2 + " or " + paramInt3 + " and " + paramInt4 + " were found.";
        }
        this.messageHandler.addMessage(paramInt1, j, str1, paramString1, str2);
        return i > 0;
    }

    public boolean checkMultiplicity(int paramInt1, String paramString1, String paramString2, int paramInt2, int paramInt3, String paramString3, boolean paramBoolean) {
        int i = 1;
        int j = -1;
        String str1 = "";
        String str2 = "";
        if (paramInt2 > 0) {
            if (paramString3.equalsIgnoreCase("")) {
                j = MessageType.FAILED;
                str1 = paramBoolean ? "Attribute \"" + paramString2 + "\" was not found or was " + "left blank." : "Element <" + paramString2 + "> was not found or was " + "left blank.";
                this.messageHandler.addMessage(paramInt1, j, str1, paramString1, str2);
                if (paramInt2 == paramInt3) {
                    j = MessageType.FAILED;
                    str1 = paramBoolean ? "The multiplicity for attribute \"" + paramString2 + "\"" + " is " + paramInt2 + " and only " + paramInt3 : "The multiplicity for element <" + paramString2 + ">" + " is " + paramInt2 + " and only " + paramInt3;
                } else {
                    j = MessageType.FAILED;
                    str1 = paramBoolean ? "The multiplicity for attribute \"" + paramString2 + "\"" + " is " + paramInt2 + " or " + paramInt3 : "The multiplicity for element <" + paramString2 + ">" + " is " + paramInt2 + " or " + paramInt3;
                }
                this.messageHandler.addMessage(paramInt1, j, str1, paramString1, str2);
                i = 0;
            }
        } else {
            j = MessageType.PASSED;
            str1 = paramBoolean ? "Attribute \"" + paramString2 + "\" passed the " + "multiplicity test" : "Element <" + paramString2 + "> passed the " + "multiplicity test";
            this.messageHandler.addMessage(paramInt1, j, str1, paramString1, str2);
        }
        return i > 0;
    }

    public Vector getMessage(int paramInt) {
        return this.messageHandler.getMessage(paramInt);
    }
}

