/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLMetadata;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.FileRules;
import org.adl.parsers.util.adlrules.manifest.HrefRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLFile
extends ADLElement {
    private String href = new String();
    private ADLMetadata adlMetadata = null;
    private int messageClass = MessageClassification.MINIMUM;
    private String messageLocation = "ADLFile::";

    public ADLFile() {
        super("file");
    }

    public boolean fillFile(Node paramNode) {
        boolean bool = true;
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        String str = this.messageLocation + "fillFile(Node)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        this.href = this.getAttribute(paramNode, "href");
        NodeList localNodeList = paramNode.getChildNodes();
        int i = localNodeList.getLength();
        for (int j = 0; j < i; ++j) {
            Node localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !localNode.getLocalName().equalsIgnoreCase("metadata")) continue;
            this.adlMetadata = new ADLMetadata();
            bool = this.adlMetadata.fillMetadata(localNode) && bool;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        String str1 = this.messageLocation + "checkConformance(String)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        this.min = FileRules.MIN;
        this.max = FileRules.MAX;
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str2 = "";
        String str3 = "";
        str2 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str2, str1, str3);
        bool = this.checkMultiplicity(i, str1);
        boolean bl = bool = this.checkHref(paramString1, paramString2) && bool;
        if (this.adlMetadata != null) {
            bool = this.adlMetadata.checkConformance(paramString1) && bool;
            this.messageHandler.appendMessage(i, this.adlMetadata.getMessage(i));
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkHref(String paramString1, String paramString2) {
        boolean bool;
        String str1;
        block25: {
            str1 = this.messageLocation + "checkHref(String)";
            if (DebugIndicator.ON) {
                System.out.println("******  " + str1 + "  *********");
            }
            bool = true;
            String str2 = new String("href");
            int i = this.messageClass;
            int j = MessageType.INFO;
            String str3 = "";
            String str4 = "";
            int k = HrefRules.MIN;
            int m = HrefRules.MAX;
            int n = HrefRules.VALUESPM;
            str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            boolean bl = bool = this.checkMultiplicity(i, str1, str2, k, m, this.href, true) && bool;
            if (!this.href.equalsIgnoreCase("")) {
                int i1 = this.href.length();
                if (i1 > n) {
                    j = MessageType.WARNING;
                    str3 = "The smallest permitted maximum for the value of attribute \"" + str2 + "\" is " + n + " and a length of " + i1 + " was found.";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                } else {
                    j = MessageType.PASSED;
                    str3 = "The value, \"" + this.href + "\", of attribute \"" + str2 + "\" passed the " + "smallest permitted maximum test";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                }
                if (this.href.charAt(0) == '/') {
                    j = MessageType.FAILED;
                    str3 = "File  \"" + this.href + "\" is referenced to the " + "users home directory.  The \"href\" attribute must " + "reference a file that is local to the package or " + "reference an external file";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    if (DebugIndicator.ON) {
                        System.out.println(str3);
                    }
                    bool = false;
                }
                try {
                    File localFile;
                    int i3;
                    String str5;
                    int i2;
                    if (DebugIndicator.ON) {
                        System.out.println("%%%  baseDir = " + paramString1);
                        System.out.println("%%%  relative href = " + this.href);
                    }
                    if ((i2 = (str5 = this.href).indexOf(63)) > 0) {
                        str5 = str5.substring(0, i2);
                        if (DebugIndicator.ON) {
                            System.out.println("query temphref: " + str5);
                        }
                    }
                    if ((i3 = str5.indexOf(35)) > 0) {
                        str5 = str5.substring(0, i3);
                        if (DebugIndicator.ON) {
                            System.out.println("fragment temphref: " + str5);
                        }
                    }
                    URLDecoder localURLDecoder = new URLDecoder();
                    str5 = URLDecoder.decode(str5);
                    String str6 = new String(paramString1 + paramString2 + str5);
                    if (DebugIndicator.ON) {
                        System.out.println("hrefPath = " + str6);
                    }
                    if ((localFile = new File(str6)).isFile()) {
                        j = MessageType.PASSED;
                        str3 = "File \"" + this.href + "\" has been detected";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        break block25;
                    }
                    boolean i4 = true;
                    try {
                        String str7 = this.href;
                        if (paramString2.length() > 6 && (paramString2.substring(0, 5).equals("http:") || paramString2.substring(0, 6).equals("https:"))) {
                            str7 = paramString2 + str7;
                        }
                        URL localURL = new URL(str7);
                        if (i4) {
                            String str8 = localURL.getProtocol();
                            if (str8.equalsIgnoreCase("file")) {
                                j = MessageType.FAILED;
                                str3 = "File or URL \"" + this.href + "\" could not " + "be detected or verified for format";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                                bool = false;
                            } else {
                                j = MessageType.PASSED;
                                str3 = "URL \"" + this.href + "\" has been verified for" + " correct format";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                            }
                            break block25;
                        }
                        j = MessageType.FAILED;
                        str3 = "File or URL \"" + this.href + "\" could not be " + "verified for correct format";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                    catch (MalformedURLException localMalformedURLException) {
                        j = MessageType.FAILED;
                        str3 = "URL \"" + this.href + "\" could not be verified for " + "correct format";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                }
                catch (NullPointerException localNullPointerException) {
                    if (DebugIndicator.ON) {
                        System.out.println("NullPointerException thrown when accessing " + this.href);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.href + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
                catch (SecurityException localSecurityException) {
                    if (DebugIndicator.ON) {
                        System.out.println("SecurityException thrown when accessing " + this.href);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.href + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public ADLMetadata getMetadata() {
        return this.adlMetadata;
    }
}

