/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLItem;
import org.adl.parsers.dom.ADLMetadata;
import org.adl.parsers.dom.ADLOrganizations;
import org.adl.parsers.dom.ADLResource;
import org.adl.parsers.dom.ADLResources;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.IdentifierRules;
import org.adl.parsers.util.adlrules.manifest.VersionRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLManifest
extends ADLElement
implements Serializable {
    private String parentElem = new String("");
    private ADLMetadata adlMetadata = null;
    private ADLOrganizations orgs;
    private ADLResources rscs = new ADLResources();
    private Vector manifestList;
    private String identifier;
    private String version;
    private String xmlBase;
    private int messageClass;
    private String messageLocation = "ADLManifest::";

    public ADLManifest() {
        super("manifest");
        this.orgs = new ADLOrganizations();
        this.manifestList = new Vector();
        this.identifier = new String("");
        this.version = new String("");
        this.xmlBase = new String("");
        this.messageClass = MessageClassification.MINIMUM;
    }

    public boolean fillManifest(Node paramNode) {
        int j;
        String str1 = this.messageLocation + "fillManifest(Node)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        Vector localVector = new Vector();
        this.parentElem = paramNode.getParentNode().getNodeName();
        this.identifier = this.getAttribute(paramNode, "identifier");
        this.version = this.getAttribute(paramNode, "version");
        this.xmlBase = this.getAttribute(paramNode, "base");
        if (this.xmlBase.length() > 0) {
            this.xmlBase = this.xmlBase.replace('\\', '/');
            if (this.xmlBase.charAt(this.xmlBase.length() - 1) != '/') {
                this.xmlBase = this.xmlBase + '/';
            }
        }
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str2 = new String("");
        int i = localNodeList.getLength();
        for (j = 0; j < i; ++j) {
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str2 = localNode.getLocalName()).equalsIgnoreCase("manifest")) continue;
            ADLManifest localADLManifest = new ADLManifest();
            bool = localADLManifest.fillManifest(localNode) && bool;
            localVector.addAll(localADLManifest.getIDList());
            this.manifestList.addElement(localADLManifest);
        }
        for (j = 0; j < i; ++j) {
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str2 = localNode.getLocalName()).equalsIgnoreCase("resources")) continue;
            bool = this.rscs.fillResources(localNode) && bool;
            localVector.addAll(this.rscs.getResourceID());
            this.rscs.setIdExists(localVector);
        }
        for (j = 0; j < i; ++j) {
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1) continue;
            str2 = localNode.getLocalName();
            if (str2.equalsIgnoreCase("organizations")) {
                bool = this.orgs.fillOrgs(localNode, localVector) && bool;
                continue;
            }
            if (!str2.equalsIgnoreCase("metadata")) continue;
            this.adlMetadata = new ADLMetadata();
            bool = this.adlMetadata.fillMetadata(localNode) && bool;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        boolean bool = true;
        String str1 = this.messageLocation + "checkConformance()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        if (this.parentElem.equalsIgnoreCase("manifest")) {
            this.min = 0;
            this.max = -1;
        } else {
            this.min = 1;
            this.max = 1;
        }
        this.spm = -1;
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str2 = "";
        String str3 = "";
        str2 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str2, str1, str3);
        bool = this.checkMultiplicity(i, str1);
        bool = this.checkIdentifier() && bool;
        boolean bl = bool = this.checkVersion() && bool;
        if (this.adlMetadata != null) {
            bool = this.adlMetadata.checkConformance(paramString2) && bool;
            this.messageHandler.appendMessage(i, this.adlMetadata.getMessage(i));
        }
        bool = this.orgs.checkConformance(paramString1, paramString2) && bool;
        this.messageHandler.appendMessage(i, this.orgs.getMessage(i));
        bool = this.rscs.checkConformance(paramString2, this.xmlBase) && bool;
        this.messageHandler.appendMessage(i, this.rscs.getMessage(i));
        return bool;
    }

    public boolean checkIdentifier() {
        int i = 1;
        String str1 = new String("identifier");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkIdentifier()";
        String str4 = "";
        int m = IdentifierRules.MIN;
        int n = IdentifierRules.MAX;
        int i1 = IdentifierRules.VALUESPM;
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i = this.checkMultiplicity(j, str3, str1, m, n, this.identifier, true) && i != 0 ? 1 : 0;
        int i2 = this.identifier.length();
        if (i2 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of attribute \"" + str1 + "\" is " + i1 + " and a length of " + i2 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.identifier + "\", of attribute \"" + str1 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        return i > 0;
    }

    public boolean checkVersion() {
        int i = 1;
        String str1 = new String("version");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkVersion()";
        String str4 = "";
        int m = VersionRules.MIN;
        int n = VersionRules.MAX;
        int i1 = IdentifierRules.VALUESPM;
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i = this.checkMultiplicity(j, str3, str1, m, n, this.version, true) && i != 0 ? 1 : 0;
        int i2 = this.version.length();
        if (i2 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of attribute \"" + str1 + "\" is " + i1 + " and a length of " + i2 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.version + "\", of attribute \"" + str1 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        return i > 0;
    }

    public Vector getIDList() {
        String str = this.messageLocation + "getIDList()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        Vector<String> localVector = new Vector<String>();
        localVector.add(this.identifier);
        int i = this.manifestList.size();
        for (int j = 0; j < i; ++j) {
            localVector.addAll(((ADLManifest)this.manifestList.elementAt(j)).getIDList());
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
        }
        return localVector;
    }

    public ADLOrganizations getOrganizations() {
        return this.orgs;
    }

    public Vector getItemList() {
        String str = this.messageLocation + "ADLManifest::getItemList()";
        if (DebugIndicator.ON) {
            System.out.println("*******    " + str + "  **************");
        }
        Vector localVector = new Vector();
        localVector = this.orgs.getItemList();
        if (DebugIndicator.ON) {
            System.out.println("*******  " + str + "  **************");
            System.out.println("*******  Vector size is: " + localVector.size() + "  **************");
        }
        return localVector;
    }

    public Vector getMetadata() {
        Vector<ADLMetadata> localVector = new Vector<ADLMetadata>();
        localVector.add(this.adlMetadata);
        localVector.addAll(this.rscs.getMetadata());
        localVector.addAll(this.orgs.getMetadata());
        int i = this.manifestList.size();
        for (int j = 0; j < i; ++j) {
            localVector.addAll(((ADLManifest)this.manifestList.elementAt(j)).getMetadata());
        }
        return localVector;
    }

    public HashSet getLaunchLines() {
        int j;
        HashSet<String> localHashSet = new HashSet<String>();
        Vector localVector1 = this.orgs.getItemList();
        String str1 = new String();
        String str2 = new String();
        String str3 = new String();
        Vector localVector2 = this.rscs.getResourceList();
        int i = localVector1.size();
        if (i > 0) {
            for (j = 0; j < i; ++j) {
                ADLItem localADLItem = (ADLItem)localVector1.elementAt(j);
                str1 = localADLItem.getIdentifierref();
                str2 = localADLItem.getParameterString();
                if (str1.equals("") || (str3 = this.lookupResourceHref(str1)).equals("")) continue;
                str3 = str3 + str2;
                localHashSet.add(str3);
            }
        }
        j = localVector2.size();
        for (int k = 0; k < j; ++k) {
            ADLResource localADLResource = (ADLResource)localVector2.elementAt(k);
            if (!localADLResource.getADLCPScormtype().equalsIgnoreCase("sco")) continue;
            str3 = localADLResource.getFullLaunchLocation();
            localHashSet.add(str3);
        }
        if (DebugIndicator.ON) {
            System.out.println("RETURNING size" + localHashSet.size());
        }
        return localHashSet;
    }

    public String lookupResourceHref(String paramString) {
        Vector localVector = this.rscs.getResourceList();
        String str1 = new String();
        String str2 = new String();
        int i = localVector.size();
        for (int j = 0; j < i; ++j) {
            ADLResource localADLResource = (ADLResource)localVector.elementAt(j);
            str1 = localADLResource.getIdentifier();
            if (!str1.equals(paramString) || !localADLResource.getADLCPScormtype().equalsIgnoreCase("sco")) continue;
            str2 = localADLResource.getFullLaunchLocation();
            break;
        }
        return str2;
    }
}

