/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.ADLCPLocationRules;
import org.adl.parsers.util.adlrules.manifest.MetadataRules;
import org.adl.parsers.util.adlrules.manifest.SchemaRules;
import org.adl.parsers.util.adlrules.manifest.SchemaversionRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLMetadata
extends ADLElement
implements Serializable {
    private Node metadataRoot = null;
    private String parentElementName = "";
    private String parentElementID = "";
    private String metadataType = "";
    private String schema = "";
    private String schemaversion = "";
    private String adlcpLocation = "";
    private int schemaMult = -1;
    private int schemaversionMult = -1;
    private int adlcpLocationMult = -1;
    private int messageClass = MessageClassification.MINIMUM;
    private String messageLocation = "ADLMetadata::";

    public ADLMetadata() {
        super("metadata");
    }

    public boolean fillMetadata(Node paramNode) {
        String str;
        boolean bool = true;
        URLDecoder localURLDecoder = new URLDecoder();
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        Node localNode1 = paramNode.getParentNode();
        this.parentElementName = localNode1.getLocalName();
        this.parentElementID = this.parentElementName.equalsIgnoreCase("manifest") || this.parentElementName.equalsIgnoreCase("organization") || this.parentElementName.equalsIgnoreCase("item") || this.parentElementName.equalsIgnoreCase("resource") ? this.getAttribute(localNode1, "identifier") : this.getAttribute(localNode1, "href");
        this.metadataType = this.parentElementName.equalsIgnoreCase("organization") || this.parentElementName.equalsIgnoreCase("item") ? "contentaggregation" : (this.parentElementName.equalsIgnoreCase("resource") ? ((str = this.getAttribute(localNode1, "scormtype")).equalsIgnoreCase("sco") ? "sco" : "asset") : (this.parentElementName.equalsIgnoreCase("manifest") ? "package" : "asset"));
        str = this.messageLocation + "fillMetadata(Node)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        NodeList localNodeList = paramNode.getChildNodes();
        int i = localNodeList.getLength();
        for (int j = 0; j < i; ++j) {
            Node localNode2 = localNodeList.item(j);
            if (localNode2.getNodeType() != 1) continue;
            if (localNode2.getLocalName().equalsIgnoreCase("schema")) {
                this.schemaMult = this.getMultiplicityUsed(localNode2, "schema");
                this.schema = this.getText(localNode2);
                continue;
            }
            if (localNode2.getLocalName().equalsIgnoreCase("schemaversion")) {
                this.schemaversionMult = this.getMultiplicityUsed(localNode2, "schemaversion");
                this.schemaversion = this.getText(localNode2);
                continue;
            }
            if (localNode2.getLocalName().equalsIgnoreCase("location")) {
                this.adlcpLocationMult = this.getMultiplicityUsed(paramNode, "location");
                this.adlcpLocation = this.getText(localNode2);
                this.adlcpLocation = URLDecoder.decode(this.adlcpLocation);
                continue;
            }
            if (!localNode2.getLocalName().equalsIgnoreCase("lom")) continue;
            this.metadataRoot = localNode2;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkConformance(String paramString) {
        boolean bool = true;
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str1 = "";
        String str2 = this.messageLocation + "checkConformance()";
        String str3 = "";
        if (this.parentElementName.equalsIgnoreCase("manifest") || this.parentElementName.equalsIgnoreCase("resource") || this.parentElementName.equalsIgnoreCase("file")) {
            this.min = MetadataRules.MIN;
            this.max = MetadataRules.MAX;
        } else if (this.parentElementName.equalsIgnoreCase("organization") || this.parentElementName.equalsIgnoreCase("item")) {
            this.min = MetadataRules.AMIN;
            this.max = MetadataRules.AMAX;
        }
        str1 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        bool = this.checkMultiplicity(i, str2);
        bool = this.checkSchema() && bool;
        boolean bl = bool = this.checkSchemaversion() && bool;
        if (this.metadataRoot == null && this.adlcpLocationMult > 0) {
            bool = this.checkADLCPLocation(paramString) && bool;
        } else if (this.adlcpLocationMult > 0) {
            j = MessageType.FAILED;
            str1 = "Element <location> can not be used in conjunction with in-line meta-data";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            bool = false;
        }
        return bool;
    }

    public boolean checkSchema() {
        int i3;
        int i = 1;
        String str1 = "schema";
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkSchema()";
        String str4 = "";
        int m = -1;
        int n = -1;
        if (this.parentElementName.equalsIgnoreCase("manifest") || this.parentElementName.equalsIgnoreCase("resource") || this.parentElementName.equalsIgnoreCase("file")) {
            m = SchemaRules.MIN;
            n = SchemaRules.MAX;
        } else if (this.parentElementName.equalsIgnoreCase("organization") || this.parentElementName.equalsIgnoreCase("item")) {
            m = SchemaRules.AMIN;
            n = SchemaRules.AMAX;
        }
        int i1 = SchemaRules.VALUESPM;
        int i2 = SchemaRules.VOCABSIZE;
        Vector<String> localVector = new Vector<String>(i2);
        for (i3 = 0; i3 < i2; ++i3) {
            localVector.add(SchemaRules.VOCAB[i3]);
        }
        str2 = "Testing element <" + str1 + "> for minimum " + "conformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        if (this.schemaMult != -1) {
            if (this.schemaMult >= m && this.schemaMult <= n) {
                k = MessageType.PASSED;
                str2 = "Element <" + str1 + "> passed the multiplicity " + "test";
                i = 1;
            } else if (m == n) {
                k = MessageType.FAILED;
                str2 = "The multiplicity for element <" + str1 + "> is " + m + " and only " + n + " and " + this.multiplicity + " were found.";
            } else {
                k = MessageType.FAILED;
                str2 = "The multiplicity for element <" + str1 + "> is " + m + " or " + n + " and " + this.multiplicity + " were found.";
            }
        }
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i3 = this.schema.length();
        if (i3 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of element <" + this.elemName + "> is " + i1 + " and a length of " + i3 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.schema + "\"element <" + this.elemName + "> passed the smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        if (!this.schema.equalsIgnoreCase("")) {
            int i6;
            boolean i4 = false;
            int i5 = localVector.size();
            for (i6 = 0; i6 < i5 && !i4; ++i6) {
                if (!this.schema.equalsIgnoreCase((String)localVector.elementAt(i6))) continue;
                k = MessageType.PASSED;
                str2 = "Element <" + str1 + "> passed the vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                i4 = true;
            }
            if (!i4) {
                k = MessageType.FAILED;
                str2 = "Element <" + str1 + "> did not adhere to the " + "restricted vocabulary and failed the vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                str2 = "Vocabulary list for element <" + str1 + "> is as follows:";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                for (i6 = 0; i6 < i5; ++i6) {
                    str2 = (String)localVector.elementAt(i6);
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                }
                i = 1;
            }
        }
        return i > 0;
    }

    public boolean checkSchemaversion() {
        int i3;
        int i = 1;
        String str1 = "schemaversion";
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkSchemaversion()";
        String str4 = "";
        int m = -1;
        int n = -1;
        if (this.parentElementName.equalsIgnoreCase("manifest") || this.parentElementName.equalsIgnoreCase("resource") || this.parentElementName.equalsIgnoreCase("file")) {
            m = SchemaversionRules.MIN;
            n = SchemaversionRules.MAX;
        } else if (this.parentElementName.equalsIgnoreCase("organization") || this.parentElementName.equalsIgnoreCase("item")) {
            m = SchemaversionRules.AMIN;
            n = SchemaversionRules.AMAX;
        }
        int i1 = SchemaversionRules.VALUESPM;
        int i2 = SchemaversionRules.VOCABSIZE;
        Vector<String> localVector = new Vector<String>(i2);
        for (i3 = 0; i3 < i2; ++i3) {
            localVector.add(SchemaversionRules.VOCAB[i3]);
        }
        str2 = "Testing element <" + str1 + "> for minimum " + "conformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        if (this.schemaversionMult != -1) {
            if (this.schemaversionMult >= m && this.schemaversionMult <= n) {
                k = MessageType.PASSED;
                str2 = "Element <" + str1 + "> passed the multiplicity " + "test";
                i = 1;
            } else if (m == n) {
                k = MessageType.FAILED;
                str2 = "The multiplicity for element <" + str1 + "> is " + m + " and only " + n + " and " + this.multiplicity + " were found.";
            } else {
                k = MessageType.FAILED;
                str2 = "The multiplicity for element <" + str1 + "> is " + m + " or " + n + " and " + this.multiplicity + " were found.";
            }
        }
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i3 = this.schemaversion.length();
        if (i3 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of element <" + this.elemName + "> is " + i1 + " and a length of " + i3 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.schemaversion + "\" element <" + this.elemName + "> passed the smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        if (this.schema.equalsIgnoreCase("ADL SCORM")) {
            int i6;
            boolean i4 = false;
            int i5 = localVector.size();
            for (i6 = 0; i6 < i5 && !i4; ++i6) {
                if (!this.schemaversion.equalsIgnoreCase((String)localVector.elementAt(i6))) continue;
                k = MessageType.PASSED;
                str2 = "Element <" + str1 + "> passed the " + "vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                i4 = true;
            }
            if (!i4) {
                k = MessageType.FAILED;
                str2 = "Element <" + str1 + "> did not adhere to the " + "restricted vocabulary and failed the vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                str2 = "Vocabulary list for element <" + str1 + "> is as follows:";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                for (i6 = 0; i6 < i5; ++i6) {
                    str2 = (String)localVector.elementAt(i6);
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                }
                i = 0;
            }
        }
        return i > 0;
    }

    public boolean checkADLCPLocation(String paramString) {
        String str1 = this.messageLocation + "checkADLCPLocation()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("location");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str3 = "";
        String str4 = "";
        int k = ADLCPLocationRules.MIN;
        int m = ADLCPLocationRules.MAX;
        int n = ADLCPLocationRules.VALUESPM;
        str3 = "Testing element <" + str2 + "> for minimum " + "comformance";
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        if (this.adlcpLocationMult != -1) {
            if (this.adlcpLocationMult >= k && this.adlcpLocationMult <= m) {
                j = MessageType.PASSED;
                str3 = "Element <" + str2 + "> passed the multiplicity " + "test";
            } else {
                if (k == m) {
                    j = MessageType.FAILED;
                    str3 = "The multiplicity for element <" + str2 + "> is " + k + " and only " + m + " and " + this.adlcpLocationMult + " were found.";
                } else {
                    j = MessageType.FAILED;
                    str3 = "The multiplicity for element <" + str2 + "> is " + k + " or " + m + " and " + this.adlcpLocationMult + " were found.";
                }
                bool = false;
            }
        }
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        if (!this.adlcpLocation.equalsIgnoreCase("")) {
            block24: {
                int i1 = this.adlcpLocation.length();
                if (i1 > n) {
                    j = MessageType.WARNING;
                    str3 = "The smallest permitted maximum for the value of element <" + str2 + "> is " + n + " and a length of " + i1 + " was found.";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                } else {
                    j = MessageType.PASSED;
                    str3 = "The value, \"" + this.adlcpLocation + "\"element <" + str2 + "> passed the smallest permitted maximum test";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                }
                try {
                    File localFile;
                    if (DebugIndicator.ON) {
                        System.out.println("%%%  baseDir = " + paramString);
                        System.out.println("%%%  relative adlcpLocation = " + this.adlcpLocation);
                    }
                    String str5 = new String(paramString + this.adlcpLocation);
                    if (DebugIndicator.ON) {
                        System.out.println("locationPath = " + str5);
                    }
                    if ((localFile = new File(str5)).isFile()) {
                        j = MessageType.PASSED;
                        str3 = "File \"" + this.adlcpLocation + "\" has been detected";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        break block24;
                    }
                    boolean i2 = true;
                    try {
                        URL localURL = new URL(this.adlcpLocation);
                        if (i2) {
                            String str6 = localURL.getProtocol();
                            if (str6.equalsIgnoreCase("file")) {
                                j = MessageType.FAILED;
                                str3 = "File or URL \"" + this.adlcpLocation + "\" could not be detected";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                                bool = false;
                            } else {
                                j = MessageType.PASSED;
                                str3 = "URL \"" + this.adlcpLocation + "\" has been detected";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                            }
                            break block24;
                        }
                        j = MessageType.FAILED;
                        str3 = "File or URL \"" + this.adlcpLocation + "\" could not be detected";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                    catch (MalformedURLException localMalformedURLException) {
                        j = MessageType.FAILED;
                        str3 = "URL \"" + this.adlcpLocation + "\" could not be detected";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                }
                catch (NullPointerException localNullPointerException) {
                    if (DebugIndicator.ON) {
                        System.out.println("NullPointerException thrown when accessing " + this.adlcpLocation);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.adlcpLocation + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
                catch (SecurityException localSecurityException) {
                    if (DebugIndicator.ON) {
                        System.out.println("SecurityException thrown when accessing " + this.adlcpLocation);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.adlcpLocation + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
            }
            if (this.metadataRoot != null) {
                j = MessageType.FAILED;
                str3 = "Both the <adlcp:location> element and in-line methods  were found to express metadata.  Only one or the other is allowed, but not both";
                this.messageHandler.addMessage(i, j, str3, str1, str4);
                bool = false;
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public Node getMetadataRoot() {
        return this.metadataRoot;
    }

    public String getMetadataLocation() {
        return this.adlcpLocation;
    }

    public String getMetadataType() {
        return this.metadataType;
    }

    public String getParentName() {
        return this.parentElementName;
    }

    public String getParentID() {
        return this.parentElementID;
    }
}

