/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.Serializable;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLItem;
import org.adl.parsers.dom.ADLMetadata;
import org.adl.parsers.dom.ADLSequence;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.IdentifierRules;
import org.adl.parsers.util.adlrules.manifest.IsvisibleRules;
import org.adl.parsers.util.adlrules.manifest.OrganizationRules;
import org.adl.parsers.util.adlrules.manifest.StructureRules;
import org.adl.parsers.util.adlrules.manifest.TitleRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLOrganization
extends ADLElement
implements Serializable {
    private Vector itemList = new Vector();
    private ADLMetadata adlMetadata = null;
    private ADLSequence adlSequence = null;
    private String titleElem = new String();
    private String identifierAttr = new String();
    private String structureAttr = new String();
    private String isVisible = new String();
    private int messageClass = MessageClassification.MINIMUM;
    private String messageLocation = "ADLOrganization::";

    public ADLOrganization() {
        super("organization");
    }

    public boolean fillOrg(Node paramNode, Vector paramVector) {
        boolean bool = true;
        int i = 2;
        int j = 0;
        int k = 0;
        int m = 0;
        int n = 0;
        int i1 = 0;
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        if (DebugIndicator.ON) {
            System.out.println("******  ADLOrganization:fillOrg()  *********");
        }
        this.identifierAttr = this.getAttribute(paramNode, "identifier");
        this.structureAttr = this.getAttribute(paramNode, "structure");
        NodeList localNodeList = paramNode.getChildNodes();
        for (int i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            Node localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            if (localNode.getLocalName().equalsIgnoreCase("item")) {
                ADLItem localADLItem = new ADLItem();
                String str1 = this.getAttribute(localNode, "identifier");
                String str2 = this.getAttribute(localNode, "identifierref");
                String str3 = this.getAttribute(localNode, "isvisible");
                String str4 = this.getAttribute(localNode, "parameters");
                String str5 = this.getSubElement(localNode, "title");
                String str6 = this.getSubElement(localNode, "prerequisites");
                String str7 = this.getSubElement(localNode, "timelimitaction");
                String str8 = this.getSubElement(localNode, "maxtimeallowed");
                String str9 = this.getSubElement(localNode, "datafromlms");
                String str10 = this.getSubElement(localNode, "masteryscore");
                j = this.getMultiplicityUsed(localNode, "prerequisites");
                k = this.getMultiplicityUsed(localNode, "maxtimeallowed");
                m = this.getMultiplicityUsed(localNode, "timelimitaction");
                n = this.getMultiplicityUsed(localNode, "datafromlms");
                i1 = this.getMultiplicityUsed(localNode, "masteryscore");
                localADLItem.setIdentifier(str1);
                if (!str2.equals("")) {
                    localADLItem.setIdentifierref(str2);
                } else {
                    localADLItem.setIdentifierref("");
                }
                localADLItem.setIsVisible(str3);
                if (!str4.equals("")) {
                    localADLItem.setParameterString(str4);
                } else {
                    localADLItem.setParameterString("");
                }
                localADLItem.setTitle(str5);
                localADLItem.setPrerequisites(str6);
                localADLItem.setTimeLimitAction(str7);
                localADLItem.setMaxTimeAllowed(str8);
                localADLItem.setDataFromLMS(str9);
                localADLItem.setMasteryScore(str10);
                localADLItem.setLevel(0);
                localADLItem.setPrerequisitesMultiplicityUsed(j);
                localADLItem.setMaxTimeAllowedMultiplicityUsed(k);
                localADLItem.setTimeLimitActionMultiplicityUsed(m);
                localADLItem.setDataFromLMSMultiplicityUsed(n);
                localADLItem.setMasteryScoreMultiplicityUsed(i1);
                bool = localADLItem.fillItem(localNode, paramVector);
                this.itemList.addElement(localADLItem);
                continue;
            }
            if (localNode.getLocalName().equalsIgnoreCase("title")) {
                this.titleElem = this.getText(localNode);
                continue;
            }
            if (localNode.getLocalName().equalsIgnoreCase("metadata")) {
                this.adlMetadata = new ADLMetadata();
                bool = this.adlMetadata.fillMetadata(localNode) && bool;
                continue;
            }
            if (!localNode.getLocalName().equalsIgnoreCase("sequencing")) continue;
            this.adlSequence = new ADLSequence();
            bool = this.adlSequence.fillSequence(localNode) && bool;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting ADLOrganization::fillOrg() ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public Vector getItemList() {
        if (DebugIndicator.ON) {
            System.out.println("*******    ADLOrganization::getItemList()  **************");
        }
        Vector localVector1 = new Vector();
        Vector<ADLItem> localVector2 = new Vector<ADLItem>();
        for (int i = 0; i < this.itemList.size(); ++i) {
            ADLItem localADLItem = (ADLItem)this.itemList.elementAt(i);
            localVector2.addElement(localADLItem);
            Vector localVector3 = localADLItem.getItemList();
            localVector2.addAll(localVector3);
        }
        localVector1.addAll(localVector2);
        if (DebugIndicator.ON) {
            System.out.println("*******    EXITING  ADLOrganization::getItemList()  **************");
            System.out.println("*******  Vector size is: " + localVector1.size() + "  **************");
        }
        return localVector1;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        boolean bool = true;
        if (paramString1.equalsIgnoreCase("aggregation")) {
            this.min = OrganizationRules.AMIN;
            this.max = OrganizationRules.AMAX;
        } else {
            this.min = OrganizationRules.RMIN;
            this.max = OrganizationRules.RMAX;
        }
        this.spm = OrganizationRules.SPM;
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str1 = "";
        String str2 = this.messageLocation + "checkConformance()";
        String str3 = "";
        str1 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        bool = this.checkMultiplicity(j, str2);
        bool = this.checkIdentifier() && bool;
        bool = this.checkStructure(paramString1) && bool;
        bool = this.checkIsVisible(paramString1) && bool;
        bool = this.checkTitle(paramString1) && bool;
        int i = this.itemList.size();
        for (int m = 0; m < i; ++m) {
            bool = ((ADLItem)this.itemList.elementAt(m)).checkConformance(paramString1, paramString2) && bool;
            this.messageHandler.appendMessage(j, ((ADLItem)this.itemList.elementAt(m)).getMessage(j));
        }
        if (this.adlMetadata != null) {
            bool = this.adlMetadata.checkConformance(paramString2) && bool;
            this.messageHandler.appendMessage(j, this.adlMetadata.getMessage(j));
        }
        return bool;
    }

    public boolean checkIdentifier() {
        int i = 1;
        String str1 = new String("identifier");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkIdentifier()";
        String str4 = "";
        int m = IdentifierRules.MIN;
        int n = IdentifierRules.MAX;
        int i1 = IdentifierRules.VALUESPM;
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i = this.checkMultiplicity(j, str3, str1, m, n, this.identifierAttr, true) && i != 0 ? 1 : 0;
        int i2 = this.identifierAttr.length();
        if (i2 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of attribute \"" + str1 + "\" is " + i1 + " and a length of " + i2 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.identifierAttr + "\", of attribute \"" + str1 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        return i > 0;
    }

    public boolean checkIsVisible(String paramString) {
        int i2;
        int i = 1;
        String str1 = new String("isvisible");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkIsVisible()";
        String str4 = "";
        int m = -1;
        int n = -1;
        if (paramString.equalsIgnoreCase("aggregation")) {
            m = IsvisibleRules.AMIN;
            n = IsvisibleRules.AMAX;
        } else {
            m = IsvisibleRules.RMIN;
            n = IsvisibleRules.RMAX;
        }
        int i1 = IsvisibleRules.VOCABSIZE;
        Vector<String> localVector = new Vector<String>(i1);
        for (i2 = 0; i2 < i1; ++i2) {
            localVector.add(IsvisibleRules.VOCAB[i2]);
        }
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        int n2 = i = this.checkMultiplicity(j, str3, str1, m, n, this.isVisible, true) && i != 0 ? 1 : 0;
        if (this.isVisible.equalsIgnoreCase("")) {
            k = MessageType.PASSED;
            str2 = "Attribute \"" + str1 + "\" was not found or was " + "left blank.  It is assumed that the default value of " + "\"true\" will be used.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            int i4;
            i2 = 0;
            int i3 = localVector.size();
            for (i4 = 0; i4 < i3 && i2 == 0; ++i4) {
                if (!this.isVisible.equalsIgnoreCase((String)localVector.elementAt(i4))) continue;
                k = MessageType.PASSED;
                str2 = "Attribute \"" + str1 + "\" passed the " + "vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                i2 = 1;
            }
            if (i2 == 0) {
                k = MessageType.FAILED;
                str2 = "Attribute \"" + str1 + "\" did not adhere to the " + "restricted vocabulary and failed the vocabulary test";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                str2 = "Vocabulary list for attribute \"" + str1 + "\" is as follows:";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                for (i4 = 0; i4 < i3; ++i4) {
                    str2 = (String)localVector.elementAt(i4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                }
                i = 0;
            }
        }
        return i > 0;
    }

    public boolean checkStructure(String paramString) {
        int i = 1;
        String str1 = new String("structure");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkStructure()";
        String str4 = "";
        int m = -1;
        int n = -1;
        if (paramString.equalsIgnoreCase("aggregation")) {
            m = StructureRules.AMIN;
            n = StructureRules.AMAX;
        } else {
            m = StructureRules.RMIN;
            n = StructureRules.RMAX;
        }
        int i1 = StructureRules.VALUESPM;
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i = this.checkMultiplicity(j, str3, str1, m, n, this.structureAttr, true) && i != 0 ? 1 : 0;
        int i2 = this.structureAttr.length();
        if (i2 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of attribute \"" + str1 + "\" is " + i1 + " and a length of " + i2 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.structureAttr + "\", of attribute \"" + str1 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        return i > 0;
    }

    public boolean checkTitle(String paramString) {
        int i = 1;
        String str1 = new String("title");
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkTitle()";
        String str4 = "";
        int m = -1;
        int n = -1;
        if (paramString.equalsIgnoreCase("aggregation")) {
            m = TitleRules.AMIN;
            n = TitleRules.AMAX;
        } else {
            m = TitleRules.RMIN;
            n = TitleRules.RMAX;
        }
        int i1 = TitleRules.VALUESPM;
        str2 = "Testing element <" + str1 + "> for minimum " + "comformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        i = this.checkMultiplicity(j, str3, str1, m, n, this.titleElem, false) && i != 0 ? 1 : 0;
        int i2 = this.titleElem.length();
        if (i2 > i1) {
            k = MessageType.WARNING;
            str2 = "The smallest permitted maximum for the value of element <" + str1 + "> is " + i1 + " and a length of " + i2 + " was found.";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        } else {
            k = MessageType.PASSED;
            str2 = "The value, \"" + this.titleElem + "\", of element <" + str1 + "> passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
        }
        return i > 0;
    }

    public ADLSequence getSequence() {
        ADLSequence localObject = new ADLSequence();
        ADLSequence localADLSequence = new ADLSequence();
        localObject = this.adlSequence == null ? localADLSequence : this.adlSequence;
        return localObject;
    }

    public String getIdentifier() {
        return this.identifierAttr;
    }

    public Vector getMetadata() {
        Vector<ADLMetadata> localVector = new Vector<ADLMetadata>();
        localVector.add(this.adlMetadata);
        int i = this.itemList.size();
        for (int j = 0; j < i; ++j) {
            localVector.addAll(((ADLItem)this.itemList.elementAt(j)).getMetadata());
        }
        return localVector;
    }
}

