/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.Serializable;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLOrganization;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.DefaultRules;
import org.adl.parsers.util.adlrules.manifest.OrganizationsRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLOrganizations
extends ADLElement
implements Serializable {
    private Vector organizationList = new Vector();
    private String defaultAttr = new String();
    private int messageClass = MessageClassification.MINIMUM;
    private String messageLocation = "ADLOrganizations::";

    public ADLOrganizations() {
        super("organizations");
    }

    public boolean fillOrgs(Node paramNode, Vector paramVector) {
        boolean bool = true;
        boolean i = true;
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        if (DebugIndicator.ON) {
            System.out.println("******  ADLOrganizations:fillOrgs  *********");
        }
        this.defaultAttr = this.getAttribute(paramNode, "default");
        NodeList localNodeList = paramNode.getChildNodes();
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            Node localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !localNode.getLocalName().equalsIgnoreCase("organization")) continue;
            ADLOrganization localADLOrganization = new ADLOrganization();
            bool = localADLOrganization.fillOrg(localNode, paramVector);
            this.organizationList.addElement(localADLOrganization);
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting ADLOrganizations::fillOrgs() ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public ADLOrganization getFirstOrg() {
        return (ADLOrganization)this.organizationList.elementAt(0);
    }

    public Vector getItemList() {
        Vector localVector = new Vector();
        for (int i = 0; i < this.organizationList.size(); ++i) {
            ADLOrganization localADLOrganization = (ADLOrganization)this.organizationList.elementAt(i);
            localVector.addAll(localADLOrganization.getItemList());
        }
        return localVector;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        if (DebugIndicator.ON) {
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            System.out.println("###   organizations");
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        }
        boolean bool = true;
        this.min = OrganizationsRules.MIN;
        this.max = OrganizationsRules.MAX;
        this.spm = OrganizationsRules.SPM;
        int i = this.organizationList.size();
        int j = this.messageClass;
        int k = MessageType.INFO;
        String str1 = "";
        String str2 = this.messageLocation + "checkConformance()";
        String str3 = "";
        str1 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        bool = this.checkMultiplicity(j, str2);
        boolean bl = bool = this.checkDefault(paramString1) && bool;
        if (DebugIndicator.ON) {
            System.out.println("");
            System.out.println("Application Profile = " + paramString1);
            System.out.println("numOrg = " + i);
        }
        if (paramString1.equalsIgnoreCase("aggregation") && i < 1) {
            k = MessageType.FAILED;
            str1 = "Element <organization> was not found.";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
            bool = false;
        } else if (paramString1.equalsIgnoreCase("resource") && i > 0) {
            k = MessageType.FAILED;
            str1 = "Element <organizations> is not empty.";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
            bool = false;
        } else {
            for (int m = 0; m < i; ++m) {
                bool = ((ADLOrganization)this.organizationList.elementAt(m)).checkConformance(paramString1, paramString2) && bool;
                this.messageHandler.appendMessage(j, ((ADLOrganization)this.organizationList.elementAt(m)).getMessage(j));
            }
        }
        return bool;
    }

    public boolean checkDefault(String paramString) {
        int i3;
        int i = 1;
        String str1 = new String("default");
        int j = this.organizationList.size();
        int k = this.messageClass;
        int m = MessageType.INFO;
        String str2 = "";
        String str3 = this.messageLocation + "checkDefault()";
        String str4 = "";
        int n = -1;
        int i1 = -1;
        if (paramString.equalsIgnoreCase("aggregation")) {
            n = DefaultRules.AMIN;
            i1 = DefaultRules.AMAX;
        } else {
            n = DefaultRules.RMIN;
            i1 = DefaultRules.RMAX;
        }
        int i2 = this.organizationList.size();
        Vector<String> localVector = new Vector<String>();
        for (i3 = 0; i3 < i2; ++i3) {
            localVector.add(((ADLOrganization)this.organizationList.elementAt(i3)).getIdentifier());
        }
        str2 = "Testing attribute \"" + str1 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(k, m, str2, str3, str4);
        if (DebugIndicator.ON) {
            System.out.println("");
            System.out.println("defaultAttr = " + this.defaultAttr);
        }
        int n2 = i = this.checkMultiplicity(k, str3, str1, n, i1, this.defaultAttr, true) && i != 0 ? 1 : 0;
        if (paramString.equalsIgnoreCase("aggregation") && !this.defaultAttr.equals("")) {
            i3 = 0;
            int i4 = localVector.size();
            String str5 = "";
            for (int i5 = 0; i5 < i4; ++i5) {
                str5 = (String)localVector.elementAt(i5);
                if (!str5.equalsIgnoreCase(this.defaultAttr)) continue;
                i3 = 1;
                break;
            }
            if (i3 != 0) {
                m = MessageType.PASSED;
                str2 = "Organization identifier \"" + this.defaultAttr + "\" has " + "been found";
                this.messageHandler.addMessage(k, m, str2, str3, str4);
            } else {
                m = MessageType.FAILED;
                str2 = "Organization identifier \"" + this.defaultAttr + "\" could " + "not be found and failed the referenced identifier test";
                this.messageHandler.addMessage(k, m, str2, str3, str4);
                i = 0;
            }
        } else if (paramString.equalsIgnoreCase("aggregation") && i2 > 1) {
            m = MessageType.WARNING;
            str2 = "Multiple <organization> elements have been detected and it is best practice to use and set the default attribute of the <organizations> element to reference an identifier attribute of one of the <organization> elements";
            this.messageHandler.addMessage(k, m, str2, str3, str4);
        }
        return i > 0;
    }

    public Vector getMetadata() {
        Vector localVector = new Vector();
        int i = this.organizationList.size();
        for (int j = 0; j < i; ++j) {
            localVector.addAll(((ADLOrganization)this.organizationList.elementAt(j)).getMetadata());
        }
        return localVector;
    }
}

