/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLFile;
import org.adl.parsers.dom.ADLMetadata;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.ADLCPScormtypeRules;
import org.adl.parsers.util.adlrules.manifest.HrefRules;
import org.adl.parsers.util.adlrules.manifest.IdentifierRules;
import org.adl.parsers.util.adlrules.manifest.IdentifierrefRules;
import org.adl.parsers.util.adlrules.manifest.ResourceRules;
import org.adl.parsers.util.adlrules.manifest.TypeRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLResource
extends ADLElement
implements Serializable {
    private ADLMetadata adlMetadata = null;
    private Vector fileList = new Vector();
    private Vector dependencyList = new Vector();
    private Vector dependencyTextEmpty = new Vector();
    private Vector idExists;
    private String identifier = new String();
    private String type = new String();
    private String adlcpScormtype = new String();
    private String href = new String();
    private String xmlBase;
    private String fullLaunchLocation;
    private int messageClass;
    private String messageLocation = "ADLResource::";

    public ADLResource() {
        super("resource");
        this.idExists = new Vector();
        this.xmlBase = new String();
        this.fullLaunchLocation = new String();
        this.messageClass = MessageClassification.MINIMUM;
    }

    public boolean fillResource(Node paramNode) {
        String str1 = this.messageLocation + "fillResource(Node)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        int i = 2;
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        this.identifier = this.getAttribute(paramNode, "identifier");
        this.type = this.getAttribute(paramNode, "type");
        this.adlcpScormtype = this.getAttribute(paramNode, "scormtype");
        this.href = this.getAttribute(paramNode, "href");
        this.xmlBase = this.getAttribute(paramNode, "base");
        if (this.xmlBase.length() > 0) {
            this.xmlBase = this.xmlBase.replace('\\', '/');
            if (this.xmlBase.charAt(this.xmlBase.length() - 1) != '/') {
                this.xmlBase = this.xmlBase + '/';
            }
        }
        NodeList localNodeList = paramNode.getChildNodes();
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            Object localObject;
            Node localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1) continue;
            if (localNode.getLocalName().equalsIgnoreCase("file")) {
                localObject = new ADLFile();
                bool = ((ADLFile)localObject).fillFile(localNode) && bool;
                this.fileList.add(localObject);
                continue;
            }
            if (localNode.getLocalName().equalsIgnoreCase("dependency")) {
                localObject = this.getText(localNode);
                if (((String)localObject).equalsIgnoreCase("")) {
                    this.dependencyTextEmpty.add(new Boolean("true"));
                } else {
                    this.dependencyTextEmpty.add(new Boolean("false"));
                }
                String str2 = this.getIdentifierrefAttribute(paramNode, "dependency");
                this.dependencyList.add(str2);
                continue;
            }
            if (!localNode.getLocalName().equalsIgnoreCase("metadata")) continue;
            this.adlMetadata = new ADLMetadata();
            bool = this.adlMetadata.fillMetadata(localNode) && bool;
        }
        if (this.dependencyTextEmpty.size() != this.dependencyList.size()) {
            bool = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        String str1 = this.messageLocation + "checkConformance(String)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        this.min = ResourceRules.MIN;
        this.max = ResourceRules.MAX;
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str2 = "";
        String str3 = "";
        str2 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str2, str1, str3);
        bool = this.checkMultiplicity(i, str1);
        String str4 = new String();
        str4 = paramString2 + this.xmlBase;
        bool = this.checkIdentifier() && bool;
        bool = this.checkType() && bool;
        bool = this.checkAdlcpScormtype() && bool;
        bool = this.checkHref(paramString1, str4) && bool;
        int k = this.fileList.size();
        for (int m = 0; m < k; ++m) {
            bool = ((ADLFile)this.fileList.elementAt(m)).checkConformance(paramString1, str4) && bool;
            this.messageHandler.appendMessage(i, ((ADLFile)this.fileList.elementAt(m)).getMessage(i));
        }
        boolean bl = bool = this.checkDependency() && bool;
        if (this.adlMetadata != null) {
            bool = this.adlMetadata.checkConformance(paramString1) && bool;
            this.messageHandler.appendMessage(i, this.adlMetadata.getMessage(i));
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkIdentifier() {
        String str1 = this.messageLocation + "checkIdentifier()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("identifier");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str3 = "";
        String str4 = "";
        int k = IdentifierRules.MIN;
        int m = IdentifierRules.MAX;
        int n = IdentifierRules.VALUESPM;
        str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        bool = this.checkMultiplicity(i, str1, str2, k, m, this.identifier, true) && bool;
        int i1 = this.identifier.length();
        if (i1 > n) {
            j = MessageType.WARNING;
            str3 = "The smallest permitted maximum for the value of attribute \"" + str2 + "\" is " + n + " and a length of " + i1 + " was found.";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        } else {
            j = MessageType.PASSED;
            str3 = "The value, \"" + this.identifier + "\", of attribute \"" + str2 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkType() {
        int i4;
        int i2;
        String str1 = this.messageLocation + "checkType()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("type");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str3 = "";
        String str4 = "";
        int k = TypeRules.MIN;
        int m = TypeRules.MAX;
        int n = TypeRules.VALUESPM;
        int i1 = TypeRules.VOCABSIZE;
        Vector<String> localVector = new Vector<String>(i1);
        for (i2 = 0; i2 < i1; ++i2) {
            localVector.add(TypeRules.VOCAB[i2]);
        }
        str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        bool = this.checkMultiplicity(i, str1, str2, k, m, this.type, true) && bool;
        i2 = 0;
        int i3 = localVector.size();
        for (i4 = 0; i4 < i3 && i2 == 0; ++i4) {
            if (!this.type.equalsIgnoreCase((String)localVector.elementAt(i4))) continue;
            j = MessageType.PASSED;
            str3 = "Attribute \"" + str2 + "\" passed the " + "vocabulary test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            i2 = 1;
        }
        if (i2 == 0) {
            j = MessageType.FAILED;
            str3 = "Attribute \"" + str2 + "\" did not adhere to the " + "restricted vocabulary and failed the vocabulary test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            str3 = "Vocabulary list for attribute \"" + str2 + "\" is as follows:";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            for (i4 = 0; i4 < i3; ++i4) {
                str3 = (String)localVector.elementAt(i4);
                this.messageHandler.addMessage(i, j, str3, str1, str4);
            }
            bool = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkAdlcpScormtype() {
        int i3;
        int i1;
        String str1 = this.messageLocation + "checkAdlcpScormtype()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("scormtype");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str3 = "";
        String str4 = "";
        int k = ADLCPScormtypeRules.MIN;
        int m = ADLCPScormtypeRules.MAX;
        int n = ADLCPScormtypeRules.VOCABSIZE;
        Vector<String> localVector = new Vector<String>(n);
        for (i1 = 0; i1 < n; ++i1) {
            localVector.add(ADLCPScormtypeRules.VOCAB[i1]);
        }
        str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        bool = this.checkMultiplicity(i, str1, str2, k, m, this.adlcpScormtype, true) && bool;
        i1 = 0;
        int i2 = localVector.size();
        if (this.adlcpScormtype.equalsIgnoreCase("")) {
            j = MessageType.PASSED;
            str3 = "Element <" + this.elemName + "> passed the vocabulary test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            i1 = 1;
        } else {
            for (i3 = 0; i3 < i2 && i1 == 0; ++i3) {
                if (!this.adlcpScormtype.equalsIgnoreCase((String)localVector.elementAt(i3))) continue;
                j = MessageType.PASSED;
                str3 = "Attribute \"" + str2 + "\" passed the " + "vocabulary test";
                this.messageHandler.addMessage(i, j, str3, str1, str4);
                i1 = 1;
            }
        }
        if (i1 == 0) {
            j = MessageType.FAILED;
            str3 = "Attribute \"" + str2 + "\" did not adhere to the " + "restricted vocabulary and failed the vocabulary test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            str3 = "Vocabulary list for attribute \"" + str2 + "\" is as follows:";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            for (i3 = 0; i3 < i2; ++i3) {
                str3 = (String)localVector.elementAt(i3);
                this.messageHandler.addMessage(i, j, str3, str1, str4);
            }
            bool = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkHref(String paramString1, String paramString2) {
        boolean bool;
        String str1;
        block26: {
            str1 = this.messageLocation + "checkHref(String)";
            if (DebugIndicator.ON) {
                System.out.println("******  " + str1 + "  *********");
            }
            bool = true;
            String str2 = new String("href");
            int i = this.messageClass;
            int j = MessageType.INFO;
            String str3 = "";
            String str4 = "";
            int k = HrefRules.MIN;
            int m = HrefRules.MAX;
            int n = HrefRules.VALUESPM;
            if (this.adlcpScormtype.equalsIgnoreCase("asset")) {
                k = 0;
            }
            str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            boolean bl = bool = this.checkMultiplicity(i, str1, str2, k, m, this.href, true) && bool;
            if (!this.href.equalsIgnoreCase("")) {
                int i1 = this.href.length();
                if (i1 > n) {
                    j = MessageType.WARNING;
                    str3 = "The smallest permitted maximum for the value of attribute \"" + str2 + "\" is " + n + " and a length of " + i1 + " was found.";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                } else {
                    j = MessageType.PASSED;
                    str3 = "The value, \"" + this.href + "\", of attribute \"" + str2 + "\" passed the " + "smallest permitted maximum test";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                }
                if (this.href.charAt(0) == '/') {
                    j = MessageType.FAILED;
                    str3 = "File  \"" + this.href + "\" is referenced to the " + "users home directory.  The \"href\" attribute must " + "reference a file that is local to the package or " + "reference an external file";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    if (DebugIndicator.ON) {
                        System.out.println(str3);
                    }
                    bool = false;
                }
                try {
                    File localFile;
                    int i3;
                    String str5;
                    int i2;
                    if (DebugIndicator.ON) {
                        System.out.println("%%%  baseDir = " + paramString1);
                        System.out.println("%%%  relative href = " + this.href);
                    }
                    if ((i2 = (str5 = this.href).indexOf(63)) > 0) {
                        str5 = str5.substring(0, i2);
                        if (DebugIndicator.ON) {
                            System.out.println("query temphref: " + str5);
                        }
                    }
                    if ((i3 = str5.indexOf(35)) > 0) {
                        str5 = str5.substring(0, i3);
                        if (DebugIndicator.ON) {
                            System.out.println("fragment temphref: " + str5);
                        }
                    }
                    URLDecoder localURLDecoder = new URLDecoder();
                    str5 = URLDecoder.decode(str5);
                    this.href = URLDecoder.decode(this.href);
                    String str6 = new String(paramString1 + paramString2 + str5);
                    String str7 = new String(paramString1 + paramString2 + this.href);
                    if (DebugIndicator.ON) {
                        System.out.println("temphrefPath = " + str6);
                    }
                    if ((localFile = new File(str6)).isFile()) {
                        j = MessageType.PASSED;
                        str3 = "File \"" + this.href + "\" has been detected";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        this.fullLaunchLocation = str7;
                        break block26;
                    }
                    boolean i4 = true;
                    try {
                        String str8 = this.href;
                        this.fullLaunchLocation = this.href;
                        if (paramString2.length() > 6 && (paramString2.substring(0, 5).equals("http:") || paramString2.substring(0, 6).equals("https:"))) {
                            this.fullLaunchLocation = str8 = paramString2 + str8;
                        }
                        URL localURL = new URL(str8);
                        if (i4) {
                            String str9 = localURL.getProtocol();
                            String str10 = localURL.getFile();
                            String str11 = localURL.getQuery();
                            String str12 = localURL.getUserInfo();
                            String str13 = localURL.getRef();
                            if (str9.equalsIgnoreCase("file")) {
                                j = MessageType.FAILED;
                                str3 = "URL \"" + this.href + "\" could not be " + "verified for format";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                                bool = false;
                            } else {
                                j = MessageType.PASSED;
                                str3 = "URL \"" + this.href + "\" has been verified " + "for format";
                                this.messageHandler.addMessage(i, j, str3, str1, str4);
                            }
                            break block26;
                        }
                        j = MessageType.FAILED;
                        str3 = "File or URL \"" + this.href + "\" could not be " + "detected or verified for format";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                    catch (MalformedURLException localMalformedURLException) {
                        j = MessageType.FAILED;
                        str3 = "URL \"" + this.href + "\" could not be verified for " + "format";
                        this.messageHandler.addMessage(i, j, str3, str1, str4);
                        bool = false;
                    }
                }
                catch (NullPointerException localNullPointerException) {
                    if (DebugIndicator.ON) {
                        System.out.println("NullPointerException thrown when accessing " + this.href);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.href + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
                catch (SecurityException localSecurityException) {
                    if (DebugIndicator.ON) {
                        System.out.println("SecurityException thrown when accessing " + this.href);
                    }
                    j = MessageType.FAILED;
                    str3 = "File \"" + this.href + "\" could not be detected";
                    this.messageHandler.addMessage(i, j, str3, str1, str4);
                    bool = false;
                }
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkDependency() {
        String str1 = this.messageLocation + "checkDependency()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("dependency");
        String str3 = new String("identifierref");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str4 = "";
        String str5 = "";
        str4 = "Testing element <" + str2 + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str4, str1, str5);
        int k = this.dependencyList.size();
        for (int m = 0; m < k; ++m) {
            if (((Boolean)this.dependencyTextEmpty.elementAt(m)).booleanValue()) {
                j = MessageType.PASSED;
                str4 = "Element <" + str2 + "> is represented as an " + " empty element";
                this.messageHandler.addMessage(i, j, str4, str1, str5);
            } else {
                j = MessageType.FAILED;
                str4 = "Element <" + str2 + "> is not represented as an " + " empty element because it contains text";
                this.messageHandler.addMessage(i, j, str4, str1, str5);
                bool = false;
            }
            bool = this.checkIdentifierref((String)this.dependencyList.elementAt(m), (Boolean)this.idExists.elementAt(m)) && bool;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkIdentifierref(String paramString, boolean paramBoolean) {
        String str1 = this.messageLocation + "checkIdentitierref()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        String str2 = new String("identitierref");
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str3 = "";
        String str4 = "";
        int k = -1;
        int m = -1;
        k = IdentifierrefRules.AMIN;
        m = IdentifierrefRules.AMAX;
        int n = IdentifierrefRules.VALUESPM;
        str3 = "Testing attribute \"" + str2 + "\" for minimum " + "comformance";
        this.messageHandler.addMessage(i, j, str3, str1, str4);
        bool = this.checkMultiplicity(i, str1, str2, k, m, paramString, true) && bool;
        int i1 = paramString.length();
        if (i1 > n) {
            j = MessageType.WARNING;
            str3 = "The smallest permitted maximum for the value of attribute \"" + str2 + "\" is " + n + " and a length of " + i1 + " was found.";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        } else {
            j = MessageType.PASSED;
            str3 = "The value, \"" + paramString + "\", of attribute \"" + str2 + "\" passed the " + "smallest permitted maximum test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        }
        if (paramString.equalsIgnoreCase("")) {
            j = MessageType.PASSED;
            str3 = "Attribute \"" + str2 + "\" was not found or was " + "left blank.  It is assumed that there is no content " + "associated with this entry in the organization";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        } else if (paramBoolean) {
            j = MessageType.PASSED;
            str3 = "Resource identifier \"" + paramString + "\" has " + "been found";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
        } else {
            j = MessageType.FAILED;
            str3 = "Resource identifier \"" + paramString + "\" could " + "not be found and failed the referenced identifier test";
            this.messageHandler.addMessage(i, j, str3, str1, str4);
            bool = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean setIdExists(Vector paramVector) {
        int i = 0;
        int j = this.dependencyList.size();
        for (int k = 0; k < j; ++k) {
            String str = (String)this.dependencyList.elementAt(k);
            boolean m = false;
            int n = paramVector.size();
            for (int i1 = 0; i1 < n; ++i1) {
                if (!str.equalsIgnoreCase((String)paramVector.elementAt(i1))) continue;
                this.idExists.add(new Boolean("true"));
                m = true;
                break;
            }
            if (m) continue;
            this.idExists.add(new Boolean("false"));
        }
        if (this.idExists.size() == j) {
            i = 1;
        }
        return i > 0;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Vector getMetadata() {
        Vector<ADLMetadata> localVector = new Vector<ADLMetadata>();
        localVector.add(this.adlMetadata);
        int i = this.fileList.size();
        for (int j = 0; j < i; ++j) {
            localVector.add(((ADLFile)this.fileList.elementAt(j)).getMetadata());
        }
        return localVector;
    }

    public String getADLCPScormtype() {
        return this.adlcpScormtype;
    }

    public String getHref() {
        return this.href;
    }

    public String getFullLaunchLocation() {
        return this.fullLaunchLocation;
    }

    public String getXMLBase() {
        return this.xmlBase;
    }
}

