/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.Serializable;
import java.util.Vector;
import org.adl.parsers.dom.ADLElement;
import org.adl.parsers.dom.ADLResource;
import org.adl.parsers.util.MessageClassification;
import org.adl.parsers.util.adlrules.manifest.ResourcesRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLResources
extends ADLElement
implements Serializable {
    private Vector resourceList = new Vector();
    private String xmlBase = new String("");
    private int messageClass = MessageClassification.MINIMUM;
    private String messageLocation = "ADLResources::";

    public ADLResources() {
        super("resources");
    }

    public boolean fillResources(Node paramNode) {
        String str = this.messageLocation + "fillResources(Node)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        boolean bool = true;
        this.xmlBase = this.getAttribute(paramNode, "base");
        if (this.xmlBase.length() > 0) {
            this.xmlBase = this.xmlBase.replace('\\', '/');
            if (this.xmlBase.charAt(this.xmlBase.length() - 1) != '/') {
                this.xmlBase = this.xmlBase + '/';
            }
        }
        this.multiplicity = this.getMultiplicityUsed(paramNode.getParentNode(), this.elemName);
        NodeList localNodeList = paramNode.getChildNodes();
        for (int i = 0; i < localNodeList.getLength(); ++i) {
            Node localNode = localNodeList.item(i);
            if (localNode.getNodeType() != 1 || !localNode.getLocalName().equalsIgnoreCase("resource")) continue;
            ADLResource localADLResource = new ADLResource();
            bool = localADLResource.fillResource(localNode);
            this.resourceList.addElement(localADLResource);
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean checkConformance(String paramString1, String paramString2) {
        if (DebugIndicator.ON) {
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            System.out.println("###   resources");
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
        }
        String str1 = this.messageLocation + "checkConformance(String)";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str1 + "  *********");
        }
        boolean bool = true;
        this.min = ResourcesRules.MIN;
        this.max = ResourcesRules.MAX;
        this.spm = ResourcesRules.SPM;
        int i = this.messageClass;
        int j = MessageType.INFO;
        String str2 = "";
        String str3 = "";
        str2 = "Testing element <" + this.elemName + "> for minimum conformance";
        this.messageHandler.addMessage(i, j, str2, str1, str3);
        bool = this.checkMultiplicity(i, str1);
        String str4 = new String();
        str4 = paramString2 + this.xmlBase;
        int k = this.resourceList.size();
        for (int m = 0; m < k; ++m) {
            bool = ((ADLResource)this.resourceList.elementAt(m)).checkConformance(paramString1, str4) && bool;
            this.messageHandler.appendMessage(i, ((ADLResource)this.resourceList.elementAt(m)).getMessage(i));
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str1 + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public boolean setIdExists(Vector paramVector) {
        int i = 1;
        int j = this.resourceList.size();
        for (int k = 0; k < j; ++k) {
            i = ((ADLResource)this.resourceList.elementAt(k)).setIdExists(paramVector) && i != 0 ? 1 : 0;
        }
        return i > 0;
    }

    public Vector getResourceID() {
        String str = this.messageLocation + "getResourceID()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        int i = this.resourceList.size();
        Vector<String> localVector = new Vector<String>(i);
        for (int j = 0; j < i; ++j) {
            localVector.add(((ADLResource)this.resourceList.elementAt(j)).getIdentifier());
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + localVector);
        }
        return localVector;
    }

    public Vector getResourceList() {
        return this.resourceList;
    }

    public Vector getLaunchLines() {
        Vector<String> localVector = new Vector<String>();
        int i = this.resourceList.size();
        for (int j = 0; j < i; ++j) {
            ADLResource localADLResource = (ADLResource)this.resourceList.elementAt(j);
            String str = localADLResource.getFullLaunchLocation();
            if (!localADLResource.getADLCPScormtype().equalsIgnoreCase("sco")) continue;
            localVector.add(str);
        }
        return localVector;
    }

    public Vector getMetadata() {
        String str = this.messageLocation + "getMetadata()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        Vector localVector = new Vector();
        int i = this.resourceList.size();
        for (int j = 0; j < i; ++j) {
            localVector.addAll(((ADLResource)this.resourceList.elementAt(j)).getMetadata());
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + localVector);
        }
        return localVector;
    }
}

