/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.Serializable;
import org.adl.parsers.dom.ADLDeliveryInfo;
import org.adl.parsers.dom.ADLElement;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADLSequence
extends ADLElement
implements Serializable {
    private ADLDeliveryInfo deliveryInfo = null;
    private String isTracked;
    private String isRolledUp;
    private String rollUpInfo = new String();
    private String rollUpMastery;
    private String rollUpTotalTime;
    private String rollUpScore;
    private String control;

    public ADLSequence() {
        super("sequencing");
        this.isTracked = new String();
        this.isRolledUp = new String();
        this.rollUpMastery = new String();
        this.rollUpTotalTime = new String();
        this.rollUpScore = new String();
        this.control = new String();
    }

    public String getControl() {
        return this.control;
    }

    public String getRollUpInfo() {
        return this.rollUpInfo;
    }

    public String getIsTracked() {
        return this.isTracked;
    }

    public String getIsRolledUp() {
        return this.isRolledUp;
    }

    public String getRollUpMastery() {
        return this.rollUpMastery;
    }

    public String getRollUpTotalTime() {
        return this.rollUpTotalTime;
    }

    public String getRollUpScore() {
        return this.rollUpScore;
    }

    public void setControl(String paramString) {
        this.control = paramString;
    }

    public void setIsTracked(String paramString) {
        this.isTracked = paramString;
    }

    public void setRollUpInfo(String paramString) {
        this.rollUpInfo = paramString;
    }

    public void setIsRolledUp(String paramString) {
        this.isRolledUp = paramString;
    }

    public void setRollUpMastery(String paramString) {
        this.rollUpMastery = paramString;
    }

    public void setRollUpTotalTime(String paramString) {
        this.rollUpTotalTime = paramString;
    }

    public void setRollUpScore(String paramString) {
        this.rollUpScore = paramString;
    }

    public boolean fillSequence(Node paramNode) {
        String str1;
        boolean bool = true;
        if (DebugIndicator.ON) {
            System.out.println("******  ADLSequence:fillSequence  *********");
        }
        if ((str1 = this.getAttribute(paramNode, "control")) != null) {
            System.out.println("Found control attribute");
            this.control = str1;
        }
        NodeList localNodeList = paramNode.getChildNodes();
        if (DebugIndicator.ON) {
            System.out.println("*** NODE: " + paramNode.getNodeName());
            System.out.println("*** Children - " + localNodeList.getLength() + " ***");
        }
        for (int i = 0; i < localNodeList.getLength(); ++i) {
            String str6;
            String str5;
            String str4;
            String str3;
            String str2;
            Node localNode = localNodeList.item(i);
            if (localNode.getNodeType() != 1) continue;
            if (localNode.getLocalName().equalsIgnoreCase("deliveryinfo")) {
                if (!DebugIndicator.ON) continue;
                System.out.println("*** Found Current Node: " + localNode.getNodeName());
                continue;
            }
            if (!localNode.getLocalName().equalsIgnoreCase("rollupinfo")) continue;
            if (DebugIndicator.ON) {
                System.out.println("*** Found Current Node: " + localNode.getNodeName());
            }
            if ((str2 = this.getText(localNode)) != null) {
                this.rollUpInfo = str2;
            }
            if ((str3 = this.getAttribute(localNode, "istracked")) != null) {
                this.isTracked = str3;
            }
            if ((str4 = this.getAttribute(localNode, "isrolledup")) != null) {
                this.isRolledUp = str4;
            }
            if ((str5 = this.getAttribute(localNode, "rollupmastery")) != null) {
                this.rollUpMastery = str5;
            }
            if ((str6 = this.getAttribute(localNode, "rolluptotaltime")) != null) {
                this.rollUpTotalTime = str6;
            }
            String str7 = this.getAttribute(localNode, "rollupscore");
            if (str3 == null) continue;
            this.rollUpScore = str7;
        }
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting Item::fillSequence() ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }
}

