/*
 * Decompiled with CFR 0.152.
 */
package org.adl.parsers.dom;

import java.io.File;
import java.io.FileWriter;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.adl.parsers.dom.ADLDOMParser;
import org.adl.parsers.dom.ADLManifest;
import org.adl.parsers.dom.ADLMetadata;
import org.adl.parsers.util.MessageClassification;
import org.adl.testsuite.metadata.MetaDataDOMParser;
import org.adl.testsuite.metadata.MetaDataTester;
import org.adl.testsuite.util.AuditorIndicator;
import org.adl.util.Message;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class CPDOMParser
extends ADLDOMParser {
    protected ADLManifest manifest = new ADLManifest();
    private boolean minimum = true;
    private boolean extensionsNotUsed = true;
    private int messageClass;
    private int messageType;
    private String messageText = "";
    private String messageLocation = "CPDOMParser::";
    private String messageTrace = "";
    private String tsPath = "";
    private String filePath = "";
    private String testType = "";
    private String tsParent = "";
    private String dateTime = "";

    public CPDOMParser() {
    }

    public CPDOMParser(boolean paramBoolean) {
        super(paramBoolean);
    }

    public boolean setControlDocs() {
        int i = 1;
        int j = MessageClassification.SYSTEM;
        int k = MessageType.FAILED;
        String str1 = "";
        String str2 = this.messageLocation + "setControlDocs()";
        String str3 = "";
        String str4 = "http://www.w3.org/2001/XMLSchema-instance";
        String str5 = "http://www.imsproject.org/xsd/imscp_rootv1p1p2";
        String str6 = "http://www.imsproject.org/xsd/imsmd_rootv1p2";
        String str7 = "http://www.adlnet.org/xsd/adl_cp_rootv1p1";
        NamedNodeMap localNamedNodeMap = this.rootNode.getAttributes();
        int m = localNamedNodeMap.getLength();
        for (int n = 0; n < m; ++n) {
            Attr localAttr = (Attr)localNamedNodeMap.item(n);
            String str8 = localAttr.getNodeName();
            if (!str8.equals("xsi:schemaLocation")) continue;
            try {
                localAttr.setNodeValue(str4 + " ..\\..\\..\\..\\..\\ims_xml.xsd " + str5 + " ..\\..\\..\\..\\..\\imscp_rootv1p1p2.xsd " + str6 + " ..\\..\\..\\..\\..\\imsmd_rootv1p2.xsd " + str7 + " ..\\..\\..\\..\\..\\adl_cp_rootv1p1.xsd");
                continue;
            }
            catch (DOMException localDOMException) {
                str1 = "Error in setting the value for xsi.schemaLocation.";
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                i = 0;
            }
        }
        return i > 0;
    }

    public boolean setControlDocsProperty() {
        int i = 1;
        int j = MessageClassification.SYSTEM;
        int k = MessageType.FAILED;
        String str1 = "";
        String str2 = this.messageLocation + "setControlDocsProperty()";
        String str3 = "";
        String str4 = "http://www.w3.org/2001/XMLSchema-instance";
        String str5 = "http://www.imsproject.org/xsd/imscp_rootv1p1p2";
        String str6 = "http://www.imsproject.org/xsd/imsmd_rootv1p2";
        String str7 = "http://www.adlnet.org/xsd/adl_cp_rootv1p1";
        try {
            this.setProperty("http://apache.org/xml/properties/external-schemaLocation", str4 + " ..\\..\\..\\..\\..\\ims_xml.xsd " + str5 + " ..\\..\\..\\..\\..\\imscp_rootv1p1p2.xsd " + str7 + " ..\\..\\..\\..\\..\\adl_cp_rootv1p1.xsd" + str6 + " ..\\..\\..\\..\\..\\imsmd_rootv1p2.xsd ");
        }
        catch (SAXNotRecognizedException localSAXNotRecognizedException) {
            str1 = "Error in setting parser property. SAX Not Recognized!";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
            i = 0;
        }
        catch (SAXNotSupportedException localSAXNotSupportedException) {
            str1 = "Error in setting parser property. SAX Not Supported!";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
            i = 0;
        }
        catch (SAXException localSAXException) {
            str1 = "Error in setting parser property.";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
            i = 0;
        }
        return i > 0;
    }

    @Override
    public void setTSPath(String paramString) {
        this.tsPath = paramString;
        StringTokenizer localStringTokenizer = new StringTokenizer(this.tsPath, "\\", false);
        int i = localStringTokenizer.countTokens();
        for (int j = 0; j < i - 1; ++j) {
            this.tsParent = this.tsParent + localStringTokenizer.nextToken() + "\\";
        }
        super.setTSPath(this.tsParent);
    }

    public void setTestType(String paramString) {
        this.testType = paramString;
    }

    public void setFilePath(String paramString) {
        this.filePath = paramString;
    }

    public void setDateTime(String paramString) {
        this.dateTime = paramString;
    }

    public boolean checkManifest(String paramString1, String paramString2) {
        String str1 = "";
        String str2 = this.messageLocation + "checkManifest(String)";
        String str3 = "";
        int i = MessageClassification.WELLFORMED;
        int j = MessageType.INFO;
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "Testing the manifest for Well-Formedness";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        boolean bool = this.parseFile(paramString1);
        if (bool && this.rootNode != null) {
            this.pruneTree(this.rootNode, true);
        }
        i = MessageClassification.VALID;
        j = MessageType.INFO;
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "Testing the manifest for validity against the controlling documents";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        if (this.wellFormed) {
            this.setValidationOn();
            bool = this.parseDocumentNode(this.document);
        } else {
            j = MessageType.FAILED;
            str1 = "The manifest is NOT valid!";
            this.messageHandler.addMessage(i, j, str1, str2, str3);
            this.valid = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("extensionfound: " + this.extensionFound);
        }
        if (this.valid) {
            this.fill();
            this.minimum = this.checkMinimum(paramString2) && this.minimum;
            this.extensionsNotUsed = !this.extensionFound;
        } else {
            this.extensionsNotUsed = !this.extensionFound;
            this.minimum = false;
        }
        return bool && this.wellFormed && this.valid && this.minimum;
    }

    public boolean checkMinimum(String paramString) {
        boolean bool = false;
        String str1 = "";
        String str2 = this.messageLocation + "checkMinimum()";
        String str3 = "";
        int i = MessageClassification.MINIMUM;
        int j = MessageType.INFO;
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "Testing the manifest for minimum conformance";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        str1 = "*****************************************";
        this.messageHandler.addMessage(i, j, str1, str2, str3);
        bool = this.manifest.checkConformance(paramString, this.baseDir);
        this.messageHandler.appendMessage(i, this.manifest.getMessage(i));
        return bool;
    }

    public boolean checkMetadata() {
        int i = 1;
        String str1 = "";
        String str2 = this.messageLocation + "checkMetadata()";
        String str3 = "";
        int j = MessageClassification.METADATA;
        int k = MessageType.OTHER;
        str1 = "";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        k = MessageType.OTHER;
        str1 = "=============== Meta-data Testing ==============";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        k = MessageType.OTHER;
        str1 = "Testing meta-data found within the package";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        k = MessageType.OTHER;
        str1 = "=============== Meta-data Testing ==============";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        k = MessageType.OTHER;
        str1 = "";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        Vector localVector = new Vector(10, 10);
        localVector = this.manifest.getMetadata();
        ADLMetadata localADLMetadata = null;
        String str4 = "";
        String str5 = "";
        String str6 = "";
        Node localNode1 = null;
        boolean bool = false;
        int m = localVector.size();
        if (DebugIndicator.ON) {
            System.out.println("Number of MD recs found: " + m);
        }
        for (int n = 0; n < m; ++n) {
            File localFile2;
            localADLMetadata = (ADLMetadata)localVector.elementAt(n);
            if (localADLMetadata == null) continue;
            str6 = localADLMetadata.getMetadataLocation();
            localNode1 = localADLMetadata.getMetadataRoot();
            if (localNode1 == null && str6.equalsIgnoreCase("")) continue;
            String str7 = "MD_" + n + "_Log.htm";
            str7 = this.tsPath + "Log_" + this.dateTime + "\\" + str7;
            File localFile1 = new File(str7);
            String str8 = localFile1.getParent();
            if (str8 != null && !(localFile2 = new File(str8)).exists()) {
                localFile2.mkdirs();
            }
            try {
                FileWriter localFileWriter = new FileWriter(localFile1);
                this.prepareMDFile(localFileWriter);
                k = MessageType.OTHER;
                str1 = "<br><br>***************************************************";
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.messageHandler.addMessage(j, k, str1, str2, str3, localFileWriter);
                k = MessageType.INFO;
                str1 = "Testing next meta-data file:";
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.messageHandler.addMessage(j, k, str1, str2, str3, localFileWriter);
                str1 = "---for parent element: " + localADLMetadata.getParentName();
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.messageHandler.addMessage(j, k, str1, str2, str3, localFileWriter);
                str1 = "---with ID: " + localADLMetadata.getParentID() + "<br><br>";
                this.messageHandler.addMessage(j, k, str1, str2, str3);
                this.messageHandler.addMessage(j, k, str1, str2, str3, localFileWriter);
                str4 = localADLMetadata.getMetadataType();
                str5 = localADLMetadata.getMetadataLocation();
                Node localNode2 = localADLMetadata.getMetadataRoot();
                boolean i1 = false;
                if (str5 != "") {
                    if (str5.length() > 6 && (str5.substring(0, 5).equals("http:") || str5.substring(0, 6).equals("https:"))) {
                        i1 = true;
                        if (DebugIndicator.ON) {
                            System.out.println("got external md");
                        }
                    }
                    if (this.testType.equals("pif") && !i1) {
                        str5 = this.tsPath + "PackageImport\\" + str5;
                    } else if (this.testType.equals("media") && !i1) {
                        str5 = this.filePath + str5;
                    }
                }
                if (DebugIndicator.ON) {
                    System.out.println("Meta-data record: " + n);
                    System.out.println("Meta-data type: " + str4);
                    System.out.println("Meta-data file: " + str5);
                }
                if (!(str5 == "" && localNode2 == null || (bool = this.startValidateTest(str4, str5, localNode2, localFileWriter)) || i != 1)) {
                    i = 0;
                }
                localFileWriter.write("</body>\n");
                localFileWriter.close();
            }
            catch (Exception localFileWriter) {
                // empty catch block
            }
            k = MessageType.OTHER;
            String str9 = this.replace(str7, "\\", "/");
            str1 = "<a href=\\\"" + str9 + "\\\" target=\\\"_blank\\\">Click here to view complete meta-data test log</a><br>";
            this.messageHandler.addMessage(j, k, str1, str2, str3);
        }
        this.minimum = i != 0 && this.minimum;
        return i > 0;
    }

    private void prepareMDFile(FileWriter paramFileWriter) {
        try {
            paramFileWriter.write("<head>\n");
            paramFileWriter.write("<meta http-equiv=\"expires\" content=\"Tue, 20 Aug 1999 01:00:00 GMT\">\n");
            paramFileWriter.write("<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
            paramFileWriter.write("<title>Meta-data Test Log</title>\n");
            paramFileWriter.write("</head>\n");
            paramFileWriter.write("<body>\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean startValidateTest(String paramString1, String paramString2, Node paramNode, FileWriter paramFileWriter) {
        boolean bool1 = true;
        boolean bool2 = true;
        boolean bool3 = true;
        boolean bool4 = false;
        int i = 1;
        String str2 = "";
        String str3 = this.messageLocation + "startValidateTest()";
        String str4 = "";
        int j = MessageClassification.METADATA;
        if (DebugIndicator.ON) {
            System.out.println("Beginning startValidateTest function");
        }
        if (paramString2 != "") {
            String str1 = this.makeReadyForPrint(paramString2);
            int k = MessageType.INFO;
            str2 = "Processing Meta-data: " + str1 + "<br>";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            if (DebugIndicator.ON) {
                System.out.println("Meta-data document being tested: " + paramString2);
            }
        }
        int k = MessageType.OTHER;
        str2 = "***************************************************";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        k = MessageType.INFO;
        str2 = "Meta-Data Test Conformance Summary";
        this.messageHandler.addMessage(j, k, str2, str3, str4);
        k = MessageType.OTHER;
        str2 = "***************************************";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        k = MessageType.INFO;
        str2 = "Checking Meta-data for Minimum Conformance";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        k = MessageType.INFO;
        str2 = "Checking Meta-data for well-formedness...";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        k = MessageType.OTHER;
        str2 = "***************************************";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        if (DebugIndicator.ON) {
            System.out.println("Checking Meta-data for well-formedness...");
        }
        MetaDataDOMParser localMetaDataTester = null;
        if (paramString2 != "") {
            localMetaDataTester = new MetaDataTester(paramString1, paramString2, this.tsParent);
        } else if (paramNode != null) {
            localMetaDataTester = new MetaDataTester(paramString1, paramNode, this.tsParent);
        }
        Message[] arrayOfMessage = localMetaDataTester.getMessages(false);
        if (arrayOfMessage.length > 0) {
            if (DebugIndicator.ON) {
                System.out.println("Meta-data has errors with well-formedness");
            }
            k = MessageType.FAILED;
            str2 = "Meta-data has errors with well-formedness";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            str2 = "The following errors were encountered:";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            this.reportMessages(arrayOfMessage, true, paramFileWriter);
        } else {
            k = MessageType.PASSED;
            str2 = "Meta-data is well-formed";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            if (DebugIndicator.ON) {
                System.out.println("Meta-data is well-formed");
            }
        }
        localMetaDataTester.clearMessages();
        boolean bool5 = false;
        if (DebugIndicator.ON) {
            System.out.println("metadataTester.isWellFormed() " + localMetaDataTester.isWellFormed());
        }
        if (localMetaDataTester.isWellFormed()) {
            k = MessageType.OTHER;
            str2 = "***************************************";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            k = MessageType.INFO;
            str2 = "Validating Meta-data against Schema...";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            k = MessageType.OTHER;
            str2 = "***************************************";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            if (DebugIndicator.ON) {
                System.out.println("Validating Meta-data against the Schema");
            }
            bool5 = paramNode == null ? localMetaDataTester.validate() : true;
        }
        if (bool5) {
            k = MessageType.PASSED;
            str2 = "Meta-data is valid against the Schema";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            localMetaDataTester.clearMessages();
            if (!paramString1.equalsIgnoreCase("package")) {
                k = MessageType.OTHER;
                str2 = "***************************************";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                k = MessageType.INFO;
                str2 = "Checking Meta-data for Mandatory Elements...";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                k = MessageType.OTHER;
                str2 = "***************************************";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("Checking the Meta-data for mandatory elements");
                }
                if (bool1 = ((MetaDataTester)localMetaDataTester).verifyMandatory()) {
                    arrayOfMessage = localMetaDataTester.getMessages(false);
                    this.reportMessages(arrayOfMessage, true, paramFileWriter);
                    k = MessageType.PASSED;
                    str2 = "Meta-data contains all mandatory elements";
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                } else {
                    bool1 = false;
                    arrayOfMessage = localMetaDataTester.getMessages(false);
                    this.reportMessages(arrayOfMessage, true, paramFileWriter);
                    k = MessageType.FAILED;
                    str2 = "Meta-data contains errors with mandatory elements";
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                }
                localMetaDataTester.clearMessages();
                k = MessageType.OTHER;
                str2 = "***************************************";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                k = MessageType.INFO;
                str2 = "Checking Meta-data for Optional Elements...";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                k = MessageType.OTHER;
                str2 = "***************************************";
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("Checking the Meta-data for optional elements");
                }
                bool2 = ((MetaDataTester)localMetaDataTester).verifyOptional();
                bool3 = ((MetaDataTester)localMetaDataTester).isOptionalNotUsed();
                if (bool3) {
                    k = MessageType.PASSED;
                    str2 = "Meta-data did not use optional elements";
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                } else if (bool2) {
                    arrayOfMessage = localMetaDataTester.getMessages(false);
                    this.reportMessages(arrayOfMessage, true, paramFileWriter);
                    k = MessageType.PASSED;
                    str2 = "Meta-data used optional elements correctly";
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                } else {
                    bool2 = false;
                    arrayOfMessage = localMetaDataTester.getMessages(false);
                    this.reportMessages(arrayOfMessage, true, paramFileWriter);
                    k = MessageType.FAILED;
                    str2 = "Meta-data has errors with optional elements";
                    this.messageHandler.addMessage(j, k, str2, str3, str4);
                    this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                }
                localMetaDataTester.clearMessages();
            }
            k = MessageType.OTHER;
            str2 = "***************************************";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            k = MessageType.INFO;
            str2 = "Checking Meta-data for Extension Elements...";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            k = MessageType.OTHER;
            str2 = "***************************************";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            bool4 = localMetaDataTester.isExtensionsUsed();
            if (DebugIndicator.ON) {
                System.out.println("extensionsUsed = " + bool4);
            }
            if (!bool4) {
                k = MessageType.PASSED;
                str2 = "Extension element(s) have not been used";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("Extension element(s) have not been used");
                }
            } else {
                k = MessageType.PASSED;
                str2 = "Extension element(s) have been used";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("Extension element(s) have been used");
                }
            }
        } else {
            bool1 = false;
            bool2 = false;
            arrayOfMessage = localMetaDataTester.getMessages(false);
            this.reportMessages(arrayOfMessage, true, paramFileWriter);
            k = MessageType.FAILED;
            str2 = "Meta-data is not valid against the Schema";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        }
        k = MessageType.OTHER;
        str2 = "*******************************************";
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        if (DebugIndicator.ON && !paramString1.equalsIgnoreCase("package")) {
            System.out.println("Mandatory = " + bool1);
            System.out.println("Optional = " + bool2);
            System.out.println("Extension = " + bool4);
        }
        if (!paramString1.equalsIgnoreCase("package")) {
            if (!bool3 && !bool2) {
                bool1 = false;
            }
            if (bool3) {
                bool2 = false;
            }
        }
        if (!paramString1.equalsIgnoreCase("package")) {
            if (bool1 && bool2 && bool4) {
                k = MessageType.CONFORMANT;
                str2 = "Meta-data is SCORM Version 1.2 MD-XML1 + Optional + Extensions Conformant<br>";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("Meta-data is SCORM Version 1.2 MD-XML1 + Optional Extensions Conformant");
                }
                i = 1;
            } else if (bool1 && bool2) {
                k = MessageType.CONFORMANT;
                str2 = "Meta-data is SCORM Version 1.2 MD-XML1 + Optional Conformant<br>";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("The Meta-data is SCORM Version 1.2 MD-XML1 + Optional Conformant");
                }
                i = 1;
            } else if (bool1 && bool4) {
                k = MessageType.CONFORMANT;
                str2 = "Meta-data is SCORM Version 1.2 MD-XML1 + Extensions Conformant<br>";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("The Meta-data is SCORM Version 1.2 MD-XML1 + Extensions Conformant");
                }
                i = 1;
            } else if (bool1) {
                k = MessageType.CONFORMANT;
                str2 = "Meta-data is SCORM Version 1.2 MD-XML1 Conformant<br>";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("The Meta-data is SCORM Version 1.2 MD-XML1 Conformant");
                }
                i = 1;
            } else {
                k = MessageType.TERMINATE;
                str2 = "The Meta-data is Non-Conformant<br>";
                this.messageHandler.addMessage(j, k, str2, str3, str4);
                this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
                if (DebugIndicator.ON) {
                    System.out.println("The Meta-data is Non-Conformant");
                }
                i = 0;
            }
        } else if (!bool5) {
            k = MessageType.TERMINATE;
            str2 = "The Meta-data is Non-Conformant<br>";
            this.messageHandler.addMessage(j, k, str2, str3, str4);
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            if (DebugIndicator.ON) {
                System.out.println("The Package Meta-data is Non-Conformant");
            }
            i = 0;
        }
        if (AuditorIndicator.OFF) {
            k = MessageType.OTHER;
            str2 = "";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
            k = MessageType.INFO;
            str2 = "Successful outcome of this test does not constitute ADL Certification unless the test was conducted by an ADL Accredited Auditor.";
            this.messageHandler.addMessage(j, k, str2, str3, str4, paramFileWriter);
        }
        return i > 0;
    }

    private void reportMessages(Message[] paramArrayOfMessage, boolean paramBoolean, FileWriter paramFileWriter) {
        String localObject = "";
        String str1 = this.messageLocation + "startValidateTest()";
        String str2 = "";
        int i = MessageClassification.METADATA;
        for (int k = 0; k < paramArrayOfMessage.length; ++k) {
            int j;
            int m = paramArrayOfMessage[k].getMessageType();
            String str3 = paramArrayOfMessage[k].getMessageText();
            str3 = this.makeReadyForPrint(str3);
            this.messageHandler.logMessage(m, str3, paramFileWriter);
            if (m == MessageType.FAILED && !paramBoolean) {
                j = MessageType.FAILED;
                localObject = str3;
                this.messageHandler.addMessage(i, j, localObject, str1, str2);
                continue;
            }
            if (m == MessageType.INFO && !paramBoolean) {
                j = MessageType.INFO;
                localObject = str3;
                this.messageHandler.addMessage(i, j, localObject, str1, str2);
                continue;
            }
            if (m == MessageType.WARNING && !paramBoolean) {
                j = MessageType.WARNING;
                localObject = str3;
                this.messageHandler.addMessage(i, j, localObject, str1, str2);
                continue;
            }
            if (m == MessageType.PASSED && !paramBoolean) {
                j = MessageType.PASSED;
                localObject = str3;
                this.messageHandler.addMessage(i, j, localObject, str1, str2);
                continue;
            }
            if (paramBoolean) continue;
            j = MessageType.OTHER;
            localObject = str3;
            this.messageHandler.addMessage(i, j, localObject, str1, str2);
        }
    }

    private String makeReadyForPrint(String paramString) {
        String str = this.replace(paramString, "&", "&amp;");
        str = this.replace(str, "\"", "&quot;");
        str = this.replace(str, "<", "&lt;");
        str = this.replace(str, ">", "&gt;");
        str = this.replace(str, "[", "&#91;");
        str = this.replace(str, "]", "&#93;");
        str = this.replace(str, "'", "&#39;");
        str = this.replace(str, "\\", "\\\\");
        return str;
    }

    private String replace(String paramString1, String paramString2, String paramString3) {
        int i = 0;
        int j = paramString1.length();
        int k = -1;
        while ((k = paramString1.indexOf(paramString2, i)) != -1) {
            String str = paramString1.substring(0, k);
            str = str + paramString3;
            paramString1 = str = str + paramString1.substring(k + paramString2.length());
            i = k + paramString3.length();
        }
        return paramString1;
    }

    public boolean checkSCO() {
        int i = 0;
        String str1 = "";
        String str2 = this.messageLocation + "checkSCO()";
        String str3 = "";
        int j = MessageClassification.MINIMUM;
        int k = MessageType.INFO;
        str1 = "*****************************************";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        str1 = "Testing the manifest for SCO RTE conformance";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        str1 = "*****************************************";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        k = MessageType.FAILED;
        str1 = "SCO RTE conformance test is not yet implemented!!!";
        this.messageHandler.addMessage(j, k, str1, str2, str3);
        this.minimum = i != 0 && this.minimum;
        return i > 0;
    }

    public boolean isMinimum() {
        return this.minimum;
    }

    public boolean isExtention() {
        if (DebugIndicator.ON) {
            System.out.println("extensionsNotUsed: " + this.extensionsNotUsed);
        }
        return !this.extensionsNotUsed;
    }

    public Vector getItemList() {
        String str = this.messageLocation + "getItemList()";
        if (DebugIndicator.ON) {
            System.out.println("*******    " + str + "  **************");
            System.out.println("*******    returning...         **************");
        }
        return this.manifest.getItemList();
    }

    public boolean fill() {
        String str = this.messageLocation + "fill()";
        if (DebugIndicator.ON) {
            System.out.println("******  " + str + "  *********");
        }
        boolean bool = false;
        bool = this.manifest.fillManifest(this.rootNode);
        if (DebugIndicator.ON) {
            System.out.println("*** Exiting " + str + " ***");
            System.out.println("*** Returning: " + bool);
        }
        return bool;
    }

    public Vector getLaunchLines() {
        URLDecoder localURLDecoder = new URLDecoder();
        HashSet localHashSet = this.manifest.getLaunchLines();
        Vector<String> localVector = new Vector<String>();
        Iterator localIterator = localHashSet.iterator();
        String localObject = new String("");
        while (localIterator.hasNext()) {
            String str;
            localObject = (String)localIterator.next();
            localObject = str = this.replace(localObject, "\\", "/");
            localVector.add(localObject);
        }
        return localVector;
    }
}

