/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.adl.util.Message;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetaDataDOMParser
implements ErrorHandler {
    protected Vector messages;
    protected String fileName;
    protected DOMParser parser;
    protected Document document;
    protected Node metadataNode;
    private static final int parserMessageCeiling = 50;
    private boolean warningNotCaught = true;
    private boolean errorNotCaught = true;
    private boolean fatalErrorNotCaught = true;
    private boolean wellFormed;
    private String mySchemaLocation = "";
    private boolean extensionsUsed = false;
    private static String MDNamespace = "http://www.imsglobal.org/xsd/imsmd_rootv1p2p1";
    private static String XMLNamespace = "http://www.w3.org/XML/1998/namespace";
    private static String nsNamespace = "http://www.w3.org/2000/xmlns/";
    private static String xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance";

    public MetaDataDOMParser(String paramString1, String paramString2) {
        if (DebugIndicator.ON) {
            System.out.println("\n\n*****  In MetaDataDOMParser( file )  ******\n");
        }
        this.messages = new Vector(0, 100);
        this.fileName = this.searchFile(paramString1, "xml");
        this.parser = null;
        this.document = null;
        this.wellFormed = this.preProcess();
    }

    public MetaDataDOMParser(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("\n\n*****  In MetaDataDOMParser( node )  ******\n");
        }
        this.messages = new Vector(0, 100);
        this.parser = null;
        this.wellFormed = true;
    }

    public String getXMLFileName() {
        if (DebugIndicator.ON) {
            System.out.println("Entering MetaDataDOMParser::getXMLFileName()");
        }
        if (this.fileName != null) {
            return this.fileName;
        }
        return new String("");
    }

    public boolean preProcess() {
        int i = 1;
        if (DebugIndicator.ON) {
            System.out.println("Entering MetaDataDOMParser::preProcess()");
        }
        if (this.parser == null) {
            this.createParser();
        }
        if (this.parser != null) {
            try {
                this.parser.setFeature("http://xml.org/sax/features/validation", false);
                int j = this.messages.size();
                if (this.fileName != null) {
                    InputSource localInputSource = this.setUpInputSource(this.fileName);
                    this.parser.parse(localInputSource);
                    if (DebugIndicator.ON) {
                        System.out.println("Non-validated Document parsing complete.");
                    }
                }
                if (this.messages.size() == j) {
                    this.document = this.parser.getDocument();
                }
            }
            catch (SAXException localSAXException) {
                this.setMessage(MessageType.FAILED, "MetaDataDOMParser::preProcess()", "Parser threw a SAXException.");
                i = 0;
            }
            catch (IOException localIOException) {
                this.setMessage(MessageType.FAILED, "MetaDataDOMParser::preProcess()", "Parser threw a IOException.");
                i = 0;
            }
        } else {
            i = 0;
            if (DebugIndicator.ON) {
                System.out.println("Parser must equal null");
            }
        }
        if (i != 0 && this.document != null) {
            try {
                Element localElement = this.document.getDocumentElement();
                this.pruneTree(localElement);
            }
            catch (NullPointerException localNullPointerException) {
                this.setMessage(MessageType.FAILED, "MetaDataDOMParser::preProcess()", "There was a problem parsing the XML with validation off");
                i = 0;
            }
            if (DebugIndicator.ON) {
                System.out.println("###   Pre-processing is complete!!  ###");
            }
        } else {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::preProcess()", "There was a problem parsing the XML with validation off");
            i = 0;
        }
        if (DebugIndicator.ON) {
            System.out.println("Exiting MetaDataDOMParser::preProcess()");
        }
        return i > 0;
    }

    public boolean validate() {
        InputSource localInputSource;
        int i = 0;
        boolean j = false;
        if (DebugIndicator.ON && DebugIndicator.ON) {
            System.out.println("Entering MetaDataDOMParser::validate()");
        }
        if (this.parser == null) {
            this.preProcess();
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (SAXException localSAXException1) {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::validate()", "Parser threw a SAXException - could not reset validation.");
        }
        try {
            ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat localOutputFormat = new OutputFormat(this.document);
            localOutputFormat.setIndenting(false);
            XMLSerializer localXMLSerializer = new XMLSerializer((OutputStream)localByteArrayOutputStream, localOutputFormat);
            localXMLSerializer.asDOMSerializer();
            localXMLSerializer.serialize(this.document.getDocumentElement());
            ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(localByteArrayOutputStream.toByteArray());
            localInputSource = new InputSource(localByteArrayInputStream);
            j = true;
        }
        catch (FileNotFoundException localFileNotFoundException) {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::validate()", "FileNotFoundException caught");
            localInputSource = new InputSource();
        }
        catch (IOException localIOException1) {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::validate()", "IOException caught: could not serialize");
            localInputSource = new InputSource();
        }
        if (this.parser != null && this.wellFormed && j) {
            boolean k;
            try {
                this.parser.parse(localInputSource);
            }
            catch (SAXException localSAXException2) {
                this.setMessage(MessageType.FAILED, "MetaDataDOMParser::validate()", "SAXException thrown: could not parse");
            }
            catch (IOException localIOException2) {
                this.setMessage(MessageType.FAILED, "MetaDataDOMParser::validate()", "IOException thrown: could not parse");
            }
            boolean bl = k = this.errorNotCaught && this.warningNotCaught && this.fatalErrorNotCaught;
            if (k) {
                this.document = (DocumentImpl)this.parser.getDocument();
                i = 1;
            } else {
                i = 0;
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("Exiting MetaDataDOMParser::validate()");
        }
        return i > 0;
    }

    public int getNumMessages() {
        return this.messages.size();
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public Message[] getMessages(boolean paramBoolean) {
        Message[] arrayOfMessage = new Message[this.messages.size()];
        for (int i = 0; i < this.messages.size(); ++i) {
            arrayOfMessage[i] = (Message)this.messages.elementAt(i);
        }
        if (paramBoolean) {
            this.clearMessages();
        }
        return arrayOfMessage;
    }

    public void appendMessages(Collection paramCollection) {
        this.messages.addAll(paramCollection);
    }

    public void setMessage(int paramInt, String paramString1, String paramString2) {
        Message localMessage = new Message(paramInt, paramString2, paramString1);
        this.messages.add(localMessage);
        if (DebugIndicator.ON) {
            System.out.println(localMessage.toString());
        }
    }

    @Override
    public void warning(SAXParseException paramSAXParseException) {
        this.warningNotCaught = false;
        if (this.messages.size() < 50) {
            this.setMessage(MessageType.WARNING, "XMLDocTester::warning()", "Parser warning on line " + paramSAXParseException.getLineNumber() + ":  " + paramSAXParseException.getMessage());
        } else if (this.messages.size() == 50) {
            this.setMessage(MessageType.INFO, "", "Message limit reached.  Additional parser messages will not be logged.");
        }
    }

    @Override
    public void error(SAXParseException paramSAXParseException) {
        this.errorNotCaught = false;
        if (this.messages.size() < 50) {
            this.setMessage(MessageType.FAILED, "XMLDocTester::error()", "Parser error on line " + paramSAXParseException.getLineNumber() + ":  " + paramSAXParseException.getMessage());
        } else if (this.messages.size() == 50) {
            this.setMessage(MessageType.INFO, "", "Message limit reached.  Additional parser messages will not be logged.");
        }
    }

    @Override
    public void fatalError(SAXParseException paramSAXParseException) {
        this.fatalErrorNotCaught = false;
        if (this.messages.size() < 50) {
            this.setMessage(MessageType.FAILED, "XMLDocTester::fatalError()", "Parser fatal error on line " + paramSAXParseException.getLineNumber() + ":  " + paramSAXParseException.getMessage());
        } else if (this.messages.size() == 50) {
            this.setMessage(MessageType.INFO, "", "Message limit reached.  Additional parser messages will not be logged.");
        }
    }

    protected boolean createParser() {
        int i;
        try {
            this.parser = new DOMParser();
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            this.parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            this.parser.setErrorHandler((ErrorHandler)this);
            i = 1;
        }
        catch (SAXException localSAXException) {
            this.parser = null;
            i = 0;
            this.setMessage(MessageType.FAILED, "XMLDocTester::CreateParser()", "Error in setting parser feature.  Parser not created.");
        }
        return i > 0;
    }

    protected void pruneTree(Node paramNode) {
        if (paramNode == null) {
            return;
        }
        short i = paramNode.getNodeType();
        block0 : switch (i) {
            case 7: {
                if (!DebugIndicator.ON) break;
                this.printNodeInfo("PROCESSING_INSTRUCTION_NODE", ((Document)paramNode).getDocumentElement());
                break;
            }
            case 9: {
                if (DebugIndicator.ON) {
                    this.printNodeInfo("DOCUMENT_NODE", ((Document)paramNode).getDocumentElement());
                }
                this.pruneTree(((Document)paramNode).getDocumentElement());
                break;
            }
            case 1: {
                int n;
                String str3;
                if (DebugIndicator.ON) {
                    this.printNodeInfo("ELEMENT_NODE", paramNode);
                }
                Object localObject = paramNode.getLocalName();
                NamedNodeMap localNamedNodeMap = paramNode.getAttributes();
                int k = localNamedNodeMap.getLength();
                for (int m = 0; m < k; ++m) {
                    Attr localAttr = (Attr)localNamedNodeMap.item(m);
                    if (DebugIndicator.ON) {
                        this.printNodeInfo("ATTRIBUTE_NODE", localAttr);
                    }
                    String str2 = localAttr.getNamespaceURI();
                    str3 = localAttr.getNodeName();
                    if (str2 == null || str2.equals(MDNamespace) || str2.equals(XMLNamespace) || str2.equals(nsNamespace) || str2.equals(xsiNamespace)) continue;
                    System.out.println("Just tossed an extension attribute");
                    System.out.println("Name: " + localAttr.getNodeName());
                    System.out.println("attr ns: " + str2);
                    this.extensionsUsed = true;
                    paramNode.removeChild(localAttr);
                }
                NodeList localNodeList = paramNode.getChildNodes();
                if (localNodeList == null) break;
                for (n = 0; n < localNodeList.getLength(); ++n) {
                    str3 = localNodeList.item(n).getNamespaceURI();
                    if (!(str3 == null || str3.equals(MDNamespace) || str3.equals(XMLNamespace) || str3.equals(nsNamespace) || str3.equals(xsiNamespace))) {
                        if (DebugIndicator.ON) {
                            System.out.println("Just tossed a child element");
                            System.out.println("Name: " + localNodeList.item(n).getNodeName());
                            System.out.println("child ns: " + str3);
                        }
                        this.extensionsUsed = true;
                        paramNode.removeChild(localNodeList.item(n));
                        continue;
                    }
                    if (localNodeList.item(n) instanceof TextImpl) {
                        String str1 = new String(localNodeList.item(n).getNodeValue().trim());
                        if (((TextImpl)localNodeList.item(n)).isIgnorableWhitespace()) {
                            paramNode.removeChild(localNodeList.item(n));
                            --n;
                            continue;
                        }
                        if (str1.length() != 0) continue;
                        paramNode.removeChild(localNodeList.item(n));
                        --n;
                        continue;
                    }
                    if (localNodeList.item(n).getNodeType() != 8) continue;
                    paramNode.removeChild(localNodeList.item(n));
                    --n;
                }
                n = localNodeList.getLength();
                block7: for (int i1 = 0; i1 < n; ++i1) {
                    this.pruneTree(localNodeList.item(i1));
                    if (DebugIndicator.ON) {
                        this.printNodeInfo("ENTITY_REFERENCE_NODE", paramNode);
                    }
                    if ((localObject = paramNode.getChildNodes()) == null) break block0;
                    int j = ((NodeList)localObject).getLength();
                    for (k = 0; k < j; ++k) {
                        this.pruneTree(((NodeList)localObject).item(k));
                        if (!DebugIndicator.ON) continue block7;
                        this.printNodeInfo("COMMENT_NODE", paramNode);
                        if (!DebugIndicator.ON) continue block7;
                        this.printNodeInfo("CDATA_SECTION_NODE", paramNode);
                        if (paramNode instanceof TextImpl) {
                            if (((TextImpl)paramNode).isIgnorableWhitespace()) {
                                if (!DebugIndicator.ON) continue block7;
                                this.printNodeInfo("TEXT_NODE (TextImpl:Ignorable Whitespace)", paramNode);
                                continue;
                            }
                            if (!DebugIndicator.ON) continue block7;
                            this.printNodeInfo("TEXT_NODE (TextImpl:Element Data)", paramNode);
                            continue;
                        }
                        if (!DebugIndicator.ON) continue block7;
                        this.printNodeInfo("TEXT_NODE", paramNode);
                    }
                }
                break;
            }
        }
    }

    protected void printNodeInfo(String paramString, Node paramNode) {
        StringBuffer localStringBuffer1 = new StringBuffer("(null)");
        StringBuffer localStringBuffer2 = new StringBuffer("(null)");
        StringBuffer localStringBuffer3 = new StringBuffer("(null)");
        StringBuffer localStringBuffer4 = new StringBuffer("(null)");
        String str = new String(" -- ");
        if (paramNode != null) {
            if (paramString != null) {
                localStringBuffer1 = new StringBuffer(paramString);
            }
            localStringBuffer2 = new StringBuffer(new Integer(paramNode.getNodeType()).toString());
            if (paramNode.getNodeName() != null) {
                localStringBuffer3 = new StringBuffer(paramNode.getNodeName());
            }
            if (paramNode.getNodeValue() != null) {
                localStringBuffer4 = new StringBuffer(paramNode.getNodeValue());
            }
        }
        while (localStringBuffer1.length() < 42) {
            localStringBuffer1.append(" ");
        }
        while (localStringBuffer3.length() < 15) {
            localStringBuffer3.append(" ");
        }
        while (localStringBuffer4.length() < 10) {
            localStringBuffer4.append(" ");
        }
        if (DebugIndicator.ON) {
            System.out.println(localStringBuffer1 + str + localStringBuffer2 + str + localStringBuffer3 + str + localStringBuffer4);
        }
    }

    private InputSource setUpInputSource(String paramString) {
        InputSource localInputSource = new InputSource();
        localInputSource = this.setupFileSource(paramString);
        return localInputSource;
    }

    private InputSource setupFileSource(String paramString) {
        try {
            File localFile = new File(paramString);
            if (DebugIndicator.ON) {
                System.out.println(localFile.getAbsolutePath());
            }
            if (localFile.isFile()) {
                FileReader localObject1 = new FileReader(localFile);
                InputSource localObject2 = new InputSource(localObject1);
                return localObject2;
            }
            if (paramString.length() > 6 && (paramString.substring(0, 5).equals("http:") || paramString.substring(0, 6).equals("https:"))) {
                URL localObject1 = new URL(paramString);
                InputStream localObject2 = localObject1.openStream();
                InputSource localInputSource = new InputSource(localObject2);
                return localInputSource;
            }
            System.out.println("XML File: " + paramString + " is not a file or URL");
        }
        catch (NullPointerException localNullPointerException) {
            System.out.println("Null pointer exception" + localNullPointerException);
        }
        catch (SecurityException localSecurityException) {
            System.out.println("Security Exception" + localSecurityException);
        }
        catch (FileNotFoundException localFileNotFoundException) {
            System.out.println("File Not Found Exception" + localFileNotFoundException);
        }
        catch (Exception localException) {
            System.out.println("General Exception" + localException);
        }
        return new InputSource();
    }

    private MetaDataDOMParser() {
    }

    private String searchFile(String paramString1, String paramString2) {
        boolean i = false;
        String str = new String("");
        try {
            if (paramString1.length() > 6 && (paramString1.substring(0, 5).equals("http:") || paramString1.substring(0, 6).equals("https:"))) {
                str = paramString1;
            } else {
                File localFile = new File(paramString1);
                if (localFile.isFile()) {
                    i = true;
                    str = localFile.getAbsolutePath();
                    if (DebugIndicator.ON) {
                        System.out.println(str + " was found!!");
                    }
                } else {
                    this.setMessage(MessageType.FAILED, "MetaDataDOMParser::searchFile()", paramString2 + " File Not A Normal File.  Verify the" + " specified " + paramString2 + " file, " + paramString1 + ", exists.");
                }
            }
        }
        catch (NullPointerException localNullPointerException) {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::searchFile()", "Empty " + paramString2 + " Filename Specified.");
        }
        catch (SecurityException localSecurityException) {
            this.setMessage(MessageType.FAILED, "MetaDataDOMParser::searchFile()", paramString2 + " File Not Accessible.");
        }
        return str;
    }

    public boolean isWellFormed() {
        return this.wellFormed;
    }

    public boolean isExtensionsUsed() {
        return this.extensionsUsed;
    }
}

