/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata;

import java.util.Collection;
import java.util.Vector;
import org.adl.util.Message;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataUtil {
    protected Vector messages = new Vector(0, 5);
    private boolean notBest = false;
    private String valueOfType = "";
    private boolean typeNotUsed = true;
    private boolean validTypeValue = true;
    private boolean typeAndNameResult = true;
    private int taxonCount = 0;

    public int getMultiplicityUsed(Node paramNode, String paramString) {
        NodeList localNodeList = paramNode.getChildNodes();
        int i = 0;
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            String str;
            if (localNodeList.item(j).getNodeType() != 1 || !(str = localNodeList.item(j).getLocalName()).equalsIgnoreCase(paramString)) continue;
            ++i;
        }
        return i;
    }

    public int getTaxonMultiplicityUsed(Node paramNode, String paramString) {
        NodeList localNodeList = paramNode.getChildNodes();
        for (int i = 0; i < localNodeList.getLength(); ++i) {
            String str;
            if (localNodeList.item(i).getNodeType() != 1 || !(str = localNodeList.item(i).getLocalName()).equalsIgnoreCase(paramString)) continue;
            ++this.taxonCount;
            this.getTaxonMultiplicityUsed(localNodeList.item(i), paramString);
        }
        return this.taxonCount;
    }

    public boolean allContainAttributes(Vector paramVector) {
        boolean bool = false;
        String str = new String();
        Vector localVector = new Vector();
        int i = 0;
        if (DebugIndicator.ON) {
            System.out.println("MetadataUtil::allContainAttributes()Testing for required xml:lang attribute in  in multiple <langstring> occurrences");
        }
        for (int j = 0; j < paramVector.size(); ++j) {
            Node localNode = (Node)paramVector.elementAt(j);
            if (localNode.getNodeType() != 1) continue;
            NamedNodeMap localNamedNodeMap = localNode.getAttributes();
            int k = localNamedNodeMap.getLength();
            for (int m = 0; m < k; ++m) {
                Attr localAttr = (Attr)localNamedNodeMap.item(m);
                str = localAttr.getLocalName();
                if (!str.equalsIgnoreCase("lang")) continue;
                ++i;
            }
        }
        if (i == paramVector.size()) {
            bool = true;
        }
        if (DebugIndicator.ON) {
            System.out.println("Returning " + bool + " from allContainAttributes()");
        }
        return bool;
    }

    public boolean verifyLangAttributes(Vector paramVector) {
        int k;
        int i = 1;
        boolean j = false;
        String str1 = new String();
        String str2 = new String();
        String str3 = new String();
        Vector<String> localVector = new Vector<String>();
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyLangAttributes()", "Testing xml:lang value for element <langstring>...");
        for (k = 0; k < paramVector.size(); ++k) {
            Node localNode = (Node)paramVector.elementAt(k);
            if (localNode.getNodeType() != 1) continue;
            NamedNodeMap localNamedNodeMap = localNode.getAttributes();
            int i1 = localNamedNodeMap.getLength();
            for (int i2 = 0; i2 < i1; ++i2) {
                Attr localAttr = (Attr)localNamedNodeMap.item(i2);
                str3 = localAttr.getLocalName();
                if (!str3.equalsIgnoreCase("lang")) continue;
                String str4 = localAttr.getValue();
                localVector.add(str4);
            }
        }
        if (!localVector.isEmpty()) {
            j = true;
            k = localVector.size();
            for (int m = 0; m < k - 1; ++m) {
                for (int n = m + 1; n < k; ++n) {
                    str1 = (String)localVector.elementAt(m);
                    if (!str1.equals(str2 = (String)localVector.elementAt(n))) continue;
                    i = 0;
                }
            }
        }
        if (!j) {
            this.setMessage(MessageType.INFO, "MetadataUtil::verifyLangAttribute()", "<langstring> element did not contain the optional xml:lang attribute");
        }
        return i > 0;
    }

    public boolean verifyLangstring(Node paramNode, String paramString1, String paramString2, int paramInt) {
        int n;
        int m;
        boolean i = true;
        boolean bool1 = false;
        boolean bool2 = true;
        boolean j = false;
        int k = paramInt;
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyLangstring()", "Testing element " + paramString2 + " " + paramString1 + " for element <langstring>...");
        String str1 = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str2 = new String();
        Vector<Node> localVector = new Vector<Node>();
        for (m = 0; m < localNodeList.getLength(); ++m) {
            localNode = localNodeList.item(m);
            n = this.getMultiplicityUsed(paramNode, "langstring");
            if (localNode.getNodeType() != 1 || !(str2 = localNode.getLocalName()).equalsIgnoreCase("langstring")) continue;
            if (!j) {
                this.setMessage(MessageType.INFO, "MetadataUtil::verifyLangstring()", "Testing element <langstring> for multiplicity...");
                if (n > 10) {
                    this.setMessage(MessageType.WARNING, "MetadataUtil::verifyLangstring()", "More than 10 <langstring> elements  were found ");
                } else {
                    this.setMessage(MessageType.PASSED, "MetadataUtil::verifyLangstring()", "10 or less <langstring> elements  were found ");
                }
                j = true;
            }
            localVector.add(localNode);
        }
        if (!localVector.isEmpty() && (m = localVector.size()) > 1) {
            bool1 = this.allContainAttributes(localVector);
            if (bool1) {
                bool2 = this.verifyLangAttributes(localVector);
                if (!bool2) {
                    this.setMessage(MessageType.FAILED, "MetadataUtil::verifyLangstring()", "Multiple <langstring> elements are required to contain a different xml:lang attribute values");
                    i = false;
                } else {
                    this.setMessage(MessageType.PASSED, "MetadataUtil::verifyLangstring()", "Multiple <langstring> elements contained different xml:lang attribute values");
                }
            } else {
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyLangstring()", "Multiple <langstring> elements are required to contain the xml:lang attribute");
                i = false;
            }
        }
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyLangstring()", "Testing text of element <langstring> for character length...");
        m = 0;
        for (n = 0; n < localVector.size(); ++n) {
            int i1;
            m = 0;
            localNode = (Node)localVector.elementAt(n);
            localNodeList = localNode.getChildNodes();
            if (localNodeList == null) continue;
            for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                localNode = localNodeList.item(i1);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++m;
            }
            if (m == 0) {
                i = false;
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyLangstring()", "No data was found in element " + paramString1 + " and fails the minimum " + "character length test");
                continue;
            }
            if (m == 1) {
                for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                    localNode = localNodeList.item(i1);
                    if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                    str1 = this.getTaggedData((Node)localVector.elementAt(n));
                    if (DebugIndicator.ON) {
                        System.out.println("1<= " + str1.length() + " <= " + k);
                    }
                    if (str1.length() > k) {
                        this.setMessage(MessageType.WARNING, "MetadataUtil::verifyLangstring()", "The text contained in element <langstring> is greater than " + k);
                        continue;
                    }
                    if (str1.length() < 1) {
                        i = false;
                        this.setMessage(MessageType.FAILED, "MetadataUtil::verifyLangstring()", "No text was found in element <langstring> and fails the minimum character length test");
                        continue;
                    }
                    this.setMessage(MessageType.PASSED, "MetadataUtil::verifyLangstring()", "Character length for element <langstring> has been verified");
                }
            }
            i = false;
            if (DebugIndicator.ON) {
                System.out.println("There were " + m + " TEXT_NODE elements found");
            }
            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyLangstring()", "Too many text strings were found in <langstring> and fails the test");
            i = false;
        }
        return i && j && bool2;
    }

    public boolean vocabLangAttributeExist(Vector paramVector) {
        int i = 1;
        String str1 = new String();
        this.setMessage(MessageType.INFO, "MetadataUtil::vocabLangAttributeExist()", "Testing xml:lang value...");
        for (int j = 0; j < paramVector.size(); ++j) {
            Node localNode = (Node)paramVector.elementAt(j);
            if (localNode.getNodeType() != 1) continue;
            NamedNodeMap localNamedNodeMap = localNode.getAttributes();
            int k = localNamedNodeMap.getLength();
            for (int m = 0; m < k; ++m) {
                Attr localAttr = (Attr)localNamedNodeMap.item(m);
                str1 = localAttr.getLocalName();
                if (!str1.equalsIgnoreCase("lang")) continue;
                String str2 = localAttr.getValue();
                if (str2.equals("x-none")) {
                    this.setMessage(MessageType.PASSED, "MetadataUtil::vocabLangAttributeExist()", "<langstring> attribute value 'x-none'  existed");
                    continue;
                }
                this.setMessage(MessageType.FAILED, "MetadataUtil::vocabLangAttributeExist()", "<langstring> attribute value did not equal 'x-none' ");
                i = 0;
            }
        }
        return i > 0;
    }

    public boolean verifyRestrictedLang(Node paramNode, String paramString, Vector paramVector) {
        int n;
        int m;
        int i = 1;
        boolean bool1 = false;
        boolean bool2 = true;
        boolean j = false;
        boolean k = false;
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyRestrictedLang()", "Testing element <" + paramString + "> for element" + " <langstring>...");
        String str1 = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str2 = new String();
        Vector<Node> localVector = new Vector<Node>();
        for (m = 0; m < localNodeList.getLength(); ++m) {
            localNode = localNodeList.item(m);
            n = this.getMultiplicityUsed(paramNode, "langstring");
            if (localNode.getNodeType() != 1 || !(str2 = localNode.getLocalName()).equalsIgnoreCase("langstring")) continue;
            if (!j) {
                this.setMessage(MessageType.INFO, "MetadataUtil::verifyRestrictedLang()", "Testing element <langstring> for multiplicity...");
                this.setMessage(MessageType.PASSED, "MetadataUtil::verifyRestrictedLang()", "1 and only 1 <langstring> element was found");
                j = true;
            }
            localVector.add(localNode);
        }
        if (!localVector.isEmpty()) {
            bool1 = this.allContainAttributes(localVector);
            if (bool1) {
                bool2 = this.vocabLangAttributeExist(localVector);
                if (!bool2) {
                    this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "<langstring> element in vocabulary type is required to contain the xml:lang attribute with value 'x-none'");
                    i = 0;
                }
            } else {
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "<langstring> element in vocabulary type is required to contain the xml:lang attribute with value 'x-none'");
                i = 0;
            }
        }
        for (m = 0; m < localVector.size(); ++m) {
            int i1;
            n = 0;
            localNode = (Node)localVector.elementAt(m);
            localNodeList = localNode.getChildNodes();
            if (localNodeList == null) continue;
            for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                localNode = localNodeList.item(i1);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++n;
            }
            if (n == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "No data was found in element <" + paramString + "> and fails the minimum character length " + "test");
                continue;
            }
            if (n == 1) {
                for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                    localNode = localNodeList.item(i1);
                    if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                    str1 = this.getTaggedData((Node)localVector.elementAt(m));
                    if (paramString.equalsIgnoreCase("source")) {
                        this.setMessage(MessageType.INFO, "MetadataUtil::verifyRestrictedLang()", "Testing the value of <source>");
                        if (!str1.equals("LOMv1.0")) {
                            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "<source> value found - '" + str1 + "' ");
                            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "Must equal 'LOMv1.0' for Restricted Vocabulary");
                            i = 0;
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "MetadataUtil::verifyRestrictedLang()", "<source> value equals 'LOMv1.0'");
                        continue;
                    }
                    if (!paramString.equalsIgnoreCase("value")) continue;
                    for (int i2 = 0; i2 < paramVector.size(); ++i2) {
                        String str3 = (String)paramVector.elementAt(i2);
                        if (!str1.equals(str3)) continue;
                        k = true;
                    }
                    this.setMessage(MessageType.INFO, "MetadataUtil::verifyRestrictedLang()", "Testing the value of <value>");
                    if (!k) {
                        this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "Found '" + str1 + "' " + "- Not a valid Restricted Vocabulary token");
                        i = 0;
                        continue;
                    }
                    this.setMessage(MessageType.PASSED, "MetadataUtil::verifyRestrictedLang()", "Found '" + str1 + "' " + "- A valid Restricted Vocabulary token");
                }
            }
            i = 0;
            if (DebugIndicator.ON) {
                System.out.println("There were " + n + " TEXT_NODE elements found");
            }
            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyRestrictedLang()", "Too many text strings were found in <langstring> and fails the test");
            i = 0;
        }
        return i > 0;
    }

    public boolean verifyBestPracticeLang(Node paramNode, String paramString1, String paramString2, Vector paramVector) {
        int i1;
        int n;
        int i = 1;
        boolean bool1 = false;
        boolean bool2 = true;
        boolean j = false;
        boolean k = false;
        int m = 1000;
        if (DebugIndicator.ON) {
            System.out.println("The VALUE OF typeAndNameResult is " + this.typeAndNameResult);
        }
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyBestPracticeLang()", "Testing element <" + paramString2 + "> for element" + " <langstring>...");
        String str1 = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str2 = new String();
        Vector<Node> localVector = new Vector<Node>();
        for (n = 0; n < localNodeList.getLength(); ++n) {
            localNode = localNodeList.item(n);
            i1 = this.getMultiplicityUsed(paramNode, "langstring");
            if (localNode.getNodeType() != 1 || !(str2 = localNode.getLocalName()).equalsIgnoreCase("langstring")) continue;
            if (!j) {
                this.setMessage(MessageType.INFO, "MetadataUtil::verifyBestPracticeLang()", "Testing element <langstring> for multiplicity...");
                this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "1 and only 1 <langstring> element was found");
                j = true;
            }
            localVector.add(localNode);
        }
        if (!localVector.isEmpty()) {
            bool1 = this.allContainAttributes(localVector);
            if (bool1) {
                bool2 = this.vocabLangAttributeExist(localVector);
                if (!bool2) {
                    this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "<langstring> element in vocabulary type is required to contain the xml:lang attribute with value 'x-none'");
                    i = 0;
                }
            } else {
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "<langstring> element in vocabulary type is required to contain the xml:lang attribute with value 'x-none'");
                i = 0;
            }
        }
        for (n = 0; n < localVector.size(); ++n) {
            int i2;
            i1 = 0;
            localNode = (Node)localVector.elementAt(n);
            localNodeList = localNode.getChildNodes();
            if (localNodeList == null) continue;
            for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
                localNode = localNodeList.item(i2);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++i1;
            }
            if (i1 == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "No data was found in element <" + paramString2 + "> and fails the minimum character length " + "test");
                continue;
            }
            if (i1 == 1) {
                for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
                    localNode = localNodeList.item(i2);
                    if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                    str1 = this.getTaggedData((Node)localVector.elementAt(n));
                    if (paramString2.equalsIgnoreCase("source")) {
                        this.setMessage(MessageType.INFO, "MetadataUtil::verifyBestPracticeLang()", "Testing the value of <source>");
                        if (!str1.equals("LOMv1.0")) {
                            if (this.typeAndNameResult && this.validTypeValue) {
                                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "<source> value found - '" + str1 + "' ");
                                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "Must equal 'LOMv1.0' in order to adhear to Best Practice Vocabulary");
                                this.notBest = true;
                            }
                            if (str1.length() > m) {
                                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "The text contained in source <langstring> is greater than " + m);
                                continue;
                            }
                            if (str1.length() < 1) {
                                i = 0;
                                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "No text was found in source <langstring> and fails the minimum character length test");
                                continue;
                            }
                            this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' Character " + " length for this value has been " + "verified");
                            continue;
                        }
                        if (this.validTypeValue && this.typeAndNameResult) {
                            this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "<source> value equals 'LOMv1.0'");
                            this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "<value> must now contain a valid Best Practice Vocabulary token");
                            this.notBest = false;
                            continue;
                        }
                        if (str1.length() > m) {
                            this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "The text contained in source <langstring> is greater than " + m);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "No text was found in source <langstring> and fails the minimum character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' Character " + " length for this value has been " + "verified");
                        continue;
                    }
                    if (!paramString2.equals("value")) continue;
                    if (!this.notBest) {
                        for (int i3 = 0; i3 < paramVector.size(); ++i3) {
                            String str3 = (String)paramVector.elementAt(i3);
                            if (!str1.equals(str3)) continue;
                            k = true;
                            if (!paramString1.equalsIgnoreCase("type")) continue;
                            this.valueOfType = str1;
                        }
                        this.setMessage(MessageType.INFO, "MetadataUtil::verifyBestPracticeLang()", "Testing the value of <value>");
                        if (!k) {
                            if (!this.notBest) {
                                this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' " + " - Not a valid Best Practice " + "Vocabulary token");
                                i = 0;
                            } else {
                                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' " + " - Not a valid Best Practice " + "Vocabulary token");
                            }
                            if (!paramString1.equalsIgnoreCase("type")) continue;
                            this.validTypeValue = false;
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' " + "- A Valid Best Practice Vocabulary token");
                        continue;
                    }
                    if (paramString1.equalsIgnoreCase("type")) {
                        this.validTypeValue = false;
                    }
                    if (str1.length() > m) {
                        this.setMessage(MessageType.WARNING, "MetadataUtil::verifyBestPracticeLang()", "The text contained in value <langstring> is greater than " + m);
                        continue;
                    }
                    if (str1.length() < 1) {
                        this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "No text was found in value <langstring> and fails the minimum character length test");
                        i = 0;
                        continue;
                    }
                    this.setMessage(MessageType.PASSED, "MetadataUtil::verifyBestPracticeLang()", "Found '" + str1 + "' Character " + " length for this value has been " + "verified");
                }
            }
            i = 0;
            if (DebugIndicator.ON) {
                System.out.println("There were " + i1 + " TEXT_NODE elements found");
            }
            this.setMessage(MessageType.FAILED, "MetadataUtil::verifyBestPracticeLang()", "Too many text strings were found in <langstring> and fails the test");
            i = 0;
        }
        return i > 0;
    }

    public boolean verifyVocabulary(Node paramNode, Vector paramVector, String paramString, boolean paramBoolean) {
        boolean i = true;
        boolean j = false;
        boolean bool1 = true;
        boolean k = false;
        boolean bool2 = true;
        if (paramString.equalsIgnoreCase("type")) {
            this.typeNotUsed = false;
            this.setMessage(MessageType.INFO, "MetadataUtil::verifyVocabulary()", "Testing for element <name> to accompany  <type>");
            if (!this.peek(paramNode.getParentNode(), "name")) {
                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyVocabulary()", "No <name> element was detected.  Best Practice vocabulary will NOT be tested for element <type>.  It is recommended that the <type> and <name> elements accompany each other.");
                this.typeAndNameResult = false;
                this.notBest = true;
            } else {
                this.setMessage(MessageType.PASSED, "MetadataUtil::verifyVocabulary()", "<name> element was detected.  Best Practice vocabulary will be tested for element <type>.  It is recommended that the <type> and <name> elements accompany each other.");
            }
        } else if (paramString.equalsIgnoreCase("name")) {
            this.setMessage(MessageType.INFO, "MetadataUtil::verifyVocabulary()", "Testing for element <type> to accompany  <name>");
            if (this.typeNotUsed) {
                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyVocabulary()", "No <type> element was detected.  Best Practice vocabulary will NOT be tested for element <name>.  It is recommended that the <type> and <name> elements accompany each other.");
                this.typeAndNameResult = false;
                this.notBest = true;
                this.validTypeValue = false;
            } else {
                this.setMessage(MessageType.PASSED, "MetadataUtil::verifyVocabulary()", "<type> element was detected.  Best Practice vocabulary will be tested for element <name>.  It is recommended that the <type> and <name> elements accompany each other.");
            }
            if (!this.validTypeValue && !this.typeNotUsed) {
                this.setMessage(MessageType.INFO, "MetadataUtil::verifyVocabulary()", "Testing if a best practice vocabulary list exists for element <name>");
                this.setMessage(MessageType.WARNING, "MetadataUtil::verifyVocabulary()", "Element 4.4.1 <type> did not adhere to the best practice vocabulary list, so there is no best practice vocabulary list for <name>.");
                this.notBest = true;
            }
        }
        this.setMessage(MessageType.INFO, "MetadataUtil::verifyVocabulary()", "Testing element <" + paramString + ">" + " for element <source> and <value>...");
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str = new String();
        for (int m = 0; m < localNodeList.getLength(); ++m) {
            localNode = localNodeList.item(m);
            if (localNode.getNodeType() != 1) continue;
            str = localNode.getLocalName();
            if (str.equalsIgnoreCase("source")) {
                if (!j) {
                    this.setMessage(MessageType.INFO, "MetaDataUtil::verifyVocabulary()", "Testing element <source> for multiplicity...");
                    this.setMessage(MessageType.PASSED, "MetaDataUtil::verifyVocabulary()", "Element <source> existed 1 and only 1 time");
                    j = true;
                }
                if (paramBoolean) {
                    bool1 = this.verifyRestrictedLang(localNode, "source", paramVector);
                    continue;
                }
                bool1 = this.verifyBestPracticeLang(localNode, paramString, "source", paramVector);
                continue;
            }
            if (!str.equalsIgnoreCase("value")) continue;
            if (!k) {
                this.setMessage(MessageType.INFO, "MetaDataUtil::verifyVocabulary()", "Testing element <value> for multiplicity...");
                this.setMessage(MessageType.PASSED, "MetaDataUtil::verifyVocabulary()", "Element <value> existed 1 and only 1 time");
                k = true;
            }
            bool2 = paramBoolean ? this.verifyRestrictedLang(localNode, "value", paramVector) : this.verifyBestPracticeLang(localNode, paramString, "value", paramVector);
        }
        return bool1 && bool2;
    }

    public String getvalueOfType() {
        return this.valueOfType;
    }

    public int getNumMessages() {
        return this.messages.size();
    }

    public void clearMessages() {
        this.messages.clear();
    }

    public Message[] getMessages(boolean paramBoolean) {
        Message[] arrayOfMessage = new Message[this.messages.size()];
        for (int i = 0; i < this.messages.size(); ++i) {
            arrayOfMessage[i] = (Message)this.messages.elementAt(i);
        }
        if (paramBoolean) {
            this.clearMessages();
        }
        return arrayOfMessage;
    }

    public Collection getMessages() {
        return this.messages;
    }

    public void appendMessages(Collection paramCollection) {
        this.messages.addAll(paramCollection);
    }

    public void setMessage(int paramInt, String paramString1, String paramString2) {
        Message localMessage = new Message(paramInt, paramString2, paramString1);
        this.messages.add(localMessage);
        if (DebugIndicator.ON) {
            System.out.println(localMessage.toString());
        }
    }

    public String getTaggedData(Node paramNode) {
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            for (int i = 0; i < localNodeList.getLength(); ++i) {
                if (localNodeList.item(i).getNodeType() != 3 && localNodeList.item(i).getNodeType() != 4) continue;
                str = str + localNodeList.item(i).getNodeValue().trim();
            }
        }
        if (DebugIndicator.ON) {
            System.out.println("%%% no kids for value %%%");
        }
        return str;
    }

    public boolean peek(Node paramNode, String paramString) {
        int i = 0;
        Node localNode = paramNode;
        String str = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str = localNode.getLocalName()).equals(paramString)) continue;
            i = 1;
            break;
        }
        return i > 0;
    }
}

