/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.DatetypeRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationRules
extends MetadataUtil {
    private String elemNum;
    private Node annotationNode;
    private boolean optionalNotUsed = true;

    public AnnotationRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println();
            System.out.println("/////////////////////////////////");
            System.out.println("AnnotationRules() called");
            System.out.println("/////////////////////////////////");
            System.out.println();
        }
        this.annotationNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("Element " + this.elemNum + " <annotation> has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        boolean i2 = true;
        NodeList localNodeList = this.annotationNode.getChildNodes();
        Node localNode = this.annotationNode;
        for (int i3 = 0; i3 < localNodeList.getLength(); ++i3) {
            int i4;
            localNode = localNodeList.item(i3);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("person")) {
                if (!m) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <person>...");
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <person> for multiplicity...");
                    i4 = this.getMultiplicityUsed(this.annotationNode, str);
                    if (i4 > 1) {
                        this.setMessage(MessageType.FAILED, "AnnotationRules::verifyAssetOptional()", "More than 1 <person> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i4 == 1) {
                        this.setMessage(MessageType.PASSED, "AnnotationRules::verifyAssetOptional()", "0 or 1 <person> element was found");
                        if (!this.verifyPerson(localNode, this.elemNum + ".1")) {
                            i = false;
                        }
                    }
                    m = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("date")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <date>...");
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <date> for multiplicity...");
                    i4 = this.getMultiplicityUsed(this.annotationNode, str);
                    if (i4 > 1) {
                        this.setMessage(MessageType.FAILED, "AnnotationRules::verifyAssetOptional()", "More than 1 <date> element was found .. 0 or 1 allowed");
                        j = false;
                    } else if (i4 == 1) {
                        this.setMessage(MessageType.PASSED, "AnnotationRules::verifyAssetOptional()", "0 or 1 <date> element was found");
                        if (!this.verifyDate(localNode, this.elemNum + ".2")) {
                            j = false;
                        }
                    }
                    n = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("description")) continue;
            if (!i1) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description>...");
                this.setMessage(MessageType.INFO, "AnnotationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description> for multiplicity...");
                i4 = this.getMultiplicityUsed(this.annotationNode, str);
                if (i4 > 1) {
                    this.setMessage(MessageType.FAILED, "AnnotationRules::verifyAssetOptional()", "More than 1 <description> element was found .. 0 or 1 allowed");
                    k = false;
                } else if (i4 == 1) {
                    this.setMessage(MessageType.PASSED, "AnnotationRules::verifyAssetOptional()", "0 or 1 <description> element was found");
                    if (!this.verifyDescription(localNode, this.elemNum + ".3")) {
                        k = false;
                    }
                }
                i1 = true;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            boolean bl = i && j && k;
        }
        return i && j && k;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyPerson(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        boolean j = false;
        String str2 = new String();
        int k = 1000;
        Node localNode1 = paramNode;
        NodeList localNodeList1 = paramNode.getChildNodes();
        if (localNodeList1 != null) {
            for (int m = 0; m < localNodeList1.getLength(); ++m) {
                Node localNode2;
                NodeList localNodeList2;
                localNode1 = localNodeList1.item(m);
                if (localNode1.getNodeType() != 1 || !(str1 = localNode1.getLocalName()).equalsIgnoreCase("vcard")) continue;
                if (!j) {
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyPerson()", "Testing element <vcard>");
                    j = true;
                }
                if ((localNodeList2 = (localNode2 = localNodeList1.item(m)).getChildNodes()) == null) continue;
                for (int n = 0; n < localNodeList2.getLength(); ++n) {
                    localNode2 = localNodeList2.item(n);
                    if (localNode2.getNodeType() != 3 && localNode2.getNodeType() != 4) continue;
                    this.setMessage(MessageType.INFO, "AnnotationRules()::verifyPerson()", "Testing element <vcard> for character length..");
                    str2 = str2 + this.getTaggedData(localNode1);
                }
                if (DebugIndicator.ON) {
                    System.out.println("1<= " + str2.length() + " <= " + k);
                }
                if (str2.length() > k) {
                    this.setMessage(MessageType.WARNING, "AnnotationRules::verifyPerson()", "The text contained in element " + paramString + "<person> is greater" + " than " + k);
                    continue;
                }
                if (str2.length() < 1) {
                    i = 0;
                    this.setMessage(MessageType.FAILED, "AnnotationRules::verifyPerson()", "No text was found in element " + paramString + " <person> and fails the minimum " + "character length test");
                    continue;
                }
                this.setMessage(MessageType.PASSED, "AnnotationRules::verifyPerson()", "Character length for element " + paramString + " <person> has been verified");
            }
            if (!j) {
                i = 0;
                this.setMessage(MessageType.FAILED, "AnnotationRules::verifyPerson()", "No vcard element was found in element " + paramString + " <person>");
            }
        }
        return i > 0;
    }

    private boolean verifyDate(Node paramNode, String paramString) {
        boolean bool1 = true;
        boolean bool2 = true;
        boolean i = false;
        boolean j = false;
        this.setMessage(MessageType.INFO, "AnnotationRules::verifyDate()", "Testing element " + paramString + " <date> for " + "Element <datetime>...");
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        for (int k = 0; k < localNodeList.getLength(); ++k) {
            DatetypeRules localDatetypeRules;
            localNode = localNodeList.item(k);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("datetime")) {
                if (!i) {
                    this.setMessage(MessageType.INFO, "AnnotationRules::verifyDate()", "Testing element <datetime> for multiplicity...");
                    this.setMessage(MessageType.PASSED, "AnnotationRules::verifyDate()", "Element <datetime> existed 1 and only 1 time");
                    i = true;
                }
                localDatetypeRules = new DatetypeRules(localNode);
                bool1 = localDatetypeRules.verifyDatetime();
                this.appendMessages(localDatetypeRules.getMessages());
                continue;
            }
            if (!str.equalsIgnoreCase("description")) continue;
            if (!j) {
                this.setMessage(MessageType.INFO, "AnnotationRules::verifyDate()", "Testing element <description>...");
                this.setMessage(MessageType.INFO, "AnnotationRules::verifyDate()", "Testing element <description> for multiplicity...");
                this.setMessage(MessageType.PASSED, "AnnotationRules::verifyDate()", "Element <description> existed 0 or 1 time");
                j = true;
            }
            localDatetypeRules = new DatetypeRules(localNode);
            bool2 = localDatetypeRules.verifyDescription();
            this.appendMessages(localDatetypeRules.getMessages());
        }
        if (!i) {
            this.setMessage(MessageType.INFO, "AnnotationRules::verifyRole()", "Testing element <datetime> for multiplicity...");
            this.setMessage(MessageType.FAILED, "AnnotationRules::verifyRole()", "Element <datetime> was not found and must appear 1 and only 1 time");
        }
        return bool2 && bool1;
    }

    private boolean verifyDescription(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<description>", paramString, 1000);
        return bool;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private AnnotationRules() {
    }
}

