/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.TaxonpathRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassificationRules
extends MetadataUtil {
    private String elemNum;
    private Node classificationNode;
    private boolean optionalNotUsed = true;

    public ClassificationRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("ClassificationRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.classificationNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("element " + this.elemNum + " <classification> has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        int i2;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        NodeList localNodeList = this.classificationNode.getChildNodes();
        Node localNode = this.classificationNode;
        for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            int i3;
            localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("purpose")) {
                if (m) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <purpose>...");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <purpose> for multiplicity...");
                i3 = this.getMultiplicityUsed(this.classificationNode, str);
                if (i3 > 1) {
                    this.setMessage(MessageType.FAILED, "AnnotationRules::verifyScoMandatory()", "More than 1 <purpose> element was found .. 0 or 1 allowed");
                    i = false;
                } else if (i3 == 1) {
                    this.setMessage(MessageType.PASSED, "ClassificationRules::verifyScoMandatory()", "0 or 1 <purpose> element was found");
                    if (!this.verifyPurpose(localNode)) {
                        i = false;
                    }
                }
                m = true;
                continue;
            }
            if (str.equalsIgnoreCase("description")) {
                if (n) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".3 <description>...");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".3 <description> for multiplicity...");
                i3 = this.getMultiplicityUsed(this.classificationNode, str);
                if (i3 > 1) {
                    this.setMessage(MessageType.FAILED, "AnnotationRules::verifyScoMandatory()", "More than 1 <description> element was found .. 0 or 1 allowed");
                    j = false;
                } else if (i3 == 1) {
                    this.setMessage(MessageType.PASSED, "ClassificationRules::verifyScoMandatory()", "0 or 1 <description> element was found");
                    if (!this.verifyDescription(localNode, this.elemNum + ".3")) {
                        j = false;
                    }
                }
                n = true;
                continue;
            }
            if (!str.equalsIgnoreCase("keyword")) continue;
            if (!i1) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".4 <keyword>...");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element element " + this.elemNum + ".4 <keyword> for multiplicity...");
                i3 = this.getMultiplicityUsed(this.classificationNode, str);
                if (i3 > 40) {
                    this.setMessage(MessageType.WARNING, "ClassificationRules::verifyScoMandatory()", "More than 40 <keyword> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "ClassificationRules::verifyScoMandatory()", "40 or less <keyword> elements were found");
                }
                i1 = true;
            }
            if (this.verifyKeyword(localNode, this.elemNum + ".4")) continue;
            k = false;
        }
        if (!m) {
            this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <purpose> for multiplicity...");
            this.setMessage(MessageType.FAILED, "ClassificationRules::verifyScoMandatory()", "Element " + this.elemNum + ".1 <purpose> was not found and " + "must appear 1 and only 1 time");
        }
        if (!n) {
            this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".3 <description> for multiplicity...");
            this.setMessage(MessageType.FAILED, "ClassificationRules::verifyScoMandatory()", "Element " + this.elemNum + ".3 <description> was not found and " + "must appear 1 and only 1 time");
        }
        if (!i1) {
            this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".4 <keyword> for " + "multiplicity...");
            this.setMessage(MessageType.FAILED, "ClassificationRules::verifyScoMandatory()", "Element " + this.elemNum + ".4 <keyword> was not found and " + "must appear 1 or more times");
        }
        if (DebugIndicator.ON) {
            i2 = i && j && k && m && n && i1 ? 1 : 0;
            System.out.println("returning ->" + i2);
        }
        return i && j && k && m && n && i1;
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int i4;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = true;
        boolean n = false;
        boolean i1 = false;
        boolean i2 = false;
        boolean i3 = false;
        boolean bool = true;
        NodeList localNodeList = this.classificationNode.getChildNodes();
        Node localNode = this.classificationNode;
        for (i4 = 0; i4 < localNodeList.getLength(); ++i4) {
            int i5;
            localNode = localNodeList.item(i4);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("purpose")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <purpose>...");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <purpose> for multiplicity...");
                    i5 = this.getMultiplicityUsed(this.classificationNode, str);
                    if (i5 > 1) {
                        this.setMessage(MessageType.FAILED, "AnnotationRules::verifyAssetOptional()", "More than 1 <purpose> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i5 == 1) {
                        this.setMessage(MessageType.PASSED, "ClassificationRules::verifyAssetOptional()", "0 or 1 <purpose> element was found");
                        if (!this.verifyPurpose(localNode)) {
                            i = false;
                        }
                    }
                    n = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("taxonpath")) {
                TaxonpathRules localTaxonpathRules;
                if (!i1) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <taxonpath>...");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <taxonpath> for multiplicity...");
                    i5 = this.getMultiplicityUsed(this.classificationNode, str);
                    if (i5 > 15) {
                        this.setMessage(MessageType.WARNING, "ClassificationRules::verifyAssetOptional()", "More than 15 <taxonpath> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "ClassificationRules::verifyAssetOptional()", "15 or less <taxonpath> elements were found");
                    }
                    i1 = true;
                }
                if (!(bool = (localTaxonpathRules = new TaxonpathRules(localNode, this.elemNum + ".2")).verifyAssetOptional())) {
                    j = false;
                }
                this.appendMessages(localTaxonpathRules.getMessages());
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("description")) {
                if (!i2) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description>...");
                    this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description> for multiplicity...");
                    int i6 = this.getMultiplicityUsed(this.classificationNode, str);
                    if (i6 > 1) {
                        this.setMessage(MessageType.FAILED, "AnnotationRules::verifyAssetOptional()", "More than 1 <description> element was found .. 0 or 1 allowed");
                        k = false;
                    } else if (i6 == 1) {
                        this.setMessage(MessageType.PASSED, "ClassificationRules::verifyAssetOptional()", "0 or 1 <description> element was found");
                        if (!this.verifyDescription(localNode, this.elemNum + ".3")) {
                            k = false;
                        }
                    }
                    i2 = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("keyword")) continue;
            if (!i3) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".4 <keyword>...");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyAssetOptional()", "Testing element element " + this.elemNum + ".4 <keyword> for multiplicity...");
                int i6 = this.getMultiplicityUsed(this.classificationNode, str);
                if (i6 > 40) {
                    this.setMessage(MessageType.WARNING, "ClassificationRules::verifyAssetOptional()", "More than 40 <keyword> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "ClassificationRules::verifyAssetOptional()", "40 or less <keyword> elements were found");
                }
                i3 = true;
            }
            if (!this.verifyKeyword(localNode, this.elemNum + ".4")) {
                m = false;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            i4 = i && j && k && m ? 1 : 0;
            System.out.println("returning ->" + i4);
        }
        return i && j && k && m;
    }

    public boolean verifyScoOptional() {
        boolean bool1 = true;
        boolean i = false;
        boolean bool2 = true;
        NodeList localNodeList = this.classificationNode.getChildNodes();
        Node localNode = this.classificationNode;
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            TaxonpathRules localTaxonpathRules;
            String str;
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str = localNode.getLocalName()).equalsIgnoreCase("taxonpath")) continue;
            if (!i) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoOptional()", "Testing element " + this.elemNum + ".2 <taxonpath>...");
                this.setMessage(MessageType.INFO, "ClassificationRules::verifyScoOptional()", "Testing element " + this.elemNum + ".2 <taxonpath> for multiplicity...");
                int k = this.getMultiplicityUsed(this.classificationNode, str);
                if (k > 15) {
                    this.setMessage(MessageType.WARNING, "ClassificationRules::verifyScoOptional()", "More than 15 <taxonpath> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "ClassificationRules::verifyScoOptional()", "15 or less <taxonpath> elements were found");
                }
                i = true;
            }
            if (!(bool2 = (localTaxonpathRules = new TaxonpathRules(localNode, this.elemNum + ".2")).verifyScoOptional())) {
                bool1 = false;
            }
            this.appendMessages(localTaxonpathRules.getMessages());
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("returning ->" + bool1);
        }
        return bool1;
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyPurpose(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = this.buildVocabPurpose();
        bool1 = this.verifyVocabulary(paramNode, localVector, "purpose", bool2);
        return bool1;
    }

    private boolean verifyDescription(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<description>", paramString, 2000);
        return bool;
    }

    private boolean verifyKeyword(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<keyword>", paramString, 1000);
        return bool;
    }

    private Vector buildVocabPurpose() {
        Vector<String> localVector = new Vector<String>(8);
        localVector.add("Discipline");
        localVector.add("Idea");
        localVector.add("Prerequisite");
        localVector.add("Educational Objective");
        localVector.add("Accessibility Restrictions");
        localVector.add("Educational Level");
        localVector.add("Skill Level");
        localVector.add("Security Level");
        return localVector;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private ClassificationRules() {
    }
}

