/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.DatetypeRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContributeRules
extends MetadataUtil {
    private String elemNum;
    private Node contributeNode;
    private boolean optionalNotUsed = true;

    public ContributeRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("ContributeRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.contributeNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("Element " + this.elemNum + " <contribute> has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptionalLifecycle() {
        int i2;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        NodeList localNodeList = this.contributeNode.getChildNodes();
        Node localNode = this.contributeNode;
        for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            int i3;
            localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("role")) {
                if (m) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <role>...");
                i3 = this.getMultiplicityUsed(this.contributeNode, str);
                if (i3 > 1) {
                    this.setMessage(MessageType.FAILED, "ContributeRules::verifyAssetOptional()", "More than 1 <role> element was found .. 1 and only 1 allowed");
                    i = false;
                } else {
                    this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptional()", "1 and only 1 <role> element was found");
                    if (!this.verifyRoleLifecycle(localNode)) {
                        i = false;
                    }
                }
                m = true;
                continue;
            }
            if (str.equalsIgnoreCase("centity")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <centity>...");
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <centity> for multiplicity...");
                    i3 = this.getMultiplicityUsed(this.contributeNode, str);
                    if (i3 > 40) {
                        this.setMessage(MessageType.WARNING, "ContributeRules::verifyAssetOptional()", "More than 40 <centity> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptional()", "40 or less <centity> elements were found");
                    }
                    n = true;
                }
                if (this.verifyCentity(localNode, this.elemNum + ".2")) continue;
                j = false;
                continue;
            }
            if (!str.equalsIgnoreCase("date") || i1) continue;
            this.setMessage(MessageType.OTHER, "", "");
            this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <date>...");
            i3 = this.getMultiplicityUsed(this.contributeNode, str);
            if (i3 > 1) {
                this.setMessage(MessageType.FAILED, "ContributeRules::verifyAssetOptional()", "More than 1 <date> element was found .. 0 or 1 allowed");
                k = false;
            } else {
                this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptional()", "0 or 1 <date> element was found");
                if (!this.verifyDate(localNode, this.elemNum + ".2")) {
                    k = false;
                }
            }
            i1 = true;
        }
        if (DebugIndicator.ON) {
            i2 = i && j && k ? 1 : 0;
            System.out.println("returning ->" + i2);
        }
        return i && j && k;
    }

    public boolean verifyAssetOptionalMetametadata() {
        int i2;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        NodeList localNodeList = this.contributeNode.getChildNodes();
        Node localNode = this.contributeNode;
        for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            int i3;
            localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("role")) {
                if (m) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptionalMetametadata()", "Testing element " + this.elemNum + ".1 <role>...");
                i3 = this.getMultiplicityUsed(this.contributeNode, str);
                if (i3 > 1) {
                    this.setMessage(MessageType.FAILED, "ContributeRules::verifyAssetOptionalMetametadata()", "More than 1 <role> element was found .. 1 and only 1 allowed");
                    i = false;
                } else {
                    this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptionalMetametadata()", "1 and only 1 <role> element was found");
                    if (!this.verifyRoleMetametadata(localNode)) {
                        i = false;
                    }
                }
                m = true;
                continue;
            }
            if (str.equalsIgnoreCase("centity")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptionalMetametadata()", "Testing element " + this.elemNum + ".2 <centity>...");
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptionalMetametadata()", "Testing element " + this.elemNum + ".2 <centity> for multiplicity...");
                    i3 = this.getMultiplicityUsed(this.contributeNode, str);
                    if (i3 > 10) {
                        this.setMessage(MessageType.WARNING, "ContributeRules::verifyAssetOptionalMetametadata()", "More than 10 <centity> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptionalMetametadata()", "10 or less <centity> elements were found");
                    }
                    n = true;
                }
                if (this.verifyCentity(localNode, this.elemNum + ".2")) continue;
                j = false;
                continue;
            }
            if (!str.equalsIgnoreCase("date") || i1) continue;
            this.setMessage(MessageType.OTHER, "", "");
            this.setMessage(MessageType.INFO, "ContributeRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <date>...");
            i3 = this.getMultiplicityUsed(this.contributeNode, str);
            if (i3 > 1) {
                this.setMessage(MessageType.FAILED, "ContributeRules::verifyAssetOptional()", "More than 1 <date> element was found .. 0 or 1 allowed");
                i = false;
            } else {
                this.setMessage(MessageType.PASSED, "ContributeRules::verifyAssetOptional()", "0 or 1 <date> element was found");
                if (!this.verifyDate(localNode, this.elemNum + ".2")) {
                    k = false;
                }
            }
            i1 = true;
        }
        if (DebugIndicator.ON) {
            i2 = i && j && k ? 1 : 0;
            System.out.println("returning ->" + i2);
        }
        return i && j && k;
    }

    public boolean verifyScoOptionalLifecycle() {
        return this.verifyAssetOptionalLifecycle();
    }

    public boolean verifyCaOptionalLifecycle() {
        return this.verifyScoOptionalLifecycle();
    }

    public boolean verifyScoOptionalMetametadata() {
        return this.verifyAssetOptionalMetametadata();
    }

    public boolean verifyCaOptionalMetametadata() {
        return this.verifyScoOptionalMetametadata();
    }

    private boolean verifyRoleLifecycle(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = this.buildVocabLifecycleRole();
        bool1 = this.verifyVocabulary(paramNode, localVector, "role", bool2);
        return bool1;
    }

    private boolean verifyRoleMetametadata(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = this.buildVocabMetametadataRole();
        bool1 = this.verifyVocabulary(paramNode, localVector, "role", bool2);
        return bool1;
    }

    private boolean verifyCentity(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        boolean j = false;
        String str2 = new String();
        int k = 1000;
        Node localNode1 = paramNode;
        NodeList localNodeList1 = paramNode.getChildNodes();
        if (localNodeList1 != null) {
            for (int m = 0; m < localNodeList1.getLength(); ++m) {
                Node localNode2;
                NodeList localNodeList2;
                localNode1 = localNodeList1.item(m);
                if (localNode1.getNodeType() != 1 || !(str1 = localNode1.getLocalName()).equalsIgnoreCase("vcard")) continue;
                if (!j) {
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyCentity()", "Testing element <vcard>");
                    j = true;
                }
                if ((localNodeList2 = (localNode2 = localNodeList1.item(m)).getChildNodes()) == null) continue;
                for (int n = 0; n < localNodeList2.getLength(); ++n) {
                    localNode2 = localNodeList2.item(n);
                    if (localNode2.getNodeType() != 3 && localNode2.getNodeType() != 4) continue;
                    this.setMessage(MessageType.INFO, "ContributeRules()::verifyCentity()", "Testing element <vcard> for character length..");
                    str2 = str2 + this.getTaggedData(localNode1);
                }
                if (DebugIndicator.ON) {
                    System.out.println("1<= " + str2.length() + " <= " + k);
                }
                if (str2.length() > k) {
                    this.setMessage(MessageType.WARNING, "ContributeRules::verifyCentity()", "The text contained in element " + paramString + "<centity> is greater than " + k);
                    continue;
                }
                if (str2.length() < 1) {
                    i = 0;
                    this.setMessage(MessageType.FAILED, "ContributeRules::verifyCentity()", "No text was found in element " + paramString + " <centity> and fails the minimum " + "character length test");
                    continue;
                }
                this.setMessage(MessageType.PASSED, "ContributeRules::verifyCentity()", "Character length for element " + paramString + " <centity> has been verified");
            }
            if (!j) {
                i = 0;
                this.setMessage(MessageType.FAILED, "ContributeRules::verifyCentity()", "No vcard element was found in element " + paramString + " <centity>");
            }
        }
        return i > 0;
    }

    private boolean verifyDate(Node paramNode, String paramString) {
        boolean bool1 = true;
        boolean bool2 = true;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        this.setMessage(MessageType.INFO, "ContributeRules::verifyDate()", "Testing element " + paramString + " <date> for " + "Element <datetime> and <description>...");
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        for (int n = 0; n < localNodeList.getLength(); ++n) {
            DatetypeRules localDatetypeRules;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("datetime")) {
                if (!k) {
                    this.setMessage(MessageType.INFO, "ContributeRules::verifyDate()", "Testing element <datetime> for multiplicity...");
                    this.setMessage(MessageType.PASSED, "ContributeRules::verifyDate()", "Element <datetime> existed 1 and only 1 time");
                    k = true;
                }
                if (!(bool1 = (localDatetypeRules = new DatetypeRules(localNode)).verifyDatetime())) {
                    i = false;
                }
                this.appendMessages(localDatetypeRules.getMessages());
                continue;
            }
            if (!str.equalsIgnoreCase("description")) continue;
            if (!m) {
                this.setMessage(MessageType.INFO, "ContributeRules::verifyDate()", "Testing element <description>...");
                this.setMessage(MessageType.INFO, "ContributeRules::verifyDate()", "Testing element <description> for multiplicity...");
                this.setMessage(MessageType.PASSED, "ContributeRules::verifyDate()", "Element <description> existed 0 or 1 time");
                m = true;
            }
            if (!(bool2 = (localDatetypeRules = new DatetypeRules(localNode)).verifyDescription())) {
                j = false;
            }
            this.appendMessages(localDatetypeRules.getMessages());
        }
        if (!k) {
            this.setMessage(MessageType.INFO, "ContributeRules::verifyRole()", "Testing element <datetime> for multiplicity...");
            this.setMessage(MessageType.FAILED, "ContributeRules::verifyRole()", "Element <datetime> was not found and must appear 1 and only 1 time");
        }
        return j && i;
    }

    private Vector buildVocabLifecycleRole() {
        Vector<String> localVector = new Vector<String>(14);
        localVector.add("Author");
        localVector.add("Publisher");
        localVector.add("Unknown");
        localVector.add("Initiator");
        localVector.add("Terminator");
        localVector.add("Validator");
        localVector.add("Editor");
        localVector.add("Graphical Designer");
        localVector.add("Technical Implementer");
        localVector.add("Content Provider");
        localVector.add("Technical Validator");
        localVector.add("Educational Validator");
        localVector.add("Script Writer");
        localVector.add("Instructional Designer");
        return localVector;
    }

    private Vector buildVocabMetametadataRole() {
        Vector<String> localVector = new Vector<String>(2);
        localVector.add("Creator");
        localVector.add("Validator");
        return localVector;
    }

    private ContributeRules() {
    }
}

