/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatetypeRules
extends MetadataUtil {
    private Node datetypeNode;

    public DatetypeRules(Node paramNode) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("DatetypeRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.datetypeNode = paramNode;
    }

    public boolean verifyDatetime() {
        boolean i = true;
        boolean j = true;
        int k = 200;
        int m = 1;
        String str1 = new String();
        String str2 = new String();
        int n = 0;
        Node localNode = this.datetypeNode;
        NodeList localNodeList = this.datetypeNode.getChildNodes();
        if (localNodeList != null) {
            int i1;
            for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                localNode = localNodeList.item(i1);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++n;
            }
            if (n <= 0) {
                m = 0;
                this.setMessage(MessageType.FAILED, "DatetypeRules::verifyDatetime()", "No data was found in element <datetime> and fails the minimum character length test");
            } else {
                if (n == 1) {
                    for (i1 = 0; i1 < localNodeList.getLength(); ++i1) {
                        Object localObject2;
                        Object localObject1;
                        localNode = localNodeList.item(i1);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "DatetypeRules::verifyDatetime()", "Testing element <datetime>..");
                        str1 = this.getTaggedData(this.datetypeNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1 <= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "DatetypeRules::verifyDatetime()", "The text contained in element <datetime> is greater than " + k);
                        } else if (str1.length() < 1) {
                            m = 0;
                            this.setMessage(MessageType.FAILED, "DatetypeRules::verifyDatetime()", "No text was found in element <datetime> and fails the minimum character length test");
                        } else {
                            this.setMessage(MessageType.PASSED, "DatetypeRules::verifyDatetime()", "Character length for element <datetime> has been verified");
                        }
                        boolean i2 = false;
                        StringTokenizer localStringTokenizer = new StringTokenizer(str1, "-");
                        int i3 = localStringTokenizer.countTokens();
                        if (i3 == 3) {
                            localObject1 = localStringTokenizer.nextToken();
                            localObject2 = localStringTokenizer.nextToken();
                            String str3 = localStringTokenizer.nextToken();
                            if (((String)localObject1).length() == 4 && ((String)localObject2).length() == 2 && str3.length() == 2) {
                                i2 = true;
                            }
                        }
                        localObject1 = new SimpleDateFormat("yyyy-mm-dd");
                        localObject2 = new SimpleDateFormat("hh:mm:ss");
                        if (i2) {
                            try {
                                ((SimpleDateFormat)localObject1).parse(str1);
                            }
                            catch (ParseException localParseException1) {
                                i = false;
                            }
                        } else {
                            i = false;
                        }
                        if (!i) {
                            try {
                                ((SimpleDateFormat)localObject2).parse(str1);
                            }
                            catch (ParseException localParseException2) {
                                j = false;
                            }
                        }
                        if (i || j) {
                            this.setMessage(MessageType.PASSED, "DatetypeRules::verifyDatetime()", "DateType for element <datetime> has been verified");
                            continue;
                        }
                        this.setMessage(MessageType.WARNING, "DatetypeRules::verifyDatetime()", "DateType for element <datetime> may not contain a valid date or time format");
                        this.setMessage(MessageType.WARNING, "DatetypeRules::verifyDatetime()", "Date/time used: " + str1);
                        this.setMessage(MessageType.WARNING, "DatetypeRules::verifyDatetime()", "Date format used for testing: International Standard Date notation (" + ((SimpleDateFormat)localObject1).toLocalizedPattern() + ")");
                        this.setMessage(MessageType.WARNING, "DatetypeRules::verifyDatetime()", "Time format used for testing: International Standard Notation for the Time of Day (" + ((SimpleDateFormat)localObject2).toLocalizedPattern() + ")");
                    }
                }
                m = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + n + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "DatetypeRules::verifyDatetime()", "Too many text strings were found in <datetime> and fails the test");
            }
        } else {
            m = 0;
            this.setMessage(MessageType.FAILED, "DatetypeRules::verifyDatetime()", "No data was found in element <datetime> and fails the minimum character length test");
        }
        return m > 0;
    }

    public boolean verifyDescription() {
        boolean bool = true;
        bool = this.verifyLangstring(this.datetypeNode, "<description>", "", 1000);
        return bool;
    }

    private DatetypeRules() {
    }
}

