/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.ContributeRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LifecycleRules
extends MetadataUtil {
    private String elemNum;
    private Node lifecycleNode;
    private boolean optionalNotUsed = true;

    public LifecycleRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("LifecycleRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.lifecycleNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("element " + this.elemNum + " <lifecycle> has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        int n;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        NodeList localNodeList = this.lifecycleNode.getChildNodes();
        Node localNode = this.lifecycleNode;
        for (n = 0; n < localNodeList.getLength(); ++n) {
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("version")) {
                if (!k) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <version>...");
                    this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <version> for multiplicity...");
                    int i1 = this.getMultiplicityUsed(this.lifecycleNode, str);
                    if (i1 > 1) {
                        this.setMessage(MessageType.FAILED, "LifecycleRules::verifyAssetOptional()", "More than 1 <version> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i1 == 1) {
                        this.setMessage(MessageType.PASSED, "LifecycleRules::verifyAssetOptional()", "0 or 1 <version> element was found");
                        if (!this.verifyVersion(localNode, this.elemNum + ".1")) {
                            i = false;
                        }
                    }
                }
                k = true;
                continue;
            }
            if (!str.equalsIgnoreCase("status")) continue;
            if (!m) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".2 <status>...");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".2 <status> for multiplicity...");
                this.setMessage(MessageType.PASSED, "LifecycleRules::verifyScoMandatory()", "Element " + this.elemNum + ".2 <status> existed 1 and only 1 time");
                m = true;
            }
            if (this.verifyStatus(localNode)) continue;
            j = false;
        }
        if (!k) {
            this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".1 <version> for multiplicity...");
            this.setMessage(MessageType.FAILED, "LifecycleRules::verifyScoMandatory()", "Element " + this.elemNum + ".1 <version> was not found and " + "must appear 1 and only 1 time");
        }
        if (!m) {
            this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoMandatory()", "Testing element " + this.elemNum + ".2 <status> for multiplicity...");
            this.setMessage(MessageType.FAILED, "LifecycleRules::verifyScoMandatory()", "Element " + this.elemNum + ".2 <status> was not found and " + "must appear 1 and only 1 time");
        }
        if (DebugIndicator.ON) {
            n = i && j && k && m ? 1 : 0;
            System.out.println("returning ->" + n);
        }
        return i && j && k && m;
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int i2;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        boolean bool = true;
        NodeList localNodeList = this.lifecycleNode.getChildNodes();
        Node localNode = this.lifecycleNode;
        for (i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            ContributeRules localContributeRules;
            int i3;
            localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("version")) {
                if (m) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <version>...");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <version> for multiplicity...");
                i3 = this.getMultiplicityUsed(this.lifecycleNode, str);
                if (i3 > 1) {
                    this.setMessage(MessageType.FAILED, "LifecycleRules::verifyAssetOptional()", "More than 1 <version> element was found .. 0 or 1 allowed");
                    i = false;
                } else if (i3 == 1) {
                    this.setMessage(MessageType.PASSED, "LifecycleRules::verifyAssetOptional()", "0 or 1 <version> element was found");
                    if (!this.verifyVersion(localNode, this.elemNum + ".1")) {
                        i = false;
                    }
                }
                m = true;
                continue;
            }
            if (str.equalsIgnoreCase("status")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <status>...");
                    this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <status> for multiplicity...");
                    this.setMessage(MessageType.PASSED, "LifecycleRules::verifyAssetOptional()", "Element " + this.elemNum + ".2 <status> existed 1 and only 1 time");
                    n = true;
                }
                if (this.verifyStatus(localNode)) continue;
                j = false;
                continue;
            }
            if (!str.equalsIgnoreCase("contribute")) continue;
            if (!i1) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <contribute>...");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <contribute> for multiplicity...");
                i3 = this.getMultiplicityUsed(this.lifecycleNode, str);
                if (i3 > 30) {
                    this.setMessage(MessageType.WARNING, "LifecycleRules::verifyAssetOptional()", "More than 30 <contribute> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "LifecycleRules::verifyAssetOptional()", "30 or less <contribute> elements were found");
                }
                i1 = true;
            }
            if (!(bool = (localContributeRules = new ContributeRules(localNode, this.elemNum + ".3")).verifyAssetOptionalLifecycle())) {
                k = false;
            }
            this.appendMessages(localContributeRules.getMessages());
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            i2 = i && j && k ? 1 : 0;
            System.out.println("returning ->" + i2);
        }
        return i && j && k;
    }

    public boolean verifyScoOptional() {
        boolean bool1 = true;
        boolean i = false;
        boolean bool2 = true;
        NodeList localNodeList = this.lifecycleNode.getChildNodes();
        Node localNode = this.lifecycleNode;
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            ContributeRules localContributeRules;
            String str;
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str = localNode.getLocalName()).equalsIgnoreCase("contribute")) continue;
            if (!i) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoOptional()", "Testing element " + this.elemNum + ".3 <contribute>...");
                this.setMessage(MessageType.INFO, "LifecycleRules::verifyScoOptional()", "Testing element " + this.elemNum + ".3 <contribute> for multiplicity...");
                int k = this.getMultiplicityUsed(this.lifecycleNode, str);
                if (k > 30) {
                    this.setMessage(MessageType.WARNING, "LifecycleRules::verifyScoOptional()", "More than 30 <contribute> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "LifecycleRules::verifyScoOptional()", "30 or less <contribute> elements were found");
                }
                i = true;
            }
            if (!(bool2 = (localContributeRules = new ContributeRules(localNode, this.elemNum + ".3")).verifyAssetOptionalLifecycle())) {
                bool1 = false;
            }
            this.appendMessages(localContributeRules.getMessages());
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("returning ->" + bool1);
        }
        return bool1;
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyVersion(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<version>", paramString, 50);
        return bool;
    }

    private boolean verifyStatus(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = true;
        Vector localVector = this.buildVocabStatus();
        bool1 = this.verifyVocabulary(paramNode, localVector, "status", bool2);
        return bool1;
    }

    private Vector buildVocabStatus() {
        Vector<String> localVector = new Vector<String>(4);
        localVector.add("Draft");
        localVector.add("Final");
        localVector.add("Revised");
        localVector.add("Unavailable");
        return localVector;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private LifecycleRules() {
    }
}

