/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.CatalogentryRules;
import org.adl.testsuite.metadata.rules.ContributeRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetametadataRules
extends MetadataUtil {
    private String elemNum;
    private Node metametadataNode;
    private boolean optionalNotUsed = true;

    public MetametadataRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("MetametadataRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.metametadataNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        int m;
        boolean i = true;
        boolean j = false;
        boolean k = true;
        NodeList localNodeList = this.metametadataNode.getChildNodes();
        Node localNode = this.metametadataNode;
        for (m = 0; m < localNodeList.getLength(); ++m) {
            localNode = localNodeList.item(m);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("metadatascheme")) {
                if (!j) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".4 <metadatascheme>...");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".4 <metadatascheme> for " + "multiplicity...");
                    int n = this.getMultiplicityUsed(this.metametadataNode, str);
                    if (n > 10) {
                        this.setMessage(MessageType.WARNING, "MetametadataRules::verifyAssetMandatory()", "More than 10 <metadatascheme> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyAssetMandatory()", "10 or less <metadatascheme> elements were found");
                    }
                    j = true;
                }
                if (this.verifyMetadatascheme(localNode, this.elemNum + ".4")) continue;
                i = false;
                continue;
            }
            if (!str.equalsIgnoreCase("identifier")) continue;
            k = false;
            this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetMandatory()", "Testing element 3 <metametadata> for reserved element <identifier>..");
            this.setMessage(MessageType.FAILED, "MetametadataRules::verifyAssetMandatory()", "Element 3.1 <identifier> was found and is a Reserved  element");
        }
        if (!j) {
            this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetMandatory()", "Testing element 3.4 <metadatascheme> for multiplicity...");
            this.setMessage(MessageType.FAILED, "MetametadataRules::verifyAssetMandatory()", "Element 3.4 <metadatascheme> was not found and must appear 1 or more times");
        }
        if (DebugIndicator.ON) {
            m = i && j ? 1 : 0;
            System.out.println("returning ->" + m);
        }
        return i && j && k;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int i3;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = false;
        boolean n = false;
        boolean i1 = false;
        boolean i2 = true;
        boolean bool = true;
        NodeList localNodeList = this.metametadataNode.getChildNodes();
        Node localNode = this.metametadataNode;
        for (i3 = 0; i3 < localNodeList.getLength(); ++i3) {
            localNode = localNodeList.item(i3);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("catalogentry")) {
                CatalogentryRules localCatalogentryRules;
                if (!m) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <catalogentry>...");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <catalogentry> for multiplicity...");
                    int i4 = this.getMultiplicityUsed(this.metametadataNode, str);
                    if (i4 > 10) {
                        this.setMessage(MessageType.WARNING, "MetametadataRules::verifyAssetOptional()", "More than 10 <catalogentry> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyAssetOptional()", "10 or less <catalogentry> elements were found");
                    }
                    m = true;
                }
                if (!(bool = (localCatalogentryRules = new CatalogentryRules(localNode, this.elemNum + ".2")).verifyAssetOptional())) {
                    i = false;
                }
                this.appendMessages(localCatalogentryRules.getMessages());
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("contribute")) {
                ContributeRules localContributeRules;
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <contribute>...");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element 3.3 <contribute> for multiplicity...");
                    int i5 = this.getMultiplicityUsed(this.metametadataNode, str);
                    if (i5 > 10) {
                        this.setMessage(MessageType.WARNING, "MetametadataRules::verifyAssetOptional()", "More than 10 <contribute> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyAssetOptional()", "10 or less <contribute> elements were found");
                    }
                    n = true;
                }
                if (!(bool = (localContributeRules = new ContributeRules(localNode, this.elemNum + ".3")).verifyAssetOptionalMetametadata())) {
                    j = false;
                }
                this.appendMessages(localContributeRules.getMessages());
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("language")) {
                if (!i1) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".5 <language>...");
                    this.setMessage(MessageType.INFO, "LomRules::verifyAssetOptional()", "Testing element 3..5 <language> for multiplicity...");
                    int i6 = this.getMultiplicityUsed(this.metametadataNode, str);
                    if (i6 > 1) {
                        this.setMessage(MessageType.FAILED, "MetametadataRules::verifyAssetOptional()", "More than 1 <languge> element was found...0 or 1 allowed");
                        k = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyAssetOptional()", "0 or 1 <language> element was found");
                        if (!this.verifyLanguage(localNode, this.elemNum + ".2")) {
                            k = false;
                        }
                    }
                    i1 = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("identifier")) continue;
            i2 = false;
            this.setMessage(MessageType.INFO, "MetametadataRules::verifyAssetOptional()", "Testing element 3 <metametadata> for reserved  element <identifier>..");
            this.setMessage(MessageType.FAILED, "MetametadataRules::verifyAssetOptional()", "Element 3.1 <identifier> was found and is a Reserved element");
        }
        if (DebugIndicator.ON) {
            i3 = i && j && k ? 1 : 0;
            System.out.println("returning -> " + i3);
        }
        return i && j && k && i2;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyMetadatascheme(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 30;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "MetametadataRules::verifyMetadatascheme()", "No data was found in element <metadatascheme> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "MetametadataRules::verifyMetadatascheme()", "Testing text of element <metadatascheme> for character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1 <= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "MetametadataRules::verifyMetadatascheme()", "The text contained in element <metadatascheme> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "MetametadataRules::verifyMetadatascheme()", "No text was found in element <metadatascheme> and fails the minimum character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyMetadatascheme()", "Character length for element <metadatascheme> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "MetametadataRules::verifyMetadatascheme()", "Too many text strings were found in <metadatascheme> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifyLanguage(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 100;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "MetametadataRules::verifyMetadatascheme()", "No data was found in element <language> and fails the minimum character length test");
            } else {
                if (j <= 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "MetametadataRules::verifyLanguage()", "Testing element " + paramString + " <language> for " + "character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1<= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "MetametadataRules::verifyLanguage()", "The text contained in element " + paramString + " <language> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "MetametadataRules::verifyLanguage()", "No text was found in element " + paramString + " <language> and fails the minimum " + "character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "MetametadataRules::verifyverifyLanguage()", "Character length for element " + paramString + " <language> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "MetametadataRules::verifyLanguage()", "Too many text strings were found in <language> and fails the test");
            }
        }
        return i > 0;
    }

    public boolean isOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private MetametadataRules() {
    }
}

