/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.CatalogentryRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelationRules
extends MetadataUtil {
    private String elemNum;
    private Node relationNode;
    private boolean optionalNotUsed = true;

    public RelationRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("RelationRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.relationNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("element " + this.elemNum + " (relation) has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int n;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        NodeList localNodeList = this.relationNode.getChildNodes();
        Node localNode = this.relationNode;
        for (n = 0; n < localNodeList.getLength(); ++n) {
            int i1;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("kind")) {
                if (!k) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "RelationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <kind>...");
                    this.setMessage(MessageType.INFO, "RelationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <kind> for multiplicity...");
                    i1 = this.getMultiplicityUsed(this.relationNode, str);
                    if (i1 > 1) {
                        this.setMessage(MessageType.FAILED, "RelationRules::verifyAssetOptional()", "More than 1 <kind> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i1 == 1) {
                        this.setMessage(MessageType.PASSED, "RelationRules::verifyAssetOptional()", "0 or 1 <kind> element was found");
                        if (!this.verifyKind(localNode)) {
                            i = false;
                        }
                    }
                    k = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("resource")) continue;
            if (!m) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RelationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <resource>...");
                this.setMessage(MessageType.INFO, "RelationRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <resource> for multiplicity...");
                i1 = this.getMultiplicityUsed(this.relationNode, str);
                if (i1 > 1) {
                    this.setMessage(MessageType.FAILED, "RelationRules::verifyAssetOptional()", "More than 1 <resource> element was found .. 0 or 1 allowed");
                    j = false;
                } else if (i1 == 1) {
                    this.setMessage(MessageType.PASSED, "RelationRules::verifyAssetOptional()", "0 or 1 <resource> element was found");
                    if (!this.verifyResource(localNode, this.elemNum + ".2")) {
                        j = false;
                    }
                }
                m = true;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            n = i && j ? 1 : 0;
            System.out.println("returning ->" + n);
        }
        return i && j;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyKind(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = this.buildVocabKind();
        bool1 = this.verifyVocabulary(paramNode, localVector, "kind", bool2);
        return bool1;
    }

    public boolean verifyResource(Node paramNode, String paramString) {
        boolean i = true;
        boolean j = true;
        boolean bool = true;
        boolean k = false;
        boolean m = true;
        boolean n = false;
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        for (int i1 = 0; i1 < localNodeList.getLength(); ++i1) {
            CatalogentryRules localCatalogentryRules;
            int i2;
            localNode = localNodeList.item(i1);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("description")) {
                if (k) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RelationRules::verifyResource()", "Testing element " + paramString + ".2 <description>...");
                this.setMessage(MessageType.INFO, "RelationRules::verifyResource()", "Testing element " + paramString + ".2 <description> for multiplicity...");
                i2 = this.getMultiplicityUsed(paramNode, str);
                if (i2 > 1) {
                    this.setMessage(MessageType.FAILED, "RelationRules::verifyResource()", "More than 1 <description> element was found .. 0 or 1 allowed");
                    i = false;
                } else if (i2 == 1) {
                    this.setMessage(MessageType.PASSED, "RelationRules::verifyResource()", "0 or 1 <description> element was found");
                    if (!this.verifyDescription(localNode, paramString + ".2")) {
                        i = false;
                    }
                }
                k = true;
                continue;
            }
            if (str.equalsIgnoreCase("identifier")) {
                m = false;
                this.setMessage(MessageType.INFO, "RelationRules::verifyResource()", "Testing element 7.2 <resource> for reserved element <identifier>..");
                this.setMessage(MessageType.FAILED, "RelationRules::verifyResource()", "Element 7.2.1 <identifier> was found and is a Reserved element");
                continue;
            }
            if (!str.equalsIgnoreCase("catalogentry")) continue;
            if (!n) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RelationRules::verifyResource()", "Testing element " + paramString + ".3 <catalogentry>...");
                this.setMessage(MessageType.INFO, "RelationRules::verifyResource()", "Testing element " + paramString + ".3 <catalogentry> for multiplicity...");
                i2 = this.getMultiplicityUsed(paramNode, str);
                if (i2 > 10) {
                    this.setMessage(MessageType.WARNING, "RelationRules::verifyResource()", "More than 10 <catalogentry> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "RelationRules::verifyResource()", "10 or less <catalogentry> elements were found");
                }
                n = true;
            }
            if (!(bool = (localCatalogentryRules = new CatalogentryRules(localNode, paramString + ".3")).verifyAssetOptional())) {
                j = false;
            }
            this.appendMessages(localCatalogentryRules.getMessages());
        }
        return i && m && j;
    }

    private boolean verifyDescription(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<description>", paramString, 1000);
        return bool;
    }

    private Vector buildVocabKind() {
        Vector<String> localVector = new Vector<String>(12);
        localVector.add("IsPartOf");
        localVector.add("HasPart");
        localVector.add("IsVersionOf");
        localVector.add("HasVersion");
        localVector.add("IsFormatOf");
        localVector.add("HasFormat");
        localVector.add("References");
        localVector.add("IsReferencedBy");
        localVector.add("IsBasedOn");
        localVector.add("IsBasisFor");
        localVector.add("Requires");
        localVector.add("IsRequiredBy");
        return localVector;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private RelationRules() {
    }
}

