/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequirementRules
extends MetadataUtil {
    private String elemNum;
    private Node requirementNode;
    private String valueOfType;
    private boolean typeNotUsed = true;

    public RequirementRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("RequirementRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.requirementNode = paramNode;
        this.elemNum = paramString;
        this.valueOfType = "";
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("element " + this.elemNum + " (requirement) has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int i4;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = true;
        boolean n = false;
        boolean i1 = false;
        boolean i2 = false;
        boolean i3 = false;
        NodeList localNodeList = this.requirementNode.getChildNodes();
        Node localNode = this.requirementNode;
        for (i4 = 0; i4 < localNodeList.getLength(); ++i4) {
            int i5;
            localNode = localNodeList.item(i4);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("type")) {
                if (!n) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <type>...");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <type> for " + "multiplicity...");
                    i5 = this.getMultiplicityUsed(this.requirementNode, str);
                    if (i5 > 1) {
                        this.setMessage(MessageType.FAILED, "RequirementRules::verifyAssetOptional()", "More than 1 <type> element was found...0 or 1 allowed");
                        i = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "RequirementRules::verifyAssetOptional()", "0 or 1 <type> element was found");
                        if (!this.verifyType(localNode)) {
                            i = false;
                        }
                    }
                }
                n = true;
                this.typeNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("name")) {
                if (!i1) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <name>...");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <name> for " + "multiplicity...");
                    i5 = this.getMultiplicityUsed(this.requirementNode, str);
                    if (i5 > 1) {
                        this.setMessage(MessageType.FAILED, "RequirementRules::verifyAssetOptional()", "More than 1 <name> element was found...0 or 1 allowed");
                        j = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "RequirementRules::verifyAssetOptional()", "0 or 1 <name> element was found");
                        if (!this.verifyName(localNode)) {
                            j = false;
                        }
                    }
                }
                i1 = true;
                continue;
            }
            if (str.equalsIgnoreCase("minimumversion")) {
                if (!i2) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <minimumversion>...");
                    this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <minimumversion> for multiplicity...");
                    i5 = this.getMultiplicityUsed(this.requirementNode, str);
                    if (i5 > 1) {
                        this.setMessage(MessageType.FAILED, "RequirementRules::verifyAssetOptional()", "More than 1 <minimumversion> element was found...0 or 1 allowed");
                        k = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "RequirementRules::verifyAssetOptional()", "0 or 1 <minimumversion> element was found");
                        if (!this.verifyMinimumversion(localNode, this.elemNum + ".3")) {
                            k = false;
                        }
                    }
                }
                i2 = true;
                continue;
            }
            if (!str.equalsIgnoreCase("maximumversion")) continue;
            if (!i3) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".4 <maximumversion>...");
                this.setMessage(MessageType.INFO, "RequirementRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".4 <maximumversion> for multiplicity...");
                i5 = this.getMultiplicityUsed(this.requirementNode, str);
                if (i5 > 1) {
                    this.setMessage(MessageType.FAILED, "RequirementRules::verifyAssetOptional()", "More than 1 <maximumversion> element was found...0 or 1 allowed");
                    m = false;
                } else {
                    this.setMessage(MessageType.PASSED, "RequirementRules::verifyAssetOptional()", "0 or 1 <maximumversion> element was found");
                    if (!this.verifyMaximumversion(localNode, this.elemNum + ".4")) {
                        m = false;
                    }
                }
            }
            i3 = true;
        }
        if (DebugIndicator.ON) {
            i4 = i && j && k && m ? 1 : 0;
            System.out.println("returning ->" + i4);
        }
        return i && j && k && m;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyType(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = this.buildVocabType();
        bool1 = this.verifyVocabulary(paramNode, localVector, "type", bool2);
        return bool1;
    }

    private boolean verifyName(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = false;
        Vector localVector = new Vector();
        String str = this.getvalueOfType();
        localVector = str.equalsIgnoreCase("Operating System") ? this.buildVocabNameOS() : (str.equalsIgnoreCase("Browser") ? this.buildVocabNameBrowser() : this.buildVocabNameOther());
        bool1 = this.verifyVocabulary(paramNode, localVector, "name", bool2);
        return bool1;
    }

    private boolean verifyMinimumversion(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 30;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "RequirementRules::verifyMinimumversion()", "No data was found in element <minimumversion> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "RequirementRules::verifyMinimumversion()", "Testing text of element " + paramString + " <minimumversion> for character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1<= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "RequirementRules::verifyMinimumversion()", "The text contained in element " + paramString + " <minimumversion> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "RequirementRules::verifyMinimumversion()", "No text was found in element " + paramString + " <minimumversion> and fails the minimum " + "character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "RequirementRules::verifyMinimumversion()", "Character length for element " + paramString + " <minimumversion> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "RequirementRules::verifyMinimumversion()", "Too many text strings were found in <minimumversion> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifyMaximumversion(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 30;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "RequirementRules::verifyMaximumversion()", "No data was found in element <maximumversion> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "RequirementRules::verifyMaximumversion()", "Testing text of element " + paramString + " <maximumversion> for character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1<= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "RequirementRules::verifyMaximumversion()", "The text contained in element " + paramString + " <maximumversion> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "RequirementRules::verifyMaximumversion()", "No text was found in element " + paramString + " <maximumversion> and fails the minimum " + "character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "RequirementRules::verifyMaximumversion()", "Character length for element  <maximumversion> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "RequirementRules::verifyMaximumversion()", "Too many text strings were found in <maximumversion> and fails the test");
            }
        }
        return i > 0;
    }

    private Vector buildVocabType() {
        Vector<String> localVector = new Vector<String>(2);
        localVector.add("Operating System");
        localVector.add("Browser");
        return localVector;
    }

    private Vector buildVocabNameOS() {
        Vector<String> localVector = new Vector<String>(7);
        localVector.add("PC-DOS");
        localVector.add("MS-Windows");
        localVector.add("MacOS");
        localVector.add("Unix");
        localVector.add("Multi-OS");
        localVector.add("Other");
        localVector.add("None");
        return localVector;
    }

    private Vector buildVocabNameBrowser() {
        Vector<String> localVector = new Vector<String>(4);
        localVector.add("Any");
        localVector.add("Netscape Communicator");
        localVector.add("Microsoft Internet Explorer");
        localVector.add("Opera");
        return localVector;
    }

    private Vector buildVocabNameOther() {
        Vector<String> localVector = new Vector<String>(1);
        localVector.add(" ");
        return localVector;
    }

    private RequirementRules() {
    }
}

