/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import java.util.Vector;
import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RightsRules
extends MetadataUtil {
    private String elemNum;
    private Node rightsNode;
    private boolean optionalNotUsed = true;

    public RightsRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("RightsRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.rightsNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        int n;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        NodeList localNodeList = this.rightsNode.getChildNodes();
        Node localNode = this.rightsNode;
        for (n = 0; n < localNodeList.getLength(); ++n) {
            int i1;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("cost")) {
                if (k) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <cost>...");
                this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <cost> for multiplicity...");
                i1 = this.getMultiplicityUsed(this.rightsNode, str);
                if (i1 > 1) {
                    this.setMessage(MessageType.FAILED, "RightsRules::verifyAssetMandatory()", "More than 1 <cost> element was found .. 1 and only 1 allowed");
                    i = false;
                } else if (i1 == 1) {
                    this.setMessage(MessageType.PASSED, "RightsRules::verifyAssetMandatory()", "1 and only 1 <cost> element was found");
                    if (!this.verifyCost(localNode)) {
                        i = false;
                    }
                }
                k = true;
                continue;
            }
            if (!str.equalsIgnoreCase("copyrightandotherrestrictions") || m) continue;
            this.setMessage(MessageType.OTHER, "", "");
            this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".2 <copyrightandotherrestrictions>...");
            this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".2 <copyrightandotherrestrictions> for " + "multiplicity...");
            i1 = this.getMultiplicityUsed(this.rightsNode, str);
            if (i1 > 1) {
                this.setMessage(MessageType.FAILED, "RightsRules::verifyAssetMandatory()", "More than 1 <copyrightandotherrestrictions> element was found .. 1 and only 1 allowed");
                j = false;
            } else if (i1 == 1) {
                this.setMessage(MessageType.PASSED, "RightsRules::verifyAssetMandatory()", "1 and only 1 <copyrightandotherrestrictions> element was found");
                if (!this.verifyCopyrightandotherrestrictions(localNode)) {
                    j = false;
                }
            }
            m = true;
        }
        if (!k) {
            this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <cost> for " + "multiplicity...");
            this.setMessage(MessageType.FAILED, "RightsRules::verifyAssetMandatory()", "Element " + this.elemNum + ".1 <cost> was not found and " + "must appear 1 and only 1 time");
        }
        if (!m) {
            this.setMessage(MessageType.INFO, "RightsRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".2 <copyrightandotherrestrictions> for multiplicity...");
            this.setMessage(MessageType.FAILED, "RightsRules::verifyAssetMandatory()", "Element " + this.elemNum + ".2 <copyrightandotherrestrictions> was not found and " + "must appear 1 and only 1 time");
        }
        if (DebugIndicator.ON) {
            n = i && j && k && m ? 1 : 0;
            System.out.println("returning ->" + n);
        }
        return i && j && k && m;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        boolean bool = true;
        boolean i = false;
        NodeList localNodeList = this.rightsNode.getChildNodes();
        Node localNode = this.rightsNode;
        for (int j = 0; j < localNodeList.getLength(); ++j) {
            String str;
            localNode = localNodeList.item(j);
            if (localNode.getNodeType() != 1 || !(str = localNode.getLocalName()).equalsIgnoreCase("description")) continue;
            if (!i) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "RightsRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description>...");
                this.setMessage(MessageType.INFO, "RightsRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".3 <description> for multiplicity...");
                int k = this.getMultiplicityUsed(this.rightsNode, str);
                if (k > 1) {
                    this.setMessage(MessageType.FAILED, "GeneralRulesRules::verifyAssetOptional()", "More than 1 <description> element was found .. 0 or 1 allowed");
                    bool = false;
                } else if (k == 1) {
                    this.setMessage(MessageType.PASSED, "RightsRules::verifyAssetOptional()", "0 or 1 <description> element was found");
                    if (!this.verifyDescription(localNode, this.elemNum + ".3")) {
                        bool = false;
                    }
                }
                i = true;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            System.out.println("returning ->" + bool);
        }
        return bool;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyCost(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = true;
        Vector localVector = this.buildVocabCost();
        bool1 = this.verifyVocabulary(paramNode, localVector, "cost", bool2);
        return bool1;
    }

    private boolean verifyCopyrightandotherrestrictions(Node paramNode) {
        boolean bool1 = true;
        boolean bool2 = true;
        Vector localVector = this.buildVocabCopyrightandotherrestrictions();
        bool1 = this.verifyVocabulary(paramNode, localVector, "copyrightandotherrestrictions", bool2);
        return bool1;
    }

    private boolean verifyDescription(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<description>", paramString, 1000);
        return bool;
    }

    private Vector buildVocabCost() {
        Vector<String> localVector = new Vector<String>(2);
        localVector.add("yes");
        localVector.add("no");
        return localVector;
    }

    private Vector buildVocabCopyrightandotherrestrictions() {
        Vector<String> localVector = new Vector<String>(2);
        localVector.add("yes");
        localVector.add("no");
        return localVector;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private RightsRules() {
    }
}

