/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaxonpathRules
extends MetadataUtil {
    private String elemNum;
    private Node taxonpathNode;
    private boolean optionalNotUsed = true;

    public TaxonpathRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("TaxonpathRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.taxonpathNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        if (DebugIndicator.ON) {
            System.out.println("element " + this.elemNum + " <taxonpath> has no " + "mandatory sub-elements");
        }
        return false;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int n;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        NodeList localNodeList = this.taxonpathNode.getChildNodes();
        Node localNode = this.taxonpathNode;
        for (n = 0; n < localNodeList.getLength(); ++n) {
            int i1;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("source")) {
                if (!k) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <source>...");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".1 <source> for multiplicity...");
                    i1 = this.getMultiplicityUsed(this.taxonpathNode, str);
                    if (i1 > 1) {
                        this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyAssetOptional()", "More than 1 <source> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i1 == 1) {
                        this.setMessage(MessageType.PASSED, "TaxonpathRules::verifyAssetOptional()", "0 or 1 <source> element was found");
                        if (!this.verifySource(localNode, this.elemNum + ".1")) {
                            i = false;
                        }
                    }
                    k = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("taxon")) continue;
            if (!m) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "TaxonpathRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <taxon>...");
                this.setMessage(MessageType.INFO, "TaxonpathRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <taxon> for " + "multiplicity...");
                i1 = this.getTaxonMultiplicityUsed(this.taxonpathNode, str);
                if (DebugIndicator.ON) {
                    System.out.println("TAXONCOUNT value is " + i1);
                }
                if (i1 > 15) {
                    this.setMessage(MessageType.WARNING, "TaxonpathRules::verifyAssetOptional()", "More than 15 <taxon> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "TaxonpathRules::verifyAssetOptional()", "15 or less <taxon> elements were found");
                }
                m = true;
            }
            if (!this.verifyTaxon(localNode, this.elemNum + ".2")) {
                j = false;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            n = i && j ? 1 : 0;
            System.out.println("returning ->" + n);
        }
        return i && j;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifySource(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<source>", paramString, 1000);
        return bool;
    }

    public boolean verifyTaxon(Node paramNode, String paramString) {
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        boolean n = false;
        boolean i1 = true;
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        for (int i2 = 0; i2 < localNodeList.getLength(); ++i2) {
            int i3;
            localNode = localNodeList.item(i2);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("id")) {
                if (!k) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyTaxon()", "Testing element " + paramString + ".1 <id>...");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyTaxon()", "Testing element " + paramString + ".1 <id> for multiplicity...");
                    i3 = this.getMultiplicityUsed(paramNode, str);
                    if (i3 > 1) {
                        this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyTaxon()", "More than 1 <id> element was found .. 0 or 1 allowed");
                        i = false;
                    } else if (i3 == 1) {
                        this.setMessage(MessageType.PASSED, "TaxonpathRules::verifyTaxon()", "0 or 1 <id> element was found");
                        if (!this.verifyId(localNode, paramString + ".1")) {
                            i = false;
                        }
                    }
                    k = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("entry")) {
                if (!m) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyTaxon()", "Testing element " + paramString + ".2 <entry>...");
                    this.setMessage(MessageType.INFO, "TaxonpathRules::verifyTaxon()", "Testing element " + paramString + ".2 <entry> for multiplicity...");
                    i3 = this.getMultiplicityUsed(paramNode, str);
                    if (i3 > 1) {
                        this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyTaxon()", "More than 1 <entry> element was found .. 0 or 1 allowed");
                        j = false;
                    } else if (i3 == 1) {
                        this.setMessage(MessageType.PASSED, "TaxonpathRules::verifyTaxon()", "0 or 1 <entry> element was found");
                        if (!this.verifyEntry(localNode, paramString + ".2")) {
                            j = false;
                        }
                    }
                    m = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("taxon")) continue;
            if (!n) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "TaxonpathRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <taxon>...");
                n = true;
            }
            if (!this.verifyTaxon(localNode, this.elemNum + ".2")) {
                i1 = false;
            }
            this.optionalNotUsed = false;
        }
        return i && j && i1;
    }

    private boolean verifyId(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 100;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyId()", "No data was found in element <id> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "TaxonpathRules::verifyId()", "Testing text of element " + paramString + " <id> for character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1>= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "TaxonpathRules::verifyId()", "The text contained in element " + paramString + " <id> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyId()", "No text was found in element " + paramString + " <id> and fails the minimum character " + "length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "TaxonpathRules::verifyId()", "Character length for element  <id> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "TaxonpathRules::verifyId()", "Too many text strings were found in <id> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifyEntry(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<entry>", paramString, 500);
        return bool;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private TaxonpathRules() {
    }
}

