/*
 * Decompiled with CFR 0.152.
 */
package org.adl.testsuite.metadata.rules;

import org.adl.testsuite.metadata.MetadataUtil;
import org.adl.testsuite.metadata.rules.DatetypeRules;
import org.adl.testsuite.metadata.rules.RequirementRules;
import org.adl.util.MessageType;
import org.adl.util.debug.DebugIndicator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TechnicalRules
extends MetadataUtil {
    private String elemNum;
    private Node technicalNode;
    private boolean optionalNotUsed = true;

    public TechnicalRules(Node paramNode, String paramString) {
        if (DebugIndicator.ON) {
            System.out.println("/////////////////////////////////");
            System.out.println("TechnicalRules() called");
            System.out.println("/////////////////////////////////");
        }
        this.technicalNode = paramNode;
        this.elemNum = paramString;
    }

    public boolean verifyAssetMandatory() {
        int n;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        NodeList localNodeList = this.technicalNode.getChildNodes();
        Node localNode = this.technicalNode;
        for (n = 0; n < localNodeList.getLength(); ++n) {
            int i1;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("format")) {
                if (k) continue;
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <format>...");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <format> for multiplicity...");
                i1 = this.getMultiplicityUsed(this.technicalNode, str);
                if (i1 > 40) {
                    this.setMessage(MessageType.WARNING, "TechnicalRules::verifyAssetMandatory()", "More than 40 <format> elements were found");
                    if (!this.verifyFormat(localNode, this.elemNum + ".1")) {
                        i = false;
                    }
                } else {
                    this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetMandatory()", "40 or less <format> elements were found");
                    if (!this.verifyFormat(localNode, this.elemNum + ".1")) {
                        i = false;
                    }
                }
                k = true;
                continue;
            }
            if (!str.equalsIgnoreCase("location")) continue;
            if (!m) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".3 <location>...");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".3 <location> for multiplicity...");
                i1 = this.getMultiplicityUsed(this.technicalNode, str);
                if (i1 > 10) {
                    this.setMessage(MessageType.WARNING, "TechnicalRules::verifyAssetMandatory()", "More than 10 <location> elements were found");
                } else {
                    this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetMandatory()", "10 or less <location> elements were found");
                }
                m = true;
            }
            if (this.verifyLocation(localNode, this.elemNum + ".3")) continue;
            j = false;
        }
        if (!k) {
            this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".1 <format> for multiplicity...");
            this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetMandatory()", "Element " + this.elemNum + ".1 <format> was not found and " + "must appear 1 or more times");
        }
        if (!m) {
            this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetMandatory()", "Testing element " + this.elemNum + ".3 <location> for multiplicity...");
            this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetMandatory()", "element " + this.elemNum + ".3 <location> was not found and " + "must appear 1 or more times");
        }
        if (DebugIndicator.ON) {
            n = i && j && k && m ? 1 : 0;
            System.out.println("returning ->" + n);
        }
        return i && j && k && m;
    }

    public boolean verifyScoMandatory() {
        return this.verifyAssetMandatory();
    }

    public boolean verifyCaMandatory() {
        return this.verifyScoMandatory();
    }

    public boolean verifyAssetOptional() {
        int i6;
        boolean i = true;
        boolean j = true;
        boolean k = true;
        boolean m = true;
        boolean n = true;
        boolean i1 = false;
        boolean i2 = false;
        boolean i3 = false;
        boolean i4 = false;
        boolean i5 = false;
        boolean bool = true;
        NodeList localNodeList = this.technicalNode.getChildNodes();
        Node localNode = this.technicalNode;
        for (i6 = 0; i6 < localNodeList.getLength(); ++i6) {
            int i7;
            localNode = localNodeList.item(i6);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("size")) {
                if (!i1) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".2 <size>...");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element 4.2 <size> for multiplicity...");
                    i7 = this.getMultiplicityUsed(this.technicalNode, str);
                    if (i7 > 1) {
                        this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetOptional()", "More than 1 <size> element was found...0 or 1 allowed");
                        i = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetOptional()", "0 or 1 <size> element was found");
                        if (!this.verifySize(localNode, this.elemNum + ".2")) {
                            i = false;
                        }
                    }
                    i1 = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("requirement")) {
                RequirementRules localRequirementRules;
                if (!i2) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".4 <requirement>...");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".4 <requirement> for multiplicity...");
                    i7 = this.getMultiplicityUsed(this.technicalNode, str);
                    if (i7 > 40) {
                        this.setMessage(MessageType.WARNING, "TechnicalRules::verifyAssetOptional()", "More than 40 <requirement> elements were found");
                    } else {
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetOptional()", "40 or less <requirement> elements were found");
                    }
                    i2 = true;
                }
                if (!(bool = (localRequirementRules = new RequirementRules(localNode, this.elemNum + ".4")).verifyAssetOptional())) {
                    j = false;
                }
                this.appendMessages(localRequirementRules.getMessages());
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("installationremarks")) {
                if (!i3) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".5 <installationremarks>...");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".5 <installationremarks> for multiplicity...");
                    int i8 = this.getMultiplicityUsed(this.technicalNode, str);
                    if (i8 > 1) {
                        this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetOptional()", "More than 1 <installationremarks> element was found...0 or 1 allowed");
                        k = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetOptional()", "0 or 1 <installationremarks> element was found");
                        if (!this.verifyInstallationremarks(localNode, this.elemNum + ".5")) {
                            k = false;
                        }
                    }
                    i3 = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (str.equalsIgnoreCase("otherplatformrequirements")) {
                if (!i4) {
                    this.setMessage(MessageType.OTHER, "", "");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".6 <otherplatformrequirements>...");
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".6 <otherplatformrequirements> for " + "multiplicity...");
                    int i8 = this.getMultiplicityUsed(this.technicalNode, str);
                    if (i8 > 1) {
                        this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetOptional()", "More than 1 <otherplatformrequirements> element was found...0 or 1 allowed");
                        m = false;
                    } else {
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetOptional()", "0 or 1 <otherplatformrequirements> element was found");
                        if (!this.verifyOtherplatformrequirements(localNode, this.elemNum + ".6")) {
                            m = false;
                        }
                    }
                    i4 = true;
                }
                this.optionalNotUsed = false;
                continue;
            }
            if (!str.equalsIgnoreCase("duration")) continue;
            if (!i5) {
                this.setMessage(MessageType.OTHER, "", "");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".7 <duration>...");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyAssetOptional()", "Testing element " + this.elemNum + ".7 <duration> for multiplicity...");
                int i8 = this.getMultiplicityUsed(this.technicalNode, str);
                if (i8 > 1) {
                    this.setMessage(MessageType.FAILED, "TechnicalRules::verifyAssetOptional()", "More than 1 <duration> element was found...0 or 1 allowed");
                    n = false;
                } else {
                    this.setMessage(MessageType.PASSED, "TechnicalRules::verifyAssetOptional()", "0 or 1 <duration> element was found");
                    if (!this.verifyDuration(localNode, this.elemNum + ".7")) {
                        n = false;
                    }
                }
                i5 = true;
            }
            this.optionalNotUsed = false;
        }
        if (DebugIndicator.ON) {
            i6 = i && j && k && m && n ? 1 : 0;
            System.out.println("returning ->" + i6);
        }
        return i && j && k && m && n;
    }

    public boolean verifyScoOptional() {
        return this.verifyAssetOptional();
    }

    public boolean verifyCaOptional() {
        return this.verifyScoOptional();
    }

    private boolean verifyFormat(Node paramNode, String paramString) {
        int i = 1;
        int j = 500;
        int k = 0;
        String str1 = new String();
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        String str2 = new String();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++k;
            }
            if (k == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "TechnicalRules::verifyFormat()", "No data was found in element <format> and fails the minimum character length test");
            } else {
                if (k == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "TechnicalRules::verifyFormat()", "Testing element " + paramString + " <format> for " + "character length...");
                        str1 = this.getTaggedData(paramNode);
                        if (DebugIndicator.ON) {
                            System.out.println("1<= " + str1.length() + " <= " + j);
                        }
                        if (str1.length() > j) {
                            this.setMessage(MessageType.WARNING, "TechnicalRules::verifyFormat()", "The text contained in element " + paramString + " <format> is greater than " + j);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "TechnicalRules::verifyFormat()", "No text was found in element " + paramString + " <format> and fails the minimum " + "character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyFormat()", "Character length for element " + paramString + " <format> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + k + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "GeneralRules::verifyLanguage()", "Too many text strings were found in <language> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifySize(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 30;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "No data was found in element <size> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        this.setMessage(MessageType.INFO, "TechnicalRules::verifySize()", "Testing element " + paramString + " <size> for " + "digital resource in bytes...");
                        str1 = this.getTaggedData(paramNode);
                        try {
                            Long localLong = new Long(str1);
                            if (localLong.compareTo(new Long("0")) < 0) {
                                this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "Text in element " + paramString + " <size> " + "was not a byte and fails the digital " + "resource in bytes test");
                                this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "value = " + str1);
                                i = 0;
                            }
                        }
                        catch (NumberFormatException localNumberFormatException) {
                            this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "Text in element " + paramString + " <size> " + "was not a byte and fails the digital " + "resource in bytes test");
                            this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "value = " + str1);
                            i = 0;
                        }
                        if (i != 0) {
                            this.setMessage(MessageType.PASSED, "TechnicalRules::verifySize()", "Digital resource in bytes for element " + paramString + " <size> has been verified");
                        }
                        this.setMessage(MessageType.INFO, "TechnicalRules::verifySize()", "Testing element " + paramString + " <size> for " + "character length...");
                        if (DebugIndicator.ON) {
                            System.out.println("1>= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "TechnicalRules::verifySize()", "The text contained in element " + paramString + " <size> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "No text was found in element " + paramString + " <size> and fails the minimum character " + "length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifySize()", "Character length for element  <size> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "TechnicalRules::verifySize()", "Too many text strings were found in <size> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifyLocation(Node paramNode, String paramString) {
        int i = 1;
        String str1 = new String();
        String str2 = new String();
        int j = 0;
        int k = 1000;
        Node localNode = paramNode;
        NodeList localNodeList = paramNode.getChildNodes();
        if (localNodeList != null) {
            int m;
            for (m = 0; m < localNodeList.getLength(); ++m) {
                localNode = localNodeList.item(m);
                if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                ++j;
            }
            if (j == 0) {
                i = 0;
                this.setMessage(MessageType.FAILED, "TechnicalRules::verifyLocation()", "No data was found in element <location> and fails the minimum character length test");
            } else {
                if (j == 1) {
                    for (m = 0; m < localNodeList.getLength(); ++m) {
                        localNode = localNodeList.item(m);
                        if (localNode.getNodeType() != 3 && localNode.getNodeType() != 4) continue;
                        str1 = this.getTaggedData(paramNode);
                        this.setMessage(MessageType.INFO, "TechnicalRules::verifyLocation()", "Testing text of element " + paramString + " <location> for character length...");
                        if (DebugIndicator.ON) {
                            System.out.println("1<= " + str1.length() + " <= " + k);
                        }
                        if (str1.length() > k) {
                            this.setMessage(MessageType.WARNING, "TechnicalRules::verifyLocation()", "The text contained in element " + paramString + " <location> is greater than " + k);
                            continue;
                        }
                        if (str1.length() < 1) {
                            i = 0;
                            this.setMessage(MessageType.FAILED, "TechnicalRules::verifyLocation()", "No text was found in element " + paramString + " <location> and fails the minimum " + "character length test");
                            continue;
                        }
                        this.setMessage(MessageType.PASSED, "TechnicalRules::verifyLocation()", "Character length for element  <location> has been verified");
                    }
                }
                i = 0;
                if (DebugIndicator.ON) {
                    System.out.println("There were " + j + " TEXT_NODE elements found");
                }
                this.setMessage(MessageType.FAILED, "TechnicalRules::verifyLocation()", "Too many text strings were found in <location> and fails the test");
            }
        }
        return i > 0;
    }

    private boolean verifyInstallationremarks(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "<installationremarks>", "4.5", 1000);
        return bool;
    }

    private boolean verifyOtherplatformrequirements(Node paramNode, String paramString) {
        boolean bool = true;
        bool = this.verifyLangstring(paramNode, "otherplatformrequirements", "4.6", 1000);
        return bool;
    }

    private boolean verifyDuration(Node paramNode, String paramString) {
        boolean bool = true;
        boolean i = true;
        boolean j = true;
        boolean k = false;
        boolean m = false;
        this.setMessage(MessageType.INFO, "TechnicalRules::verifyTypicallearningtime()", "Testing element " + paramString + " <duration> for " + "element <datetime>...");
        NodeList localNodeList = paramNode.getChildNodes();
        Node localNode = paramNode;
        for (int n = 0; n < localNodeList.getLength(); ++n) {
            DatetypeRules localDatetypeRules;
            localNode = localNodeList.item(n);
            if (localNode.getNodeType() != 1) continue;
            String str = localNode.getLocalName();
            if (str.equalsIgnoreCase("datetime")) {
                if (!k) {
                    this.setMessage(MessageType.INFO, "TechnicalRules::verifyTypicallearningtime()", "Testing element <datetime> for multiplicity...");
                    this.setMessage(MessageType.PASSED, "TechnicalRules::verifyTypicallearningtime()", "Element <datetime> existed 1 and only 1 time");
                    k = true;
                }
                if (!(bool = (localDatetypeRules = new DatetypeRules(localNode)).verifyDatetime())) {
                    i = false;
                }
                this.appendMessages(localDatetypeRules.getMessages());
                continue;
            }
            if (!str.equalsIgnoreCase("description")) continue;
            if (!m) {
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyTypicallearningtime()", "Testing element <description>...");
                this.setMessage(MessageType.INFO, "TechnicalRules::verifyTypicallearningtime()", "Testing element <description> for multiplicity...");
                this.setMessage(MessageType.PASSED, "TechnicalRules::verifyTypicallearningtime()", "Element <description> existed 0 or 1 time");
                m = true;
            }
            if (!(bool = (localDatetypeRules = new DatetypeRules(localNode)).verifyDescription())) {
                j = false;
            }
            this.appendMessages(localDatetypeRules.getMessages());
        }
        if (!k) {
            this.setMessage(MessageType.INFO, "TechnicalRules::verifyRole()", "Testing element <datetime> for multiplicity...");
            this.setMessage(MessageType.FAILED, "TechnicalRules::verifyRole()", "Element <datetime> was not found and must appear 1 and only 1 time");
        }
        return j && i;
    }

    public boolean getOptionalNotUsed() {
        return this.optionalNotUsed;
    }

    private TechnicalRules() {
    }
}

