/*
 * Decompiled with CFR 0.152.
 */
package net.parim.icourse163.sdk.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import net.parim.icourse163.sdk.callback.SdkResult;
import net.parim.icourse163.sdk.config.SdkConfiguration;
import net.parim.icourse163.sdk.model.Term;
import net.parim.icourse163.sdk.model.TermCourse;
import net.parim.icourse163.sdk.model.VideoSign;
import net.parim.icourse163.sdk.util.HttpUtils;
import net.parim.icourse163.sdk.util.ParamUtil;
import net.parim.icourse163.sdk.util.SignatureUtil;

public class CourseTermApi {
    public SdkResult getSpocTermPage(Integer pageSize, Integer pageIndex, Integer progress, Integer publishStatus) {
        String url = SdkConfiguration.getServerHost() + "/open/terms?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("pageSize", String.valueOf(pageSize));
        paramMap.put("pageIndex", String.valueOf(pageIndex));
        paramMap.put("progress", String.valueOf(progress));
        paramMap.put("publishStatus", String.valueOf(publishStatus));
        HttpUtils httpUtils = HttpUtils.getInstance();
        String json = httpUtils.doGet(url, paramMap);
        JSONObject jsonObject = JSON.parseObject((String)json);
        SdkResult<List> sdkResult = new SdkResult<List>();
        if (jsonObject.get((Object)"code").equals(200)) {
            String result = JSON.parseObject((String)json).getString("result");
            String list = JSON.parseObject((String)result).getString("list");
            List terms = JSON.parseArray((String)list, Term.class);
            sdkResult.setCode(200);
            sdkResult.setResult("\u6210\u529f");
            sdkResult.setData(terms);
        } else {
            JSONObject jsonObject1 = JSON.parseObject((String)json);
            sdkResult.setCode(jsonObject1.getInteger("code"));
            sdkResult.setResult(jsonObject1.getString("result"));
        }
        return sdkResult;
    }

    public SdkResult<TermCourse> getTermStructure(Long termId) {
        String url = SdkConfiguration.getServerHost() + "/mm-open-api/open/term/structure?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("termId", String.valueOf(termId));
        HttpUtils httpUtils = HttpUtils.getInstance();
        String json = httpUtils.doGet(url, paramMap);
        JSONObject jsonObject = JSON.parseObject((String)json);
        SdkResult<TermCourse> sdkResult = new SdkResult<TermCourse>();
        if (jsonObject.get((Object)"code").equals(200)) {
            String result = JSON.parseObject((String)json).getString("result");
            TermCourse termCourse = (TermCourse)JSON.parseObject((String)result, TermCourse.class);
            sdkResult.setCode(200);
            sdkResult.setResult("\u6210\u529f");
            sdkResult.setData(termCourse);
        } else {
            JSONObject jsonObject1 = JSON.parseObject((String)json);
            sdkResult.setCode(jsonObject1.getInteger("code"));
            sdkResult.setResult(jsonObject1.getString("result"));
        }
        return sdkResult;
    }

    public SdkResult<VideoSign> getSignByVideoId(Long videoId) {
        String url = SdkConfiguration.getServerHost() + "/mm-open-api/open/video/videoSign?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("videoId", String.valueOf(videoId));
        HttpUtils httpUtils = HttpUtils.getInstance();
        String json = httpUtils.doGet(url, paramMap);
        JSONObject jsonObject = JSON.parseObject((String)json);
        SdkResult<VideoSign> sdkResult = new SdkResult<VideoSign>();
        if (jsonObject.get((Object)"code").equals(200)) {
            String result = JSON.parseObject((String)json).getString("result");
            VideoSign videoSign = (VideoSign)JSON.parseObject((String)result, VideoSign.class);
            sdkResult.setCode(200);
            sdkResult.setResult("\u6210\u529f");
            sdkResult.setData(videoSign);
        } else {
            JSONObject jsonObject1 = JSON.parseObject((String)json);
            sdkResult.setCode(jsonObject1.getInteger("code"));
            sdkResult.setResult(jsonObject1.getString("result"));
        }
        return sdkResult;
    }
}

