/*
 * Decompiled with CFR 0.152.
 */
package net.parim.icourse163.sdk.api;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import net.parim.icourse163.sdk.callback.SdkResult;
import net.parim.icourse163.sdk.config.SdkConfiguration;
import net.parim.icourse163.sdk.model.LoginRequestParam;
import net.parim.icourse163.sdk.util.AESUtils;
import net.parim.icourse163.sdk.util.HttpUtils;
import net.parim.icourse163.sdk.util.ParamUtil;
import net.parim.icourse163.sdk.util.SignatureUtil;

public class LoginApi {
    public SdkResult loginAndReg(boolean nm, LoginRequestParam loginRequestParam) {
        String paramStr = JSON.toJSONString((Object)loginRequestParam);
        String value = AESUtils.encrypt2Str(paramStr, SdkConfiguration.getAesKey());
        String surl = SdkConfiguration.getServerHost() + "/api/account/login2site.do?";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appId", SdkConfiguration.getAppId());
        params.put("nm", String.valueOf(nm));
        params.put("value", value);
        HttpUtils httpUtils = HttpUtils.getInstance();
        String get = httpUtils.doGet(surl, params);
        return (SdkResult)JSON.parseObject((String)get, SdkResult.class);
    }

    public SdkResult logout(String openUid) {
        String url = SdkConfiguration.getServerHost() + "/open/logout?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("openUid", openUid);
        HttpUtils httpUtils = HttpUtils.getInstance();
        String get = httpUtils.doGet(url, paramMap);
        return (SdkResult)JSON.parseObject((String)get, SdkResult.class);
    }

    public SdkResult CheckEncrypt(String encryptContent) {
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        String url = SdkConfiguration.getServerHost() + "/mm-open-api/open/decrypt";
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("encryptContent", encryptContent);
        HttpUtils httpUtils = HttpUtils.getInstance();
        String result = httpUtils.getForm(url, paramMap);
        SdkResult sdkResult = (SdkResult)JSON.parseObject((String)result, SdkResult.class);
        if (sdkResult.getCode().equals(0)) {
            sdkResult.setCode(200);
        }
        return sdkResult;
    }

    public SdkResult unbind(String encryptLoginId) {
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        String url = SdkConfiguration.getServerHost() + "/mm-open-api/open/account/unbind";
        String s1 = AESUtils.encrypt2Str(encryptLoginId, SdkConfiguration.getAesKey());
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("encryptLoginId", s1);
        HttpUtils httpUtils = HttpUtils.getInstance();
        String result = httpUtils.getForm(url, paramMap);
        SdkResult sdkResult = (SdkResult)JSON.parseObject((String)result, SdkResult.class);
        if (sdkResult.getCode().equals(0)) {
            sdkResult.setCode(200);
        }
        return sdkResult;
    }
}

