/*
 * Decompiled with CFR 0.152.
 */
package net.parim.icourse163.sdk.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import net.parim.icourse163.sdk.callback.SdkResult;
import net.parim.icourse163.sdk.config.SdkConfiguration;
import net.parim.icourse163.sdk.model.MOOCCourse;
import net.parim.icourse163.sdk.util.HttpUtils;
import net.parim.icourse163.sdk.util.ParamUtil;
import net.parim.icourse163.sdk.util.SignatureUtil;

public class MOOCApi {
    public SdkResult<List<MOOCCourse>> getTermMOOCClassroom(Long termId) {
        String url = SdkConfiguration.getServerHost() + "/open/term/classroom?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("termId", String.valueOf(termId));
        HttpUtils httpUtils = HttpUtils.getInstance();
        String json = httpUtils.doGet(url, paramMap);
        JSONObject jsonObject = JSON.parseObject((String)json);
        SdkResult<List<MOOCCourse>> sdkResult = new SdkResult<List<MOOCCourse>>();
        if (jsonObject.get((Object)"code").equals(200)) {
            String result = JSON.parseObject((String)json).getString("result");
            List moocCourses = JSON.parseArray((String)result, MOOCCourse.class);
            sdkResult.setCode(200);
            sdkResult.setResult("\u6210\u529f");
            sdkResult.setData(moocCourses);
        } else {
            JSONObject jsonObject1 = JSON.parseObject((String)json);
            sdkResult.setCode(jsonObject1.getInteger("code"));
            sdkResult.setResult(jsonObject1.getString("result"));
        }
        return sdkResult;
    }

    public SdkResult<MOOCCourse> getMOOCClassroomStatistic(Long classroomId) {
        String url = SdkConfiguration.getServerHost() + "/open/classroom/statistic?";
        long timestamp = System.currentTimeMillis();
        long nonce = SignatureUtil.getNonce(timestamp);
        String signature = SignatureUtil.signature(nonce, timestamp);
        HashMap<String, String> paramMap = ParamUtil.buildParam(signature, nonce, timestamp);
        paramMap.put("classroomId", String.valueOf(classroomId));
        HttpUtils httpUtils = HttpUtils.getInstance();
        String json = httpUtils.doGet(url, paramMap);
        JSONObject jsonObject = JSON.parseObject((String)json);
        SdkResult<MOOCCourse> sdkResult = new SdkResult<MOOCCourse>();
        if (jsonObject.get((Object)"code").equals(200)) {
            String result = JSON.parseObject((String)json).getString("result");
            MOOCCourse moocCourse = (MOOCCourse)JSON.parseObject((String)result, MOOCCourse.class);
            sdkResult.setCode(200);
            sdkResult.setResult("\u6210\u529f");
            sdkResult.setData(moocCourse);
        } else {
            JSONObject jsonObject1 = JSON.parseObject((String)json);
            sdkResult.setCode(jsonObject1.getInteger("code"));
            sdkResult.setResult(jsonObject1.getString("result"));
        }
        return sdkResult;
    }
}

