/*
 * Decompiled with CFR 0.152.
 */
package net.parim.icourse163.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.parim.icourse163.sdk.exceptions.SdkException;

public class HttpUtils {
    private final String CTYPE_FORM = "application/x-www-form-urlencoded;charset=utf-8";
    private final String CTYPE_JSON = "application/json; charset=utf-8";
    private final String CTYPE_TEXT = "text/html;charset=utf-8";
    private final String charset = "utf-8";
    private static HttpUtils instance = null;

    public static HttpUtils getInstance() {
        if (instance == null) {
            return new HttpUtils();
        }
        return instance;
    }

    public String postJson(String url, String jsonContent) {
        return this.doRequest("POST", url, jsonContent, 15000, 15000, "application/json; charset=utf-8", null);
    }

    public String doGet(String url, Map<String, String> params) {
        String s = this.buildQuery(params);
        url = url + s;
        return this.doRequest("GET", url, null, 15000, 15000, "text/html;charset=utf-8", null);
    }

    public String postForm(String url) {
        return this.doRequest("POST", url, "", 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null);
    }

    public String postForm(String url, Map<String, String> params) {
        return this.doRequest("POST", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null);
    }

    public String getForm(String url) {
        return this.doRequest("GET", url, "", 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null);
    }

    public String getForm(String url, Map<String, String> params) {
        return this.doRequest("GET", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null);
    }

    private String doRequest(String method, String url, String requestContent, int connectTimeout, int readTimeout, String ctype, Map<String, String> headerMap) {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), method, ctype, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (requestContent != null && !requestContent.trim().equals("")) {
                out = conn.getOutputStream();
                out.write(requestContent.getBytes("utf-8"));
            }
            rsp = this.getResponseAsString(conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SdkException("\u8bf7\u6c42\u51fa\u9519,url:" + url);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
            conn = null;
        }
        return rsp;
    }

    private HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return this.getStreamAsString(conn.getInputStream(), "utf-8", conn);
        }
        String msg = this.getStreamAsString(es, "utf-8", conn);
        if (msg.trim().equals("")) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStreamAsString(InputStream stream, String charset, HttpURLConnection conn) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String buildQuery(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            try {
                query.append(name).append("=").append(URLEncoder.encode(value, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SdkException("\u53c2\u6570\u8f6c\u7801\u5f02\u5e38\uff0c\u53c2\u6570\u4e3a\uff1a" + name);
            }
        }
        return query.toString();
    }

    private class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

