/*
 * Decompiled with CFR 0.152.
 */
package net.parim.icourse163.sdk.util;

import java.security.MessageDigest;
import net.parim.icourse163.sdk.config.SdkConfiguration;

public class SignatureUtil {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String signature(Long nonce, Long timestamp) {
        String signatureContent = SdkConfiguration.getAppSecret() + nonce + timestamp;
        return SignatureUtil.encode(signatureContent);
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(str.getBytes());
            return SignatureUtil.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long getNonce(Long timestamp) {
        int max = 100000;
        int min = 1;
        return timestamp + (long)((int)(Math.random() * (double)(max - min) + (double)min));
    }
}

