/*
 * Decompiled with CFR 0.152.
 */
package net.parim.pay.sdk.util.encrypt;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.parim.pay.sdk.util.encrypt.Base64;
import net.parim.pay.sdk.util.encrypt.RSA;

public class RSA2 {
    private static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";

    public static String sign(String content, String privateKey, String characterEncoding) {
        return RSA.sign(content, privateKey, SIGN_SHA256RSA_ALGORITHMS, characterEncoding);
    }

    public static String sign(String content, PrivateKey privateKey, String characterEncoding) {
        return RSA.sign(content, privateKey, SIGN_SHA256RSA_ALGORITHMS, characterEncoding);
    }

    public static boolean verify(String content, String sign, String publicKey, String characterEncoding) {
        return RSA.verify(content, sign, publicKey, SIGN_SHA256RSA_ALGORITHMS, characterEncoding);
    }

    public static boolean verify(String content, String sign, PublicKey publicKey, String characterEncoding) {
        return RSA.verify(content, sign, publicKey, SIGN_SHA256RSA_ALGORITHMS, characterEncoding);
    }

    public static String decrypt(String content, String privateKey, String characterEncoding) throws GeneralSecurityException, IOException {
        return RSA.decrypt(content, privateKey, characterEncoding);
    }

    public static PrivateKey getPrivateKey(String key) throws GeneralSecurityException {
        return RSA.getPrivateKey(key);
    }

    public static String encrypt(String content, String publicKey, String cipherAlgorithm, String characterEncoding) throws GeneralSecurityException, IOException {
        return Base64.encode(RSA.encrypt(content.getBytes(characterEncoding), RSA.getPublicKey(publicKey), 2048, 11, cipherAlgorithm));
    }
}

