/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.parim.common.config.Global;
import net.parim.common.utils.StringUtils;
import net.parim.common.web.interceptor.ThemeInterceptor;
import net.parim.system.entity.User;
import net.parim.system.security.UsernamePasswordToken;
import net.parim.system.service.AccountService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AuthenticateController {
    @Autowired
    private DefaultWebSecurityManager securityManager;
    @Autowired
    AccountService accountService;

    @RequestMapping(value={"/login", "${adminPath}/login"}, method={RequestMethod.GET})
    @ThemeInterceptor.UseTheme(value=false)
    public String login(Model model) {
        boolean openValidation = false;
        int loginFailTimes = 0;
        if ("enable".equals(Global.getConfig((String)"kaptcha.status")) && loginFailTimes >= 5) {
            openValidation = true;
        }
        model.addAttribute("openValidation", (Object)openValidation);
        return Global.getThemePath() + "login";
    }

    @RequestMapping(value={"/login", "${adminPath}/login"}, method={RequestMethod.POST})
    @ThemeInterceptor.UseTheme(value=false)
    public String loginFailed(Model model) {
        boolean openValidation = false;
        if ("enable".equals(Global.getConfig((String)"kaptcha.status"))) {
            openValidation = true;
        }
        model.addAttribute("openValidation", (Object)openValidation);
        return Global.getThemePath() + "login";
    }

    @RequestMapping(value={"/logout", "${adminPath}/logout"}, method={RequestMethod.GET})
    @ThemeInterceptor.UseTheme(value=false)
    public String logout(Model model) {
        return Global.getThemePath() + "login";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/login/ajax"})
    @ResponseBody
    public Map<String, Object> ajaxLogin(@RequestParam(value="username") String userName, @RequestParam(value="rememberMe", required=false, defaultValue="false") Boolean rememberMe, @RequestParam(value="code", required=false) String code, @RequestParam(value="password") String password, Model model, HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Boolean flag = false;
        String message = "\u9a8c\u8bc1\u7801\u9519\u8bef";
        if ("enable".equals(Global.getConfig((String)"kaptcha.status")) && !this.checkKaptchaCode(request, code)) {
            resultMap.put("result", flag);
            resultMap.put("message", message);
            return resultMap;
        }
        String host = StringUtils.getRemoteAddr((HttpServletRequest)request);
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
        Subject subject = SecurityUtils.getSubject();
        if (!subject.isAuthenticated()) {
            UsernamePasswordToken token = new UsernamePasswordToken(userName, password, rememberMe.booleanValue(), host, code, false);
            try {
                subject.login((AuthenticationToken)token);
                User user = this.accountService.findUserByUsername(userName);
                subject.getSession().setAttribute((Object)"userToken", (Object)user);
                flag = true;
                message = "\u767b\u5f55\u6210\u529f";
            }
            catch (UnknownAccountException ex) {
                message = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
            }
            catch (IncorrectCredentialsException ex) {
                message = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
            }
            catch (LockedAccountException ex) {
                message = "\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u8054\u7cfb";
            }
            catch (AuthenticationException ex) {
                message = "\u5176\u4ed6\u9519\u8bef";
            }
            finally {
                resultMap.put("result", flag);
                resultMap.put("message", message);
            }
        } else {
            resultMap.put("result", true);
            resultMap.put("message", "\u767b\u5f55\u6210\u529f");
        }
        return resultMap;
    }

    @RequestMapping(value={"/login/check"})
    @ResponseBody
    public String checkLoginStatus() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            return "true";
        }
        return "false";
    }

    @RequestMapping(value={"/login/check_code/ajax"})
    @ResponseBody
    public boolean checkKaptchaCode(HttpServletRequest request, @RequestParam(value="code", required=true) String code) {
        String kaptchaValue = this.getKaptchaCode(request);
        return kaptchaValue != null && code.equalsIgnoreCase(kaptchaValue);
    }

    private String getKaptchaCode(HttpServletRequest request) {
        String kaptchaValue = (String)request.getSession().getAttribute("KAPTCHA_SESSION_KEY");
        return kaptchaValue;
    }

    @RequestMapping(value={"/ajaxLogout"})
    @ResponseBody
    public String ajaxLogout() {
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return "success";
    }
}

