/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import java.io.Serializable;
import net.parim.common.persistence.BaseEntity;
import net.parim.system.entity.Dict;
import net.parim.system.entity.PermissionTarget;
import net.parim.system.entity.Site;
import net.parim.system.entity.UserGroup;
import net.parim.system.persistent.DataEntity;
import net.parim.system.service.DictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${adminPath}/sys/dict"})
public class DictController {
    @Value(value="${adminPath}")
    String adminPath;
    @Autowired
    DictService dictService;

    @RequestMapping(value={"/list"})
    public String list(@PageableDefault Pageable pageable, PermissionTarget permissionTarget, Dict dict, Model model) {
        if (permissionTarget.getObjectType() == PermissionTarget.ObjectType.S) {
            Site site = new Site();
            site.setId(permissionTarget.getId());
        }
        if (permissionTarget.getObjectType() == PermissionTarget.ObjectType.O) {
            UserGroup userGroup = new UserGroup();
            userGroup.setId(permissionTarget.getId());
        }
        if (null == dict) {
            dict = new Dict();
        }
        Page dicts = this.dictService.findAll((BaseEntity)dict, pageable);
        model.addAttribute("dicts", (Object)dicts);
        return "admin/sys/dictList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new Dict());
        return "admin/sys/dictProperties";
    }

    @RequestMapping(value={"/save"})
    public String save(Dict dict, PermissionTarget pt, Model model) {
        this.dictService.save((DataEntity)dict);
        return "redirect:" + this.adminPath + "/sys/dict/list";
    }

    @RequestMapping(value={"/properties/{id}"})
    public String properties(@PathVariable Long id, Model model) {
        Dict dict = (Dict)this.dictService.findOne((Serializable)id);
        model.addAttribute((Object)dict);
        return "admin/sys/dictProperties";
    }

    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable Long id) {
        Dict dict = (Dict)this.dictService.findOne((Serializable)id);
        if (dict != null) {
            this.dictService.delete((BaseEntity)dict);
        }
        return "redirect:" + this.adminPath + "/sys/dict/list";
    }
}

