/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.parim.common.utils.StringUtils;
import net.parim.common.web.BaseController;
import net.parim.system.entity.Menu;
import net.parim.system.service.SystemService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/menu"})
public class MenuController
extends BaseController {
    @Value(value="${adminPath}")
    private String adminPath;
    @Autowired
    SystemService systemService;

    @RequiresPermissions(value={"system:menu:view"})
    @RequestMapping(value={"/"})
    public String list(Model model) {
        List menus = this.systemService.findAllMenu();
        model.addAttribute("menuList", (Object)menus);
        return "admin/sys/menuList";
    }

    @RequiresPermissions(value={"system:menu:edit"})
    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new Menu());
        return "admin/sys/menuProperties";
    }

    @RequiresPermissions(value={"system:menu:edit"})
    @RequestMapping(value={"/properties/{id}"})
    public String properties(@PathVariable Long id, Model model) {
        Menu menu = this.systemService.findMenuById(id);
        model.addAttribute((Object)menu);
        return "admin/sys/menuProperties";
    }

    @RequiresPermissions(value={"system:menu:edit"})
    @RequestMapping(value={"/addsub/{id}"})
    public String addSub(@PathVariable Long id, Model model) {
        Menu menu = new Menu();
        Menu parent = this.systemService.findMenuById(id);
        menu.setParent(parent);
        model.addAttribute((Object)menu);
        return "admin/sys/menuProperties";
    }

    @RequiresPermissions(value={"system:menu:edit"})
    @RequestMapping(value={"/save"})
    public String save(@Valid Menu menu, BindingResult result, Model model, RedirectAttributes redirectAttributes) {
        if (result.hasErrors()) {
            this.addBindingError(model, result);
            return "admin/sys/menuProperties";
        }
        LocaleContextHolder.getLocale();
        this.systemService.saveMenu(menu);
        this.addSuccess(redirectAttributes, "menu.save.success", new String[]{menu.getName()});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @RequiresPermissions(value={"system:menu:delete"})
    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable Long id, RedirectAttributes redirectAttributes) {
        Menu menu = this.systemService.findMenuById(id);
        this.systemService.removeMenu(menu);
        this.addSuccess(redirectAttributes, "menu.delete.success", new String[]{menu.getName()});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<Map<String, Object>> treeData(@RequestParam(required=false) Long extId, @RequestParam(required=false) String isShowHide, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        List menus = this.systemService.findAllMenu();
        Menu extMenu = (Menu)this.systemService.findOne((Serializable)extId);
        for (int i = 0; i < menus.size(); ++i) {
            Menu menu = (Menu)menus.get(i);
            if (!StringUtils.isBlank((Long)extId) && (extId == null || extId.equals(menu.getId()) || this.isParent(menu, extMenu)) || !menu.getIsShow().booleanValue()) continue;
            HashMap map = Maps.newHashMap();
            map.put("id", menu.getId());
            map.put("pId", menu.getParentId());
            map.put("name", menu.getName());
            mapList.add(map);
        }
        return mapList;
    }

    private boolean isParent(Menu child, Menu parent) {
        List menus = this.systemService.findAllParents(child);
        for (Menu menu : menus) {
            if (menu.getId() != parent.getId()) continue;
            return true;
        }
        return false;
    }
}

