/*
 * Decompiled with CFR 0.152.
 */
package net.parim.system.web.admin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.parim.system.entity.Office;
import net.parim.system.service.OfficeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/office"})
public class OfficeManagerController {
    @Autowired
    OfficeService officeService;

    @RequestMapping(value={"/"})
    public String index() {
        return "admin/sys/officeIndex";
    }

    @RequestMapping(value={"/list"})
    public String list(Office office, Model model) {
        List offices = this.officeService.findAll(office);
        model.addAttribute("offices", (Object)offices);
        return "admin/sys/officeList";
    }

    @RequestMapping(value={"/properties"})
    public String properties(Model model) {
        model.addAttribute((Object)new Office());
        return "admin/sys/officeProperties";
    }

    @RequestMapping(value={"/treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(@RequestParam(required=false, defaultValue="0") Long extId) {
        ArrayList mapList = Lists.newArrayList();
        List offices = this.officeService.findAll();
        for (Office office : offices) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", office.getId());
            map.put("pid", office.getParent().getId());
            map.put("name", office.getName());
            mapList.add(map);
        }
        return mapList;
    }
}

